/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartQueryRequest extends CloudTrailRequest implements
        ToCopyableBuilder<StartQueryRequest.Builder, StartQueryRequest> {
    private static final SdkField<String> QUERY_STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryStatement").getter(getter(StartQueryRequest::queryStatement))
            .setter(setter(Builder::queryStatement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatement").build()).build();

    private static final SdkField<String> DELIVERY_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryS3Uri").getter(getter(StartQueryRequest::deliveryS3Uri)).setter(setter(Builder::deliveryS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3Uri").build()).build();

    private static final SdkField<String> QUERY_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryAlias").getter(getter(StartQueryRequest::queryAlias)).setter(setter(Builder::queryAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAlias").build()).build();

    private static final SdkField<List<String>> QUERY_PARAMETERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("QueryParameters")
            .getter(getter(StartQueryRequest::queryParameters))
            .setter(setter(Builder::queryParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EventDataStoreOwnerAccountId")
            .getter(getter(StartQueryRequest::eventDataStoreOwnerAccountId))
            .setter(setter(Builder::eventDataStoreOwnerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreOwnerAccountId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STATEMENT_FIELD,
            DELIVERY_S3_URI_FIELD, QUERY_ALIAS_FIELD, QUERY_PARAMETERS_FIELD, EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String queryStatement;

    private final String deliveryS3Uri;

    private final String queryAlias;

    private final List<String> queryParameters;

    private final String eventDataStoreOwnerAccountId;

    private StartQueryRequest(BuilderImpl builder) {
        super(builder);
        this.queryStatement = builder.queryStatement;
        this.deliveryS3Uri = builder.deliveryS3Uri;
        this.queryAlias = builder.queryAlias;
        this.queryParameters = builder.queryParameters;
        this.eventDataStoreOwnerAccountId = builder.eventDataStoreOwnerAccountId;
    }

    /**
     * <p>
     * The SQL code of your query.
     * </p>
     * 
     * @return The SQL code of your query.
     */
    public final String queryStatement() {
        return queryStatement;
    }

    /**
     * <p>
     * The URI for the S3 bucket where CloudTrail delivers the query results.
     * </p>
     * 
     * @return The URI for the S3 bucket where CloudTrail delivers the query results.
     */
    public final String deliveryS3Uri() {
        return deliveryS3Uri;
    }

    /**
     * <p>
     * The alias that identifies a query template.
     * </p>
     * 
     * @return The alias that identifies a query template.
     */
    public final String queryAlias() {
        return queryAlias;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryParameters() {
        return queryParameters != null && !(queryParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The query parameters for the specified <code>QueryAlias</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryParameters} method.
     * </p>
     * 
     * @return The query parameters for the specified <code>QueryAlias</code>.
     */
    public final List<String> queryParameters() {
        return queryParameters;
    }

    /**
     * <p>
     * The account ID of the event data store owner.
     * </p>
     * 
     * @return The account ID of the event data store owner.
     */
    public final String eventDataStoreOwnerAccountId() {
        return eventDataStoreOwnerAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryStatement());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(queryAlias());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryParameters() ? queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStoreOwnerAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryRequest)) {
            return false;
        }
        StartQueryRequest other = (StartQueryRequest) obj;
        return Objects.equals(queryStatement(), other.queryStatement()) && Objects.equals(deliveryS3Uri(), other.deliveryS3Uri())
                && Objects.equals(queryAlias(), other.queryAlias()) && hasQueryParameters() == other.hasQueryParameters()
                && Objects.equals(queryParameters(), other.queryParameters())
                && Objects.equals(eventDataStoreOwnerAccountId(), other.eventDataStoreOwnerAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartQueryRequest").add("QueryStatement", queryStatement())
                .add("DeliveryS3Uri", deliveryS3Uri()).add("QueryAlias", queryAlias())
                .add("QueryParameters", hasQueryParameters() ? queryParameters() : null)
                .add("EventDataStoreOwnerAccountId", eventDataStoreOwnerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryStatement":
            return Optional.ofNullable(clazz.cast(queryStatement()));
        case "DeliveryS3Uri":
            return Optional.ofNullable(clazz.cast(deliveryS3Uri()));
        case "QueryAlias":
            return Optional.ofNullable(clazz.cast(queryAlias()));
        case "QueryParameters":
            return Optional.ofNullable(clazz.cast(queryParameters()));
        case "EventDataStoreOwnerAccountId":
            return Optional.ofNullable(clazz.cast(eventDataStoreOwnerAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryStatement", QUERY_STATEMENT_FIELD);
        map.put("DeliveryS3Uri", DELIVERY_S3_URI_FIELD);
        map.put("QueryAlias", QUERY_ALIAS_FIELD);
        map.put("QueryParameters", QUERY_PARAMETERS_FIELD);
        map.put("EventDataStoreOwnerAccountId", EVENT_DATA_STORE_OWNER_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartQueryRequest, T> g) {
        return obj -> g.apply((StartQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartQueryRequest> {
        /**
         * <p>
         * The SQL code of your query.
         * </p>
         * 
         * @param queryStatement
         *        The SQL code of your query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStatement(String queryStatement);

        /**
         * <p>
         * The URI for the S3 bucket where CloudTrail delivers the query results.
         * </p>
         * 
         * @param deliveryS3Uri
         *        The URI for the S3 bucket where CloudTrail delivers the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryS3Uri(String deliveryS3Uri);

        /**
         * <p>
         * The alias that identifies a query template.
         * </p>
         * 
         * @param queryAlias
         *        The alias that identifies a query template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryAlias(String queryAlias);

        /**
         * <p>
         * The query parameters for the specified <code>QueryAlias</code>.
         * </p>
         * 
         * @param queryParameters
         *        The query parameters for the specified <code>QueryAlias</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(Collection<String> queryParameters);

        /**
         * <p>
         * The query parameters for the specified <code>QueryAlias</code>.
         * </p>
         * 
         * @param queryParameters
         *        The query parameters for the specified <code>QueryAlias</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(String... queryParameters);

        /**
         * <p>
         * The account ID of the event data store owner.
         * </p>
         * 
         * @param eventDataStoreOwnerAccountId
         *        The account ID of the event data store owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String queryStatement;

        private String deliveryS3Uri;

        private String queryAlias;

        private List<String> queryParameters = DefaultSdkAutoConstructList.getInstance();

        private String eventDataStoreOwnerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryRequest model) {
            super(model);
            queryStatement(model.queryStatement);
            deliveryS3Uri(model.deliveryS3Uri);
            queryAlias(model.queryAlias);
            queryParameters(model.queryParameters);
            eventDataStoreOwnerAccountId(model.eventDataStoreOwnerAccountId);
        }

        public final String getQueryStatement() {
            return queryStatement;
        }

        public final void setQueryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
        }

        @Override
        public final Builder queryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
            return this;
        }

        public final String getDeliveryS3Uri() {
            return deliveryS3Uri;
        }

        public final void setDeliveryS3Uri(String deliveryS3Uri) {
            this.deliveryS3Uri = deliveryS3Uri;
        }

        @Override
        public final Builder deliveryS3Uri(String deliveryS3Uri) {
            this.deliveryS3Uri = deliveryS3Uri;
            return this;
        }

        public final String getQueryAlias() {
            return queryAlias;
        }

        public final void setQueryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
        }

        @Override
        public final Builder queryAlias(String queryAlias) {
            this.queryAlias = queryAlias;
            return this;
        }

        public final Collection<String> getQueryParameters() {
            if (queryParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return queryParameters;
        }

        public final void setQueryParameters(Collection<String> queryParameters) {
            this.queryParameters = QueryParametersCopier.copy(queryParameters);
        }

        @Override
        public final Builder queryParameters(Collection<String> queryParameters) {
            this.queryParameters = QueryParametersCopier.copy(queryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(String... queryParameters) {
            queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        public final String getEventDataStoreOwnerAccountId() {
            return eventDataStoreOwnerAccountId;
        }

        public final void setEventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
        }

        @Override
        public final Builder eventDataStoreOwnerAccountId(String eventDataStoreOwnerAccountId) {
            this.eventDataStoreOwnerAccountId = eventDataStoreOwnerAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQueryRequest build() {
            return new StartQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
