/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateQueryRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, GenerateQueryRequest> {
    private static final SdkField<List<String>> EVENT_DATA_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventDataStores").getter(GenerateQueryRequest.getter(GenerateQueryRequest::eventDataStores)).setter(GenerateQueryRequest.setter(Builder::eventDataStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prompt").getter(GenerateQueryRequest.getter(GenerateQueryRequest::prompt)).setter(GenerateQueryRequest.setter(Builder::prompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prompt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORES_FIELD, PROMPT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerateQueryRequest.memberNameToFieldInitializer();
    private final List<String> eventDataStores;
    private final String prompt;

    private GenerateQueryRequest(BuilderImpl builder) {
        super(builder);
        this.eventDataStores = builder.eventDataStores;
        this.prompt = builder.prompt;
    }

    public final boolean hasEventDataStores() {
        return this.eventDataStores != null && !(this.eventDataStores instanceof SdkAutoConstructList);
    }

    public final List<String> eventDataStores() {
        return this.eventDataStores;
    }

    public final String prompt() {
        return this.prompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventDataStores() ? this.eventDataStores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.prompt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateQueryRequest)) {
            return false;
        }
        GenerateQueryRequest other = (GenerateQueryRequest)((Object)obj);
        return this.hasEventDataStores() == other.hasEventDataStores() && Objects.equals(this.eventDataStores(), other.eventDataStores()) && Objects.equals(this.prompt(), other.prompt());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateQueryRequest").add("EventDataStores", this.hasEventDataStores() ? this.eventDataStores() : null).add("Prompt", (Object)this.prompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDataStores": {
                return Optional.ofNullable(clazz.cast(this.eventDataStores()));
            }
            case "Prompt": {
                return Optional.ofNullable(clazz.cast(this.prompt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventDataStores", EVENT_DATA_STORES_FIELD);
        map.put("Prompt", PROMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateQueryRequest, T> g) {
        return obj -> g.apply((GenerateQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private List<String> eventDataStores = DefaultSdkAutoConstructList.getInstance();
        private String prompt;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateQueryRequest model) {
            super(model);
            this.eventDataStores(model.eventDataStores);
            this.prompt(model.prompt);
        }

        public final Collection<String> getEventDataStores() {
            if (this.eventDataStores instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventDataStores;
        }

        public final void setEventDataStores(Collection<String> eventDataStores) {
            this.eventDataStores = EventDataStoreListCopier.copy(eventDataStores);
        }

        @Override
        public final Builder eventDataStores(Collection<String> eventDataStores) {
            this.eventDataStores = EventDataStoreListCopier.copy(eventDataStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDataStores(String ... eventDataStores) {
            this.eventDataStores(Arrays.asList(eventDataStores));
            return this;
        }

        public final String getPrompt() {
            return this.prompt;
        }

        public final void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public final Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateQueryRequest build() {
            return new GenerateQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateQueryRequest> {
        public Builder eventDataStores(Collection<String> var1);

        public Builder eventDataStores(String ... var1);

        public Builder prompt(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

