/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeliveryRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<CreateDeliveryRequest.Builder, CreateDeliveryRequest> {
    private static final SdkField<String> DELIVERY_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deliverySourceName").getter(getter(CreateDeliveryRequest::deliverySourceName))
            .setter(setter(Builder::deliverySourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliverySourceName").build())
            .build();

    private static final SdkField<String> DELIVERY_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deliveryDestinationArn").getter(getter(CreateDeliveryRequest::deliveryDestinationArn))
            .setter(setter(Builder::deliveryDestinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationArn").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDeliveryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_SOURCE_NAME_FIELD,
            DELIVERY_DESTINATION_ARN_FIELD, TAGS_FIELD));

    private final String deliverySourceName;

    private final String deliveryDestinationArn;

    private final Map<String, String> tags;

    private CreateDeliveryRequest(BuilderImpl builder) {
        super(builder);
        this.deliverySourceName = builder.deliverySourceName;
        this.deliveryDestinationArn = builder.deliveryDestinationArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the delivery source to use for this delivery.
     * </p>
     * 
     * @return The name of the delivery source to use for this delivery.
     */
    public final String deliverySourceName() {
        return deliverySourceName;
    }

    /**
     * <p>
     * The ARN of the delivery destination to use for this delivery.
     * </p>
     * 
     * @return The ARN of the delivery destination to use for this delivery.
     */
    public final String deliveryDestinationArn() {
        return deliveryDestinationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional list of key-value pairs to associate with the resource.
     * </p>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional list of key-value pairs to associate with the resource.</p>
     *         <p>
     *         For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliverySourceName());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliveryRequest)) {
            return false;
        }
        CreateDeliveryRequest other = (CreateDeliveryRequest) obj;
        return Objects.equals(deliverySourceName(), other.deliverySourceName())
                && Objects.equals(deliveryDestinationArn(), other.deliveryDestinationArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeliveryRequest").add("DeliverySourceName", deliverySourceName())
                .add("DeliveryDestinationArn", deliveryDestinationArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deliverySourceName":
            return Optional.ofNullable(clazz.cast(deliverySourceName()));
        case "deliveryDestinationArn":
            return Optional.ofNullable(clazz.cast(deliveryDestinationArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeliveryRequest, T> g) {
        return obj -> g.apply((CreateDeliveryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeliveryRequest> {
        /**
         * <p>
         * The name of the delivery source to use for this delivery.
         * </p>
         * 
         * @param deliverySourceName
         *        The name of the delivery source to use for this delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverySourceName(String deliverySourceName);

        /**
         * <p>
         * The ARN of the delivery destination to use for this delivery.
         * </p>
         * 
         * @param deliveryDestinationArn
         *        The ARN of the delivery destination to use for this delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryDestinationArn(String deliveryDestinationArn);

        /**
         * <p>
         * An optional list of key-value pairs to associate with the resource.
         * </p>
         * <p>
         * For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a>
         * </p>
         * 
         * @param tags
         *        An optional list of key-value pairs to associate with the resource.</p>
         *        <p>
         *        For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String deliverySourceName;

        private String deliveryDestinationArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliveryRequest model) {
            super(model);
            deliverySourceName(model.deliverySourceName);
            deliveryDestinationArn(model.deliveryDestinationArn);
            tags(model.tags);
        }

        public final String getDeliverySourceName() {
            return deliverySourceName;
        }

        public final void setDeliverySourceName(String deliverySourceName) {
            this.deliverySourceName = deliverySourceName;
        }

        @Override
        public final Builder deliverySourceName(String deliverySourceName) {
            this.deliverySourceName = deliverySourceName;
            return this;
        }

        public final String getDeliveryDestinationArn() {
            return deliveryDestinationArn;
        }

        public final void setDeliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
        }

        @Override
        public final Builder deliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeliveryRequest build() {
            return new CreateDeliveryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
