/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationTemplatesResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DescribeConfigurationTemplatesResponse.Builder, DescribeConfigurationTemplatesResponse> {
    private static final SdkField<List<ConfigurationTemplate>> CONFIGURATION_TEMPLATES_FIELD = SdkField
            .<List<ConfigurationTemplate>> builder(MarshallingType.LIST)
            .memberName("configurationTemplates")
            .getter(getter(DescribeConfigurationTemplatesResponse::configurationTemplates))
            .setter(setter(Builder::configurationTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationTemplates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeConfigurationTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TEMPLATES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConfigurationTemplate> configurationTemplates;

    private final String nextToken;

    private DescribeConfigurationTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.configurationTemplates = builder.configurationTemplates;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationTemplates property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfigurationTemplates() {
        return configurationTemplates != null && !(configurationTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, where each object describes one configuration template that matches the filters that you
     * specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationTemplates} method.
     * </p>
     * 
     * @return An array of objects, where each object describes one configuration template that matches the filters that
     *         you specified in the request.
     */
    public final List<ConfigurationTemplate> configurationTemplates() {
        return configurationTemplates;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationTemplates() ? configurationTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationTemplatesResponse)) {
            return false;
        }
        DescribeConfigurationTemplatesResponse other = (DescribeConfigurationTemplatesResponse) obj;
        return hasConfigurationTemplates() == other.hasConfigurationTemplates()
                && Objects.equals(configurationTemplates(), other.configurationTemplates())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigurationTemplatesResponse")
                .add("ConfigurationTemplates", hasConfigurationTemplates() ? configurationTemplates() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurationTemplates":
            return Optional.ofNullable(clazz.cast(configurationTemplates()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configurationTemplates", CONFIGURATION_TEMPLATES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationTemplatesResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationTemplatesResponse> {
        /**
         * <p>
         * An array of objects, where each object describes one configuration template that matches the filters that you
         * specified in the request.
         * </p>
         * 
         * @param configurationTemplates
         *        An array of objects, where each object describes one configuration template that matches the filters
         *        that you specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationTemplates(Collection<ConfigurationTemplate> configurationTemplates);

        /**
         * <p>
         * An array of objects, where each object describes one configuration template that matches the filters that you
         * specified in the request.
         * </p>
         * 
         * @param configurationTemplates
         *        An array of objects, where each object describes one configuration template that matches the filters
         *        that you specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationTemplates(ConfigurationTemplate... configurationTemplates);

        /**
         * <p>
         * An array of objects, where each object describes one configuration template that matches the filters that you
         * specified in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.ConfigurationTemplate.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.ConfigurationTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.ConfigurationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationTemplates(List<ConfigurationTemplate>)}.
         * 
         * @param configurationTemplates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.ConfigurationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationTemplates(java.util.Collection<ConfigurationTemplate>)
         */
        Builder configurationTemplates(Consumer<ConfigurationTemplate.Builder>... configurationTemplates);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<ConfigurationTemplate> configurationTemplates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationTemplatesResponse model) {
            super(model);
            configurationTemplates(model.configurationTemplates);
            nextToken(model.nextToken);
        }

        public final List<ConfigurationTemplate.Builder> getConfigurationTemplates() {
            List<ConfigurationTemplate.Builder> result = ConfigurationTemplatesCopier.copyToBuilder(this.configurationTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationTemplates(Collection<ConfigurationTemplate.BuilderImpl> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplatesCopier.copyFromBuilder(configurationTemplates);
        }

        @Override
        public final Builder configurationTemplates(Collection<ConfigurationTemplate> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplatesCopier.copy(configurationTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationTemplates(ConfigurationTemplate... configurationTemplates) {
            configurationTemplates(Arrays.asList(configurationTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationTemplates(Consumer<ConfigurationTemplate.Builder>... configurationTemplates) {
            configurationTemplates(Stream.of(configurationTemplates)
                    .map(c -> ConfigurationTemplate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeConfigurationTemplatesResponse build() {
            return new DescribeConfigurationTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
