/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutIntegrationResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<PutIntegrationResponse.Builder, PutIntegrationResponse> {
    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationName").getter(getter(PutIntegrationResponse::integrationName))
            .setter(setter(Builder::integrationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationName").build()).build();

    private static final SdkField<String> INTEGRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationStatus").getter(getter(PutIntegrationResponse::integrationStatusAsString))
            .setter(setter(Builder::integrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_NAME_FIELD,
            INTEGRATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String integrationName;

    private final String integrationStatus;

    private PutIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.integrationName = builder.integrationName;
        this.integrationStatus = builder.integrationStatus;
    }

    /**
     * <p>
     * The name of the integration that you just created.
     * </p>
     * 
     * @return The name of the integration that you just created.
     */
    public final String integrationName() {
        return integrationName;
    }

    /**
     * <p>
     * The status of the integration that you just created.
     * </p>
     * <p>
     * After you create an integration, it takes a few minutes to complete. During this time, you'll see the status as
     * <code>PROVISIONING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationStatus}
     * will return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationStatusAsString}.
     * </p>
     * 
     * @return The status of the integration that you just created.</p>
     *         <p>
     *         After you create an integration, it takes a few minutes to complete. During this time, you'll see the
     *         status as <code>PROVISIONING</code>.
     * @see IntegrationStatus
     */
    public final IntegrationStatus integrationStatus() {
        return IntegrationStatus.fromValue(integrationStatus);
    }

    /**
     * <p>
     * The status of the integration that you just created.
     * </p>
     * <p>
     * After you create an integration, it takes a few minutes to complete. During this time, you'll see the status as
     * <code>PROVISIONING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationStatus}
     * will return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationStatusAsString}.
     * </p>
     * 
     * @return The status of the integration that you just created.</p>
     *         <p>
     *         After you create an integration, it takes a few minutes to complete. During this time, you'll see the
     *         status as <code>PROVISIONING</code>.
     * @see IntegrationStatus
     */
    public final String integrationStatusAsString() {
        return integrationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(integrationName());
        hashCode = 31 * hashCode + Objects.hashCode(integrationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationResponse)) {
            return false;
        }
        PutIntegrationResponse other = (PutIntegrationResponse) obj;
        return Objects.equals(integrationName(), other.integrationName())
                && Objects.equals(integrationStatusAsString(), other.integrationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutIntegrationResponse").add("IntegrationName", integrationName())
                .add("IntegrationStatus", integrationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integrationName":
            return Optional.ofNullable(clazz.cast(integrationName()));
        case "integrationStatus":
            return Optional.ofNullable(clazz.cast(integrationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("integrationName", INTEGRATION_NAME_FIELD);
        map.put("integrationStatus", INTEGRATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutIntegrationResponse, T> g) {
        return obj -> g.apply((PutIntegrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutIntegrationResponse> {
        /**
         * <p>
         * The name of the integration that you just created.
         * </p>
         * 
         * @param integrationName
         *        The name of the integration that you just created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationName(String integrationName);

        /**
         * <p>
         * The status of the integration that you just created.
         * </p>
         * <p>
         * After you create an integration, it takes a few minutes to complete. During this time, you'll see the status
         * as <code>PROVISIONING</code>.
         * </p>
         * 
         * @param integrationStatus
         *        The status of the integration that you just created.</p>
         *        <p>
         *        After you create an integration, it takes a few minutes to complete. During this time, you'll see the
         *        status as <code>PROVISIONING</code>.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder integrationStatus(String integrationStatus);

        /**
         * <p>
         * The status of the integration that you just created.
         * </p>
         * <p>
         * After you create an integration, it takes a few minutes to complete. During this time, you'll see the status
         * as <code>PROVISIONING</code>.
         * </p>
         * 
         * @param integrationStatus
         *        The status of the integration that you just created.</p>
         *        <p>
         *        After you create an integration, it takes a few minutes to complete. During this time, you'll see the
         *        status as <code>PROVISIONING</code>.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder integrationStatus(IntegrationStatus integrationStatus);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private String integrationName;

        private String integrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationResponse model) {
            super(model);
            integrationName(model.integrationName);
            integrationStatus(model.integrationStatus);
        }

        public final String getIntegrationName() {
            return integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public final String getIntegrationStatus() {
            return integrationStatus;
        }

        public final void setIntegrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
        }

        @Override
        public final Builder integrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
            return this;
        }

        @Override
        public final Builder integrationStatus(IntegrationStatus integrationStatus) {
            this.integrationStatus(integrationStatus == null ? null : integrationStatus.toString());
            return this;
        }

        @Override
        public PutIntegrationResponse build() {
            return new PutIntegrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
