/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestTransformerRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<TestTransformerRequest.Builder, TestTransformerRequest> {
    private static final SdkField<List<Processor>> TRANSFORMER_CONFIG_FIELD = SdkField
            .<List<Processor>> builder(MarshallingType.LIST)
            .memberName("transformerConfig")
            .getter(getter(TestTransformerRequest::transformerConfig))
            .setter(setter(Builder::transformerConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Processor> builder(MarshallingType.SDK_POJO)
                                            .constructor(Processor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOG_EVENT_MESSAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logEventMessages")
            .getter(getter(TestTransformerRequest::logEventMessages))
            .setter(setter(Builder::logEventMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logEventMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMER_CONFIG_FIELD,
            LOG_EVENT_MESSAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Processor> transformerConfig;

    private final List<String> logEventMessages;

    private TestTransformerRequest(BuilderImpl builder) {
        super(builder);
        this.transformerConfig = builder.transformerConfig;
        this.logEventMessages = builder.logEventMessages;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransformerConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransformerConfig() {
        return transformerConfig != null && !(transformerConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This structure contains the configuration of this log transformer that you want to test. A log transformer is an
     * array of processors, where each processor applies one type of transformation to the log events that are ingested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransformerConfig} method.
     * </p>
     * 
     * @return This structure contains the configuration of this log transformer that you want to test. A log
     *         transformer is an array of processors, where each processor applies one type of transformation to the log
     *         events that are ingested.
     */
    public final List<Processor> transformerConfig() {
        return transformerConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogEventMessages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogEventMessages() {
        return logEventMessages != null && !(logEventMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the raw log events that you want to use to test this transformer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogEventMessages} method.
     * </p>
     * 
     * @return An array of the raw log events that you want to use to test this transformer.
     */
    public final List<String> logEventMessages() {
        return logEventMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransformerConfig() ? transformerConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogEventMessages() ? logEventMessages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestTransformerRequest)) {
            return false;
        }
        TestTransformerRequest other = (TestTransformerRequest) obj;
        return hasTransformerConfig() == other.hasTransformerConfig()
                && Objects.equals(transformerConfig(), other.transformerConfig())
                && hasLogEventMessages() == other.hasLogEventMessages()
                && Objects.equals(logEventMessages(), other.logEventMessages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestTransformerRequest")
                .add("TransformerConfig", hasTransformerConfig() ? transformerConfig() : null)
                .add("LogEventMessages", hasLogEventMessages() ? logEventMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transformerConfig":
            return Optional.ofNullable(clazz.cast(transformerConfig()));
        case "logEventMessages":
            return Optional.ofNullable(clazz.cast(logEventMessages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transformerConfig", TRANSFORMER_CONFIG_FIELD);
        map.put("logEventMessages", LOG_EVENT_MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestTransformerRequest, T> g) {
        return obj -> g.apply((TestTransformerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestTransformerRequest> {
        /**
         * <p>
         * This structure contains the configuration of this log transformer that you want to test. A log transformer is
         * an array of processors, where each processor applies one type of transformation to the log events that are
         * ingested.
         * </p>
         * 
         * @param transformerConfig
         *        This structure contains the configuration of this log transformer that you want to test. A log
         *        transformer is an array of processors, where each processor applies one type of transformation to the
         *        log events that are ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerConfig(Collection<Processor> transformerConfig);

        /**
         * <p>
         * This structure contains the configuration of this log transformer that you want to test. A log transformer is
         * an array of processors, where each processor applies one type of transformation to the log events that are
         * ingested.
         * </p>
         * 
         * @param transformerConfig
         *        This structure contains the configuration of this log transformer that you want to test. A log
         *        transformer is an array of processors, where each processor applies one type of transformation to the
         *        log events that are ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerConfig(Processor... transformerConfig);

        /**
         * <p>
         * This structure contains the configuration of this log transformer that you want to test. A log transformer is
         * an array of processors, where each processor applies one type of transformation to the log events that are
         * ingested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.Processor.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudwatchlogs.model.Processor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchlogs.model.Processor.Builder#build()} is called immediately
         * and its result is passed to {@link #transformerConfig(List<Processor>)}.
         * 
         * @param transformerConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchlogs.model.Processor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformerConfig(java.util.Collection<Processor>)
         */
        Builder transformerConfig(Consumer<Processor.Builder>... transformerConfig);

        /**
         * <p>
         * An array of the raw log events that you want to use to test this transformer.
         * </p>
         * 
         * @param logEventMessages
         *        An array of the raw log events that you want to use to test this transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEventMessages(Collection<String> logEventMessages);

        /**
         * <p>
         * An array of the raw log events that you want to use to test this transformer.
         * </p>
         * 
         * @param logEventMessages
         *        An array of the raw log events that you want to use to test this transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEventMessages(String... logEventMessages);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private List<Processor> transformerConfig = DefaultSdkAutoConstructList.getInstance();

        private List<String> logEventMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestTransformerRequest model) {
            super(model);
            transformerConfig(model.transformerConfig);
            logEventMessages(model.logEventMessages);
        }

        public final List<Processor.Builder> getTransformerConfig() {
            List<Processor.Builder> result = ProcessorsCopier.copyToBuilder(this.transformerConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformerConfig(Collection<Processor.BuilderImpl> transformerConfig) {
            this.transformerConfig = ProcessorsCopier.copyFromBuilder(transformerConfig);
        }

        @Override
        public final Builder transformerConfig(Collection<Processor> transformerConfig) {
            this.transformerConfig = ProcessorsCopier.copy(transformerConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformerConfig(Processor... transformerConfig) {
            transformerConfig(Arrays.asList(transformerConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformerConfig(Consumer<Processor.Builder>... transformerConfig) {
            transformerConfig(Stream.of(transformerConfig).map(c -> Processor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getLogEventMessages() {
            if (logEventMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return logEventMessages;
        }

        public final void setLogEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
        }

        @Override
        public final Builder logEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEventMessages(String... logEventMessages) {
            logEventMessages(Arrays.asList(logEventMessages));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestTransformerRequest build() {
            return new TestTransformerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
