/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information for one log event that has been processed by a log transformer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformedLogRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformedLogRecord.Builder, TransformedLogRecord> {
    private static final SdkField<Long> EVENT_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("eventNumber").getter(getter(TransformedLogRecord::eventNumber)).setter(setter(Builder::eventNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventNumber").build()).build();

    private static final SdkField<String> EVENT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventMessage").getter(getter(TransformedLogRecord::eventMessage)).setter(setter(Builder::eventMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventMessage").build()).build();

    private static final SdkField<String> TRANSFORMED_EVENT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transformedEventMessage").getter(getter(TransformedLogRecord::transformedEventMessage))
            .setter(setter(Builder::transformedEventMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformedEventMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_NUMBER_FIELD,
            EVENT_MESSAGE_FIELD, TRANSFORMED_EVENT_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long eventNumber;

    private final String eventMessage;

    private final String transformedEventMessage;

    private TransformedLogRecord(BuilderImpl builder) {
        this.eventNumber = builder.eventNumber;
        this.eventMessage = builder.eventMessage;
        this.transformedEventMessage = builder.transformedEventMessage;
    }

    /**
     * <p>
     * The event number.
     * </p>
     * 
     * @return The event number.
     */
    public final Long eventNumber() {
        return eventNumber;
    }

    /**
     * <p>
     * The original log event message before it was transformed.
     * </p>
     * 
     * @return The original log event message before it was transformed.
     */
    public final String eventMessage() {
        return eventMessage;
    }

    /**
     * <p>
     * The log event message after being transformed.
     * </p>
     * 
     * @return The log event message after being transformed.
     */
    public final String transformedEventMessage() {
        return transformedEventMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventNumber());
        hashCode = 31 * hashCode + Objects.hashCode(eventMessage());
        hashCode = 31 * hashCode + Objects.hashCode(transformedEventMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformedLogRecord)) {
            return false;
        }
        TransformedLogRecord other = (TransformedLogRecord) obj;
        return Objects.equals(eventNumber(), other.eventNumber()) && Objects.equals(eventMessage(), other.eventMessage())
                && Objects.equals(transformedEventMessage(), other.transformedEventMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformedLogRecord").add("EventNumber", eventNumber()).add("EventMessage", eventMessage())
                .add("TransformedEventMessage", transformedEventMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventNumber":
            return Optional.ofNullable(clazz.cast(eventNumber()));
        case "eventMessage":
            return Optional.ofNullable(clazz.cast(eventMessage()));
        case "transformedEventMessage":
            return Optional.ofNullable(clazz.cast(transformedEventMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventNumber", EVENT_NUMBER_FIELD);
        map.put("eventMessage", EVENT_MESSAGE_FIELD);
        map.put("transformedEventMessage", TRANSFORMED_EVENT_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformedLogRecord, T> g) {
        return obj -> g.apply((TransformedLogRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformedLogRecord> {
        /**
         * <p>
         * The event number.
         * </p>
         * 
         * @param eventNumber
         *        The event number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventNumber(Long eventNumber);

        /**
         * <p>
         * The original log event message before it was transformed.
         * </p>
         * 
         * @param eventMessage
         *        The original log event message before it was transformed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventMessage(String eventMessage);

        /**
         * <p>
         * The log event message after being transformed.
         * </p>
         * 
         * @param transformedEventMessage
         *        The log event message after being transformed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformedEventMessage(String transformedEventMessage);
    }

    static final class BuilderImpl implements Builder {
        private Long eventNumber;

        private String eventMessage;

        private String transformedEventMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformedLogRecord model) {
            eventNumber(model.eventNumber);
            eventMessage(model.eventMessage);
            transformedEventMessage(model.transformedEventMessage);
        }

        public final Long getEventNumber() {
            return eventNumber;
        }

        public final void setEventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
        }

        @Override
        public final Builder eventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
            return this;
        }

        public final String getEventMessage() {
            return eventMessage;
        }

        public final void setEventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
        }

        @Override
        public final Builder eventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
            return this;
        }

        public final String getTransformedEventMessage() {
            return transformedEventMessage;
        }

        public final void setTransformedEventMessage(String transformedEventMessage) {
            this.transformedEventMessage = transformedEventMessage;
        }

        @Override
        public final Builder transformedEventMessage(String transformedEventMessage) {
            this.transformedEventMessage = transformedEventMessage;
            return this;
        }

        @Override
        public TransformedLogRecord build() {
            return new TransformedLogRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
