/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the auto-retry configuration for the build.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoRetryConfig implements SdkPojo, Serializable, ToCopyableBuilder<AutoRetryConfig.Builder, AutoRetryConfig> {
    private static final SdkField<Integer> AUTO_RETRY_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("autoRetryLimit").getter(getter(AutoRetryConfig::autoRetryLimit)).setter(setter(Builder::autoRetryLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRetryLimit").build()).build();

    private static final SdkField<Integer> AUTO_RETRY_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("autoRetryNumber").getter(getter(AutoRetryConfig::autoRetryNumber))
            .setter(setter(Builder::autoRetryNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRetryNumber").build()).build();

    private static final SdkField<String> NEXT_AUTO_RETRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextAutoRetry").getter(getter(AutoRetryConfig::nextAutoRetry)).setter(setter(Builder::nextAutoRetry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextAutoRetry").build()).build();

    private static final SdkField<String> PREVIOUS_AUTO_RETRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("previousAutoRetry").getter(getter(AutoRetryConfig::previousAutoRetry))
            .setter(setter(Builder::previousAutoRetry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousAutoRetry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_RETRY_LIMIT_FIELD,
            AUTO_RETRY_NUMBER_FIELD, NEXT_AUTO_RETRY_FIELD, PREVIOUS_AUTO_RETRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer autoRetryLimit;

    private final Integer autoRetryNumber;

    private final String nextAutoRetry;

    private final String previousAutoRetry;

    private AutoRetryConfig(BuilderImpl builder) {
        this.autoRetryLimit = builder.autoRetryLimit;
        this.autoRetryNumber = builder.autoRetryNumber;
        this.nextAutoRetry = builder.nextAutoRetry;
        this.previousAutoRetry = builder.previousAutoRetry;
    }

    /**
     * <p>
     * The maximum number of additional automatic retries after a failed build. For example, if the auto-retry limit is
     * set to 2, CodeBuild will call the <code>RetryBuild</code> API to automatically retry your build for up to 2
     * additional times.
     * </p>
     * 
     * @return The maximum number of additional automatic retries after a failed build. For example, if the auto-retry
     *         limit is set to 2, CodeBuild will call the <code>RetryBuild</code> API to automatically retry your build
     *         for up to 2 additional times.
     */
    public final Integer autoRetryLimit() {
        return autoRetryLimit;
    }

    /**
     * <p>
     * The number of times that the build has been retried. The initial build will have an auto-retry number of 0.
     * </p>
     * 
     * @return The number of times that the build has been retried. The initial build will have an auto-retry number of
     *         0.
     */
    public final Integer autoRetryNumber() {
        return autoRetryNumber;
    }

    /**
     * <p>
     * The build ARN of the auto-retried build triggered by the current build. The next auto-retry will be
     * <code>null</code> for builds that don't trigger an auto-retry.
     * </p>
     * 
     * @return The build ARN of the auto-retried build triggered by the current build. The next auto-retry will be
     *         <code>null</code> for builds that don't trigger an auto-retry.
     */
    public final String nextAutoRetry() {
        return nextAutoRetry;
    }

    /**
     * <p>
     * The build ARN of the build that triggered the current auto-retry build. The previous auto-retry will be
     * <code>null</code> for the initial build.
     * </p>
     * 
     * @return The build ARN of the build that triggered the current auto-retry build. The previous auto-retry will be
     *         <code>null</code> for the initial build.
     */
    public final String previousAutoRetry() {
        return previousAutoRetry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoRetryLimit());
        hashCode = 31 * hashCode + Objects.hashCode(autoRetryNumber());
        hashCode = 31 * hashCode + Objects.hashCode(nextAutoRetry());
        hashCode = 31 * hashCode + Objects.hashCode(previousAutoRetry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoRetryConfig)) {
            return false;
        }
        AutoRetryConfig other = (AutoRetryConfig) obj;
        return Objects.equals(autoRetryLimit(), other.autoRetryLimit())
                && Objects.equals(autoRetryNumber(), other.autoRetryNumber())
                && Objects.equals(nextAutoRetry(), other.nextAutoRetry())
                && Objects.equals(previousAutoRetry(), other.previousAutoRetry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoRetryConfig").add("AutoRetryLimit", autoRetryLimit())
                .add("AutoRetryNumber", autoRetryNumber()).add("NextAutoRetry", nextAutoRetry())
                .add("PreviousAutoRetry", previousAutoRetry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoRetryLimit":
            return Optional.ofNullable(clazz.cast(autoRetryLimit()));
        case "autoRetryNumber":
            return Optional.ofNullable(clazz.cast(autoRetryNumber()));
        case "nextAutoRetry":
            return Optional.ofNullable(clazz.cast(nextAutoRetry()));
        case "previousAutoRetry":
            return Optional.ofNullable(clazz.cast(previousAutoRetry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("autoRetryLimit", AUTO_RETRY_LIMIT_FIELD);
        map.put("autoRetryNumber", AUTO_RETRY_NUMBER_FIELD);
        map.put("nextAutoRetry", NEXT_AUTO_RETRY_FIELD);
        map.put("previousAutoRetry", PREVIOUS_AUTO_RETRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoRetryConfig, T> g) {
        return obj -> g.apply((AutoRetryConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoRetryConfig> {
        /**
         * <p>
         * The maximum number of additional automatic retries after a failed build. For example, if the auto-retry limit
         * is set to 2, CodeBuild will call the <code>RetryBuild</code> API to automatically retry your build for up to
         * 2 additional times.
         * </p>
         * 
         * @param autoRetryLimit
         *        The maximum number of additional automatic retries after a failed build. For example, if the
         *        auto-retry limit is set to 2, CodeBuild will call the <code>RetryBuild</code> API to automatically
         *        retry your build for up to 2 additional times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRetryLimit(Integer autoRetryLimit);

        /**
         * <p>
         * The number of times that the build has been retried. The initial build will have an auto-retry number of 0.
         * </p>
         * 
         * @param autoRetryNumber
         *        The number of times that the build has been retried. The initial build will have an auto-retry number
         *        of 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRetryNumber(Integer autoRetryNumber);

        /**
         * <p>
         * The build ARN of the auto-retried build triggered by the current build. The next auto-retry will be
         * <code>null</code> for builds that don't trigger an auto-retry.
         * </p>
         * 
         * @param nextAutoRetry
         *        The build ARN of the auto-retried build triggered by the current build. The next auto-retry will be
         *        <code>null</code> for builds that don't trigger an auto-retry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextAutoRetry(String nextAutoRetry);

        /**
         * <p>
         * The build ARN of the build that triggered the current auto-retry build. The previous auto-retry will be
         * <code>null</code> for the initial build.
         * </p>
         * 
         * @param previousAutoRetry
         *        The build ARN of the build that triggered the current auto-retry build. The previous auto-retry will
         *        be <code>null</code> for the initial build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousAutoRetry(String previousAutoRetry);
    }

    static final class BuilderImpl implements Builder {
        private Integer autoRetryLimit;

        private Integer autoRetryNumber;

        private String nextAutoRetry;

        private String previousAutoRetry;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoRetryConfig model) {
            autoRetryLimit(model.autoRetryLimit);
            autoRetryNumber(model.autoRetryNumber);
            nextAutoRetry(model.nextAutoRetry);
            previousAutoRetry(model.previousAutoRetry);
        }

        public final Integer getAutoRetryLimit() {
            return autoRetryLimit;
        }

        public final void setAutoRetryLimit(Integer autoRetryLimit) {
            this.autoRetryLimit = autoRetryLimit;
        }

        @Override
        public final Builder autoRetryLimit(Integer autoRetryLimit) {
            this.autoRetryLimit = autoRetryLimit;
            return this;
        }

        public final Integer getAutoRetryNumber() {
            return autoRetryNumber;
        }

        public final void setAutoRetryNumber(Integer autoRetryNumber) {
            this.autoRetryNumber = autoRetryNumber;
        }

        @Override
        public final Builder autoRetryNumber(Integer autoRetryNumber) {
            this.autoRetryNumber = autoRetryNumber;
            return this;
        }

        public final String getNextAutoRetry() {
            return nextAutoRetry;
        }

        public final void setNextAutoRetry(String nextAutoRetry) {
            this.nextAutoRetry = nextAutoRetry;
        }

        @Override
        public final Builder nextAutoRetry(String nextAutoRetry) {
            this.nextAutoRetry = nextAutoRetry;
            return this;
        }

        public final String getPreviousAutoRetry() {
            return previousAutoRetry;
        }

        public final void setPreviousAutoRetry(String previousAutoRetry) {
            this.previousAutoRetry = previousAutoRetry;
        }

        @Override
        public final Builder previousAutoRetry(String previousAutoRetry) {
            this.previousAutoRetry = previousAutoRetry;
            return this;
        }

        @Override
        public AutoRetryConfig build() {
            return new AutoRetryConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
