/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetReportGroupsResponse extends CodeBuildResponse implements
        ToCopyableBuilder<BatchGetReportGroupsResponse.Builder, BatchGetReportGroupsResponse> {
    private static final SdkField<List<ReportGroup>> REPORT_GROUPS_FIELD = SdkField
            .<List<ReportGroup>> builder(MarshallingType.LIST)
            .memberName("reportGroups")
            .getter(getter(BatchGetReportGroupsResponse::reportGroups))
            .setter(setter(Builder::reportGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReportGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReportGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REPORT_GROUPS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("reportGroupsNotFound")
            .getter(getter(BatchGetReportGroupsResponse::reportGroupsNotFound))
            .setter(setter(Builder::reportGroupsNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroupsNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GROUPS_FIELD,
            REPORT_GROUPS_NOT_FOUND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ReportGroup> reportGroups;

    private final List<String> reportGroupsNotFound;

    private BatchGetReportGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.reportGroups = builder.reportGroups;
        this.reportGroupsNotFound = builder.reportGroupsNotFound;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReportGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReportGroups() {
        return reportGroups != null && !(reportGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of report groups returned by <code>BatchGetReportGroups</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReportGroups} method.
     * </p>
     * 
     * @return The array of report groups returned by <code>BatchGetReportGroups</code>.
     */
    public final List<ReportGroup> reportGroups() {
        return reportGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReportGroupsNotFound property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReportGroupsNotFound() {
        return reportGroupsNotFound != null && !(reportGroupsNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a
     * <code>ReportGroup</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReportGroupsNotFound} method.
     * </p>
     * 
     * @return An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a
     *         <code>ReportGroup</code>.
     */
    public final List<String> reportGroupsNotFound() {
        return reportGroupsNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReportGroups() ? reportGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReportGroupsNotFound() ? reportGroupsNotFound() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetReportGroupsResponse)) {
            return false;
        }
        BatchGetReportGroupsResponse other = (BatchGetReportGroupsResponse) obj;
        return hasReportGroups() == other.hasReportGroups() && Objects.equals(reportGroups(), other.reportGroups())
                && hasReportGroupsNotFound() == other.hasReportGroupsNotFound()
                && Objects.equals(reportGroupsNotFound(), other.reportGroupsNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetReportGroupsResponse").add("ReportGroups", hasReportGroups() ? reportGroups() : null)
                .add("ReportGroupsNotFound", hasReportGroupsNotFound() ? reportGroupsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportGroups":
            return Optional.ofNullable(clazz.cast(reportGroups()));
        case "reportGroupsNotFound":
            return Optional.ofNullable(clazz.cast(reportGroupsNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reportGroups", REPORT_GROUPS_FIELD);
        map.put("reportGroupsNotFound", REPORT_GROUPS_NOT_FOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetReportGroupsResponse, T> g) {
        return obj -> g.apply((BatchGetReportGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetReportGroupsResponse> {
        /**
         * <p>
         * The array of report groups returned by <code>BatchGetReportGroups</code>.
         * </p>
         * 
         * @param reportGroups
         *        The array of report groups returned by <code>BatchGetReportGroups</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGroups(Collection<ReportGroup> reportGroups);

        /**
         * <p>
         * The array of report groups returned by <code>BatchGetReportGroups</code>.
         * </p>
         * 
         * @param reportGroups
         *        The array of report groups returned by <code>BatchGetReportGroups</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGroups(ReportGroup... reportGroups);

        /**
         * <p>
         * The array of report groups returned by <code>BatchGetReportGroups</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.ReportGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codebuild.model.ReportGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.ReportGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #reportGroups(List<ReportGroup>)}.
         * 
         * @param reportGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.ReportGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportGroups(java.util.Collection<ReportGroup>)
         */
        Builder reportGroups(Consumer<ReportGroup.Builder>... reportGroups);

        /**
         * <p>
         * An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a
         * <code>ReportGroup</code>.
         * </p>
         * 
         * @param reportGroupsNotFound
         *        An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a
         *        <code>ReportGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGroupsNotFound(Collection<String> reportGroupsNotFound);

        /**
         * <p>
         * An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a
         * <code>ReportGroup</code>.
         * </p>
         * 
         * @param reportGroupsNotFound
         *        An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a
         *        <code>ReportGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGroupsNotFound(String... reportGroupsNotFound);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private List<ReportGroup> reportGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> reportGroupsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetReportGroupsResponse model) {
            super(model);
            reportGroups(model.reportGroups);
            reportGroupsNotFound(model.reportGroupsNotFound);
        }

        public final List<ReportGroup.Builder> getReportGroups() {
            List<ReportGroup.Builder> result = ReportGroupsCopier.copyToBuilder(this.reportGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReportGroups(Collection<ReportGroup.BuilderImpl> reportGroups) {
            this.reportGroups = ReportGroupsCopier.copyFromBuilder(reportGroups);
        }

        @Override
        public final Builder reportGroups(Collection<ReportGroup> reportGroups) {
            this.reportGroups = ReportGroupsCopier.copy(reportGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportGroups(ReportGroup... reportGroups) {
            reportGroups(Arrays.asList(reportGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportGroups(Consumer<ReportGroup.Builder>... reportGroups) {
            reportGroups(Stream.of(reportGroups).map(c -> ReportGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getReportGroupsNotFound() {
            if (reportGroupsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return reportGroupsNotFound;
        }

        public final void setReportGroupsNotFound(Collection<String> reportGroupsNotFound) {
            this.reportGroupsNotFound = ReportGroupArnsCopier.copy(reportGroupsNotFound);
        }

        @Override
        public final Builder reportGroupsNotFound(Collection<String> reportGroupsNotFound) {
            this.reportGroupsNotFound = ReportGroupArnsCopier.copy(reportGroupsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportGroupsNotFound(String... reportGroupsNotFound) {
            reportGroupsNotFound(Arrays.asList(reportGroupsNotFound));
            return this;
        }

        @Override
        public BatchGetReportGroupsResponse build() {
            return new BatchGetReportGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
