/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains compute attributes. These attributes only need be specified when your project's or fleet's
 * <code>computeType</code> is set to <code>ATTRIBUTE_BASED_COMPUTE</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeConfiguration.Builder, ComputeConfiguration> {
    private static final SdkField<Long> V_CPU_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("vCpu")
            .getter(getter(ComputeConfiguration::vCpu)).setter(setter(Builder::vCpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vCpu").build()).build();

    private static final SdkField<Long> MEMORY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("memory")
            .getter(getter(ComputeConfiguration::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<Long> DISK_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("disk")
            .getter(getter(ComputeConfiguration::disk)).setter(setter(Builder::disk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disk").build()).build();

    private static final SdkField<String> MACHINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("machineType").getter(getter(ComputeConfiguration::machineTypeAsString))
            .setter(setter(Builder::machineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("machineType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V_CPU_FIELD, MEMORY_FIELD,
            DISK_FIELD, MACHINE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long vCpu;

    private final Long memory;

    private final Long disk;

    private final String machineType;

    private ComputeConfiguration(BuilderImpl builder) {
        this.vCpu = builder.vCpu;
        this.memory = builder.memory;
        this.disk = builder.disk;
        this.machineType = builder.machineType;
    }

    /**
     * <p>
     * The number of vCPUs of the instance type included in your fleet.
     * </p>
     * 
     * @return The number of vCPUs of the instance type included in your fleet.
     */
    public final Long vCpu() {
        return vCpu;
    }

    /**
     * <p>
     * The amount of memory of the instance type included in your fleet.
     * </p>
     * 
     * @return The amount of memory of the instance type included in your fleet.
     */
    public final Long memory() {
        return memory;
    }

    /**
     * <p>
     * The amount of disk space of the instance type included in your fleet.
     * </p>
     * 
     * @return The amount of disk space of the instance type included in your fleet.
     */
    public final Long disk() {
        return disk;
    }

    /**
     * <p>
     * The machine type of the instance type included in your fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #machineType} will
     * return {@link MachineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #machineTypeAsString}.
     * </p>
     * 
     * @return The machine type of the instance type included in your fleet.
     * @see MachineType
     */
    public final MachineType machineType() {
        return MachineType.fromValue(machineType);
    }

    /**
     * <p>
     * The machine type of the instance type included in your fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #machineType} will
     * return {@link MachineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #machineTypeAsString}.
     * </p>
     * 
     * @return The machine type of the instance type included in your fleet.
     * @see MachineType
     */
    public final String machineTypeAsString() {
        return machineType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vCpu());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(disk());
        hashCode = 31 * hashCode + Objects.hashCode(machineTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeConfiguration)) {
            return false;
        }
        ComputeConfiguration other = (ComputeConfiguration) obj;
        return Objects.equals(vCpu(), other.vCpu()) && Objects.equals(memory(), other.memory())
                && Objects.equals(disk(), other.disk()) && Objects.equals(machineTypeAsString(), other.machineTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeConfiguration").add("VCpu", vCpu()).add("Memory", memory()).add("Disk", disk())
                .add("MachineType", machineTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vCpu":
            return Optional.ofNullable(clazz.cast(vCpu()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "disk":
            return Optional.ofNullable(clazz.cast(disk()));
        case "machineType":
            return Optional.ofNullable(clazz.cast(machineTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vCpu", V_CPU_FIELD);
        map.put("memory", MEMORY_FIELD);
        map.put("disk", DISK_FIELD);
        map.put("machineType", MACHINE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeConfiguration, T> g) {
        return obj -> g.apply((ComputeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeConfiguration> {
        /**
         * <p>
         * The number of vCPUs of the instance type included in your fleet.
         * </p>
         * 
         * @param vCpu
         *        The number of vCPUs of the instance type included in your fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vCpu(Long vCpu);

        /**
         * <p>
         * The amount of memory of the instance type included in your fleet.
         * </p>
         * 
         * @param memory
         *        The amount of memory of the instance type included in your fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Long memory);

        /**
         * <p>
         * The amount of disk space of the instance type included in your fleet.
         * </p>
         * 
         * @param disk
         *        The amount of disk space of the instance type included in your fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disk(Long disk);

        /**
         * <p>
         * The machine type of the instance type included in your fleet.
         * </p>
         * 
         * @param machineType
         *        The machine type of the instance type included in your fleet.
         * @see MachineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MachineType
         */
        Builder machineType(String machineType);

        /**
         * <p>
         * The machine type of the instance type included in your fleet.
         * </p>
         * 
         * @param machineType
         *        The machine type of the instance type included in your fleet.
         * @see MachineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MachineType
         */
        Builder machineType(MachineType machineType);
    }

    static final class BuilderImpl implements Builder {
        private Long vCpu;

        private Long memory;

        private Long disk;

        private String machineType;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeConfiguration model) {
            vCpu(model.vCpu);
            memory(model.memory);
            disk(model.disk);
            machineType(model.machineType);
        }

        public final Long getVCpu() {
            return vCpu;
        }

        public final void setVCpu(Long vCpu) {
            this.vCpu = vCpu;
        }

        @Override
        public final Builder vCpu(Long vCpu) {
            this.vCpu = vCpu;
            return this;
        }

        public final Long getMemory() {
            return memory;
        }

        public final void setMemory(Long memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public final Long getDisk() {
            return disk;
        }

        public final void setDisk(Long disk) {
            this.disk = disk;
        }

        @Override
        public final Builder disk(Long disk) {
            this.disk = disk;
            return this;
        }

        public final String getMachineType() {
            return machineType;
        }

        public final void setMachineType(String machineType) {
            this.machineType = machineType;
        }

        @Override
        public final Builder machineType(String machineType) {
            this.machineType = machineType;
            return this;
        }

        @Override
        public final Builder machineType(MachineType machineType) {
            this.machineType(machineType == null ? null : machineType.toString());
            return this;
        }

        @Override
        public ComputeConfiguration build() {
            return new ComputeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
