/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReportGroupRequest extends CodeBuildRequest implements
        ToCopyableBuilder<CreateReportGroupRequest.Builder, CreateReportGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateReportGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateReportGroupRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<ReportExportConfig> EXPORT_CONFIG_FIELD = SdkField
            .<ReportExportConfig> builder(MarshallingType.SDK_POJO).memberName("exportConfig")
            .getter(getter(CreateReportGroupRequest::exportConfig)).setter(setter(Builder::exportConfig))
            .constructor(ReportExportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateReportGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            EXPORT_CONFIG_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String type;

    private final ReportExportConfig exportConfig;

    private final List<Tag> tags;

    private CreateReportGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.exportConfig = builder.exportConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the report group.
     * </p>
     * 
     * @return The name of the report group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of report group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of report group.
     * @see ReportType
     */
    public final ReportType type() {
        return ReportType.fromValue(type);
    }

    /**
     * <p>
     * The type of report group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of report group.
     * @see ReportType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A <code>ReportExportConfig</code> object that contains information about where the report group test results are
     * exported.
     * </p>
     * 
     * @return A <code>ReportExportConfig</code> object that contains information about where the report group test
     *         results are exported.
     */
    public final ReportExportConfig exportConfig() {
        return exportConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag key and value pairs associated with this report group.
     * </p>
     * <p>
     * These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tag key and value pairs associated with this report group. </p>
     *         <p>
     *         These tags are available for use by Amazon Web Services services that support CodeBuild report group
     *         tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReportGroupRequest)) {
            return false;
        }
        CreateReportGroupRequest other = (CreateReportGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(exportConfig(), other.exportConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReportGroupRequest").add("Name", name()).add("Type", typeAsString())
                .add("ExportConfig", exportConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "exportConfig":
            return Optional.ofNullable(clazz.cast(exportConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("exportConfig", EXPORT_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReportGroupRequest, T> g) {
        return obj -> g.apply((CreateReportGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateReportGroupRequest> {
        /**
         * <p>
         * The name of the report group.
         * </p>
         * 
         * @param name
         *        The name of the report group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of report group.
         * </p>
         * 
         * @param type
         *        The type of report group.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of report group.
         * </p>
         * 
         * @param type
         *        The type of report group.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder type(ReportType type);

        /**
         * <p>
         * A <code>ReportExportConfig</code> object that contains information about where the report group test results
         * are exported.
         * </p>
         * 
         * @param exportConfig
         *        A <code>ReportExportConfig</code> object that contains information about where the report group test
         *        results are exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportConfig(ReportExportConfig exportConfig);

        /**
         * <p>
         * A <code>ReportExportConfig</code> object that contains information about where the report group test results
         * are exported.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportExportConfig.Builder} avoiding the
         * need to create one manually via {@link ReportExportConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportExportConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #exportConfig(ReportExportConfig)}.
         * 
         * @param exportConfig
         *        a consumer that will call methods on {@link ReportExportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportConfig(ReportExportConfig)
         */
        default Builder exportConfig(Consumer<ReportExportConfig.Builder> exportConfig) {
            return exportConfig(ReportExportConfig.builder().applyMutation(exportConfig).build());
        }

        /**
         * <p>
         * A list of tag key and value pairs associated with this report group.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.
         * </p>
         * 
         * @param tags
         *        A list of tag key and value pairs associated with this report group. </p>
         *        <p>
         *        These tags are available for use by Amazon Web Services services that support CodeBuild report group
         *        tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tag key and value pairs associated with this report group.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.
         * </p>
         * 
         * @param tags
         *        A list of tag key and value pairs associated with this report group. </p>
         *        <p>
         *        These tags are available for use by Amazon Web Services services that support CodeBuild report group
         *        tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tag key and value pairs associated with this report group.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.codebuild.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String name;

        private String type;

        private ReportExportConfig exportConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReportGroupRequest model) {
            super(model);
            name(model.name);
            type(model.type);
            exportConfig(model.exportConfig);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReportType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ReportExportConfig.Builder getExportConfig() {
            return exportConfig != null ? exportConfig.toBuilder() : null;
        }

        public final void setExportConfig(ReportExportConfig.BuilderImpl exportConfig) {
            this.exportConfig = exportConfig != null ? exportConfig.build() : null;
        }

        @Override
        public final Builder exportConfig(ReportExportConfig exportConfig) {
            this.exportConfig = exportConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReportGroupRequest build() {
            return new CreateReportGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
