/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTestCasesRequest extends CodeBuildRequest implements
        ToCopyableBuilder<DescribeTestCasesRequest.Builder, DescribeTestCasesRequest> {
    private static final SdkField<String> REPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportArn").getter(getter(DescribeTestCasesRequest::reportArn)).setter(setter(Builder::reportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeTestCasesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeTestCasesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<TestCaseFilter> FILTER_FIELD = SdkField.<TestCaseFilter> builder(MarshallingType.SDK_POJO)
            .memberName("filter").getter(getter(DescribeTestCasesRequest::filter)).setter(setter(Builder::filter))
            .constructor(TestCaseFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ARN_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reportArn;

    private final String nextToken;

    private final Integer maxResults;

    private final TestCaseFilter filter;

    private DescribeTestCasesRequest(BuilderImpl builder) {
        super(builder);
        this.reportArn = builder.reportArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * The ARN of the report for which test cases are returned.
     * </p>
     * 
     * @return The ARN of the report for which test cases are returned.
     */
    public final String reportArn() {
        return reportArn;
    }

    /**
     * <p>
     * During a previous call, the maximum number of items that can be returned is the value specified in
     * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
     * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
     * call. To get all of the items in the list, keep calling this operation with each subsequent next token that is
     * returned, until no more next tokens are returned.
     * </p>
     * 
     * @return During a previous call, the maximum number of items that can be returned is the value specified in
     *         <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
     *         is returned. To get the next batch of items in the list, call this operation again, adding the next token
     *         to the call. To get all of the items in the list, keep calling this operation with each subsequent next
     *         token that is returned, until no more next tokens are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of paginated test cases returned per response. Use <code>nextToken</code> to iterate pages in
     * the list of returned <code>TestCase</code> objects. The default value is 100.
     * </p>
     * 
     * @return The maximum number of paginated test cases returned per response. Use <code>nextToken</code> to iterate
     *         pages in the list of returned <code>TestCase</code> objects. The default value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A <code>TestCaseFilter</code> object used to filter the returned reports.
     * </p>
     * 
     * @return A <code>TestCaseFilter</code> object used to filter the returned reports.
     */
    public final TestCaseFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTestCasesRequest)) {
            return false;
        }
        DescribeTestCasesRequest other = (DescribeTestCasesRequest) obj;
        return Objects.equals(reportArn(), other.reportArn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTestCasesRequest").add("ReportArn", reportArn()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Filter", filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportArn":
            return Optional.ofNullable(clazz.cast(reportArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reportArn", REPORT_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTestCasesRequest, T> g) {
        return obj -> g.apply((DescribeTestCasesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTestCasesRequest> {
        /**
         * <p>
         * The ARN of the report for which test cases are returned.
         * </p>
         * 
         * @param reportArn
         *        The ARN of the report for which test cases are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportArn(String reportArn);

        /**
         * <p>
         * During a previous call, the maximum number of items that can be returned is the value specified in
         * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
         * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
         * call. To get all of the items in the list, keep calling this operation with each subsequent next token that
         * is returned, until no more next tokens are returned.
         * </p>
         * 
         * @param nextToken
         *        During a previous call, the maximum number of items that can be returned is the value specified in
         *        <code>maxResults</code>. If there more items in the list, then a unique string called a
         *        <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again,
         *        adding the next token to the call. To get all of the items in the list, keep calling this operation
         *        with each subsequent next token that is returned, until no more next tokens are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of paginated test cases returned per response. Use <code>nextToken</code> to iterate pages
         * in the list of returned <code>TestCase</code> objects. The default value is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of paginated test cases returned per response. Use <code>nextToken</code> to
         *        iterate pages in the list of returned <code>TestCase</code> objects. The default value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A <code>TestCaseFilter</code> object used to filter the returned reports.
         * </p>
         * 
         * @param filter
         *        A <code>TestCaseFilter</code> object used to filter the returned reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(TestCaseFilter filter);

        /**
         * <p>
         * A <code>TestCaseFilter</code> object used to filter the returned reports.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestCaseFilter.Builder} avoiding the need
         * to create one manually via {@link TestCaseFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestCaseFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(TestCaseFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link TestCaseFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(TestCaseFilter)
         */
        default Builder filter(Consumer<TestCaseFilter.Builder> filter) {
            return filter(TestCaseFilter.builder().applyMutation(filter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String reportArn;

        private String nextToken;

        private Integer maxResults;

        private TestCaseFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTestCasesRequest model) {
            super(model);
            reportArn(model.reportArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filter(model.filter);
        }

        public final String getReportArn() {
            return reportArn;
        }

        public final void setReportArn(String reportArn) {
            this.reportArn = reportArn;
        }

        @Override
        public final Builder reportArn(String reportArn) {
            this.reportArn = reportArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final TestCaseFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(TestCaseFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(TestCaseFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTestCasesRequest build() {
            return new DescribeTestCasesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
