/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a resolved build artifact. A resolved artifact is an artifact that is built and deployed to the
 * destination, such as Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolvedArtifact implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolvedArtifact.Builder, ResolvedArtifact> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ResolvedArtifact::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(ResolvedArtifact::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(ResolvedArtifact::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LOCATION_FIELD,
            IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String location;

    private final String identifier;

    private ResolvedArtifact(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.identifier = builder.identifier;
    }

    /**
     * <p>
     * Specifies the type of artifact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ArtifactsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of artifact.
     * @see ArtifactsType
     */
    public final ArtifactsType type() {
        return ArtifactsType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the type of artifact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ArtifactsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of artifact.
     * @see ArtifactsType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The location of the artifact.
     * </p>
     * 
     * @return The location of the artifact.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The identifier of the artifact.
     * </p>
     * 
     * @return The identifier of the artifact.
     */
    public final String identifier() {
        return identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedArtifact)) {
            return false;
        }
        ResolvedArtifact other = (ResolvedArtifact) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(location(), other.location())
                && Objects.equals(identifier(), other.identifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolvedArtifact").add("Type", typeAsString()).add("Location", location())
                .add("Identifier", identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolvedArtifact, T> g) {
        return obj -> g.apply((ResolvedArtifact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolvedArtifact> {
        /**
         * <p>
         * Specifies the type of artifact.
         * </p>
         * 
         * @param type
         *        Specifies the type of artifact.
         * @see ArtifactsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactsType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the type of artifact.
         * </p>
         * 
         * @param type
         *        Specifies the type of artifact.
         * @see ArtifactsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactsType
         */
        Builder type(ArtifactsType type);

        /**
         * <p>
         * The location of the artifact.
         * </p>
         * 
         * @param location
         *        The location of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The identifier of the artifact.
         * </p>
         * 
         * @param identifier
         *        The identifier of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String location;

        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolvedArtifact model) {
            type(model.type);
            location(model.location);
            identifier(model.identifier);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactsType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public ResolvedArtifact build() {
            return new ResolvedArtifact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
