/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scaling configuration input of a compute fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ScalingConfigurationInput.Builder, ScalingConfigurationInput> {
    private static final SdkField<String> SCALING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scalingType").getter(getter(ScalingConfigurationInput::scalingTypeAsString))
            .setter(setter(Builder::scalingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingType").build()).build();

    private static final SdkField<List<TargetTrackingScalingConfiguration>> TARGET_TRACKING_SCALING_CONFIGS_FIELD = SdkField
            .<List<TargetTrackingScalingConfiguration>> builder(MarshallingType.LIST)
            .memberName("targetTrackingScalingConfigs")
            .getter(getter(ScalingConfigurationInput::targetTrackingScalingConfigs))
            .setter(setter(Builder::targetTrackingScalingConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTrackingScalingConfigs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetTrackingScalingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetTrackingScalingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCapacity").getter(getter(ScalingConfigurationInput::maxCapacity))
            .setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_TYPE_FIELD,
            TARGET_TRACKING_SCALING_CONFIGS_FIELD, MAX_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scalingType;

    private final List<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs;

    private final Integer maxCapacity;

    private ScalingConfigurationInput(BuilderImpl builder) {
        this.scalingType = builder.scalingType;
        this.targetTrackingScalingConfigs = builder.targetTrackingScalingConfigs;
        this.maxCapacity = builder.maxCapacity;
    }

    /**
     * <p>
     * The scaling type for a compute fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingType} will
     * return {@link FleetScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalingTypeAsString}.
     * </p>
     * 
     * @return The scaling type for a compute fleet.
     * @see FleetScalingType
     */
    public final FleetScalingType scalingType() {
        return FleetScalingType.fromValue(scalingType);
    }

    /**
     * <p>
     * The scaling type for a compute fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingType} will
     * return {@link FleetScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalingTypeAsString}.
     * </p>
     * 
     * @return The scaling type for a compute fleet.
     * @see FleetScalingType
     */
    public final String scalingTypeAsString() {
        return scalingType;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetTrackingScalingConfigs property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetTrackingScalingConfigs() {
        return targetTrackingScalingConfigs != null && !(targetTrackingScalingConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>TargetTrackingScalingConfiguration</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetTrackingScalingConfigs} method.
     * </p>
     * 
     * @return A list of <code>TargetTrackingScalingConfiguration</code> objects.
     */
    public final List<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs() {
        return targetTrackingScalingConfigs;
    }

    /**
     * <p>
     * The maximum number of instances in the ﬂeet when auto-scaling.
     * </p>
     * 
     * @return The maximum number of instances in the ﬂeet when auto-scaling.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetTrackingScalingConfigs() ? targetTrackingScalingConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfigurationInput)) {
            return false;
        }
        ScalingConfigurationInput other = (ScalingConfigurationInput) obj;
        return Objects.equals(scalingTypeAsString(), other.scalingTypeAsString())
                && hasTargetTrackingScalingConfigs() == other.hasTargetTrackingScalingConfigs()
                && Objects.equals(targetTrackingScalingConfigs(), other.targetTrackingScalingConfigs())
                && Objects.equals(maxCapacity(), other.maxCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingConfigurationInput").add("ScalingType", scalingTypeAsString())
                .add("TargetTrackingScalingConfigs", hasTargetTrackingScalingConfigs() ? targetTrackingScalingConfigs() : null)
                .add("MaxCapacity", maxCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scalingType":
            return Optional.ofNullable(clazz.cast(scalingTypeAsString()));
        case "targetTrackingScalingConfigs":
            return Optional.ofNullable(clazz.cast(targetTrackingScalingConfigs()));
        case "maxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scalingType", SCALING_TYPE_FIELD);
        map.put("targetTrackingScalingConfigs", TARGET_TRACKING_SCALING_CONFIGS_FIELD);
        map.put("maxCapacity", MAX_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScalingConfigurationInput, T> g) {
        return obj -> g.apply((ScalingConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingConfigurationInput> {
        /**
         * <p>
         * The scaling type for a compute fleet.
         * </p>
         * 
         * @param scalingType
         *        The scaling type for a compute fleet.
         * @see FleetScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetScalingType
         */
        Builder scalingType(String scalingType);

        /**
         * <p>
         * The scaling type for a compute fleet.
         * </p>
         * 
         * @param scalingType
         *        The scaling type for a compute fleet.
         * @see FleetScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetScalingType
         */
        Builder scalingType(FleetScalingType scalingType);

        /**
         * <p>
         * A list of <code>TargetTrackingScalingConfiguration</code> objects.
         * </p>
         * 
         * @param targetTrackingScalingConfigs
         *        A list of <code>TargetTrackingScalingConfiguration</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTrackingScalingConfigs(Collection<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs);

        /**
         * <p>
         * A list of <code>TargetTrackingScalingConfiguration</code> objects.
         * </p>
         * 
         * @param targetTrackingScalingConfigs
         *        A list of <code>TargetTrackingScalingConfiguration</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTrackingScalingConfigs(TargetTrackingScalingConfiguration... targetTrackingScalingConfigs);

        /**
         * <p>
         * A list of <code>TargetTrackingScalingConfiguration</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.TargetTrackingScalingConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.codebuild.model.TargetTrackingScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.TargetTrackingScalingConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #targetTrackingScalingConfigs(List<TargetTrackingScalingConfiguration>)}.
         * 
         * @param targetTrackingScalingConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.TargetTrackingScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTrackingScalingConfigs(java.util.Collection<TargetTrackingScalingConfiguration>)
         */
        Builder targetTrackingScalingConfigs(Consumer<TargetTrackingScalingConfiguration.Builder>... targetTrackingScalingConfigs);

        /**
         * <p>
         * The maximum number of instances in the ﬂeet when auto-scaling.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum number of instances in the ﬂeet when auto-scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);
    }

    static final class BuilderImpl implements Builder {
        private String scalingType;

        private List<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs = DefaultSdkAutoConstructList.getInstance();

        private Integer maxCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConfigurationInput model) {
            scalingType(model.scalingType);
            targetTrackingScalingConfigs(model.targetTrackingScalingConfigs);
            maxCapacity(model.maxCapacity);
        }

        public final String getScalingType() {
            return scalingType;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(FleetScalingType scalingType) {
            this.scalingType(scalingType == null ? null : scalingType.toString());
            return this;
        }

        public final List<TargetTrackingScalingConfiguration.Builder> getTargetTrackingScalingConfigs() {
            List<TargetTrackingScalingConfiguration.Builder> result = TargetTrackingScalingConfigurationsCopier
                    .copyToBuilder(this.targetTrackingScalingConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetTrackingScalingConfigs(
                Collection<TargetTrackingScalingConfiguration.BuilderImpl> targetTrackingScalingConfigs) {
            this.targetTrackingScalingConfigs = TargetTrackingScalingConfigurationsCopier
                    .copyFromBuilder(targetTrackingScalingConfigs);
        }

        @Override
        public final Builder targetTrackingScalingConfigs(
                Collection<TargetTrackingScalingConfiguration> targetTrackingScalingConfigs) {
            this.targetTrackingScalingConfigs = TargetTrackingScalingConfigurationsCopier.copy(targetTrackingScalingConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTrackingScalingConfigs(TargetTrackingScalingConfiguration... targetTrackingScalingConfigs) {
            targetTrackingScalingConfigs(Arrays.asList(targetTrackingScalingConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTrackingScalingConfigs(
                Consumer<TargetTrackingScalingConfiguration.Builder>... targetTrackingScalingConfigs) {
            targetTrackingScalingConfigs(Stream.of(targetTrackingScalingConfigs)
                    .map(c -> TargetTrackingScalingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        @Override
        public ScalingConfigurationInput build() {
            return new ScalingConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
