/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter used to return specific types of test cases. In order to pass the filter, the report must meet all of the
 * filter properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestCaseFilter implements SdkPojo, Serializable, ToCopyableBuilder<TestCaseFilter.Builder, TestCaseFilter> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestCaseFilter::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> KEYWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("keyword")
            .getter(getter(TestCaseFilter::keyword)).setter(setter(Builder::keyword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, KEYWORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String keyword;

    private TestCaseFilter(BuilderImpl builder) {
        this.status = builder.status;
        this.keyword = builder.keyword;
    }

    /**
     * <p>
     * The status used to filter test cases. A <code>TestCaseFilter</code> can have one status. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SKIPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status used to filter test cases. A <code>TestCaseFilter</code> can have one status. Valid values
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SKIPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A keyword that is used to filter on the <code>name</code> or the <code>prefix</code> of the test cases. Only test
     * cases where the keyword is a substring of the <code>name</code> or the <code>prefix</code> will be returned.
     * </p>
     * 
     * @return A keyword that is used to filter on the <code>name</code> or the <code>prefix</code> of the test cases.
     *         Only test cases where the keyword is a substring of the <code>name</code> or the <code>prefix</code> will
     *         be returned.
     */
    public final String keyword() {
        return keyword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(keyword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseFilter)) {
            return false;
        }
        TestCaseFilter other = (TestCaseFilter) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(keyword(), other.keyword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestCaseFilter").add("Status", status()).add("Keyword", keyword()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "keyword":
            return Optional.ofNullable(clazz.cast(keyword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("keyword", KEYWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestCaseFilter, T> g) {
        return obj -> g.apply((TestCaseFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestCaseFilter> {
        /**
         * <p>
         * The status used to filter test cases. A <code>TestCaseFilter</code> can have one status. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SKIPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status used to filter test cases. A <code>TestCaseFilter</code> can have one status. Valid values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SKIPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A keyword that is used to filter on the <code>name</code> or the <code>prefix</code> of the test cases. Only
         * test cases where the keyword is a substring of the <code>name</code> or the <code>prefix</code> will be
         * returned.
         * </p>
         * 
         * @param keyword
         *        A keyword that is used to filter on the <code>name</code> or the <code>prefix</code> of the test
         *        cases. Only test cases where the keyword is a substring of the <code>name</code> or the
         *        <code>prefix</code> will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyword(String keyword);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String keyword;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseFilter model) {
            status(model.status);
            keyword(model.keyword);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getKeyword() {
            return keyword;
        }

        public final void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        @Override
        public final Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        @Override
        public TestCaseFilter build() {
            return new TestCaseFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
