/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.ApprovalRule;
import software.amazon.awssdk.services.codecommit.model.ApprovalRulesListCopier;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum;
import software.amazon.awssdk.services.codecommit.model.PullRequestTarget;
import software.amazon.awssdk.services.codecommit.model.PullRequestTargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PullRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PullRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestId").getter(PullRequest.getter(PullRequest::pullRequestId)).setter(PullRequest.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(PullRequest.getter(PullRequest::title)).setter(PullRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(PullRequest.getter(PullRequest::description)).setter(PullRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_ACTIVITY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastActivityDate").getter(PullRequest.getter(PullRequest::lastActivityDate)).setter(PullRequest.setter(Builder::lastActivityDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastActivityDate").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(PullRequest.getter(PullRequest::creationDate)).setter(PullRequest.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<String> PULL_REQUEST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestStatus").getter(PullRequest.getter(PullRequest::pullRequestStatusAsString)).setter(PullRequest.setter(Builder::pullRequestStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestStatus").build()}).build();
    private static final SdkField<String> AUTHOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorArn").getter(PullRequest.getter(PullRequest::authorArn)).setter(PullRequest.setter(Builder::authorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorArn").build()}).build();
    private static final SdkField<List<PullRequestTarget>> PULL_REQUEST_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pullRequestTargets").getter(PullRequest.getter(PullRequest::pullRequestTargets)).setter(PullRequest.setter(Builder::pullRequestTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PullRequestTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(PullRequest.getter(PullRequest::clientRequestToken)).setter(PullRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(PullRequest.getter(PullRequest::revisionId)).setter(PullRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<List<ApprovalRule>> APPROVAL_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("approvalRules").getter(PullRequest.getter(PullRequest::approvalRules)).setter(PullRequest.setter(Builder::approvalRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApprovalRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, LAST_ACTIVITY_DATE_FIELD, CREATION_DATE_FIELD, PULL_REQUEST_STATUS_FIELD, AUTHOR_ARN_FIELD, PULL_REQUEST_TARGETS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, REVISION_ID_FIELD, APPROVAL_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("pullRequestId", PULL_REQUEST_ID_FIELD);
            this.put("title", TITLE_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("lastActivityDate", LAST_ACTIVITY_DATE_FIELD);
            this.put("creationDate", CREATION_DATE_FIELD);
            this.put("pullRequestStatus", PULL_REQUEST_STATUS_FIELD);
            this.put("authorArn", AUTHOR_ARN_FIELD);
            this.put("pullRequestTargets", PULL_REQUEST_TARGETS_FIELD);
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("revisionId", REVISION_ID_FIELD);
            this.put("approvalRules", APPROVAL_RULES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String pullRequestId;
    private final String title;
    private final String description;
    private final Instant lastActivityDate;
    private final Instant creationDate;
    private final String pullRequestStatus;
    private final String authorArn;
    private final List<PullRequestTarget> pullRequestTargets;
    private final String clientRequestToken;
    private final String revisionId;
    private final List<ApprovalRule> approvalRules;

    private PullRequest(BuilderImpl builder) {
        this.pullRequestId = builder.pullRequestId;
        this.title = builder.title;
        this.description = builder.description;
        this.lastActivityDate = builder.lastActivityDate;
        this.creationDate = builder.creationDate;
        this.pullRequestStatus = builder.pullRequestStatus;
        this.authorArn = builder.authorArn;
        this.pullRequestTargets = builder.pullRequestTargets;
        this.clientRequestToken = builder.clientRequestToken;
        this.revisionId = builder.revisionId;
        this.approvalRules = builder.approvalRules;
    }

    public final String pullRequestId() {
        return this.pullRequestId;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastActivityDate() {
        return this.lastActivityDate;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final PullRequestStatusEnum pullRequestStatus() {
        return PullRequestStatusEnum.fromValue(this.pullRequestStatus);
    }

    public final String pullRequestStatusAsString() {
        return this.pullRequestStatus;
    }

    public final String authorArn() {
        return this.authorArn;
    }

    public final boolean hasPullRequestTargets() {
        return this.pullRequestTargets != null && !(this.pullRequestTargets instanceof SdkAutoConstructList);
    }

    public final List<PullRequestTarget> pullRequestTargets() {
        return this.pullRequestTargets;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final boolean hasApprovalRules() {
        return this.approvalRules != null && !(this.approvalRules instanceof SdkAutoConstructList);
    }

    public final List<ApprovalRule> approvalRules() {
        return this.approvalRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastActivityDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPullRequestTargets() ? this.pullRequestTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovalRules() ? this.approvalRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequest)) {
            return false;
        }
        PullRequest other = (PullRequest)obj;
        return Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastActivityDate(), other.lastActivityDate()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.pullRequestStatusAsString(), other.pullRequestStatusAsString()) && Objects.equals(this.authorArn(), other.authorArn()) && this.hasPullRequestTargets() == other.hasPullRequestTargets() && Objects.equals(this.pullRequestTargets(), other.pullRequestTargets()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.revisionId(), other.revisionId()) && this.hasApprovalRules() == other.hasApprovalRules() && Objects.equals(this.approvalRules(), other.approvalRules());
    }

    public final String toString() {
        return ToString.builder((String)"PullRequest").add("PullRequestId", (Object)this.pullRequestId()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("LastActivityDate", (Object)this.lastActivityDate()).add("CreationDate", (Object)this.creationDate()).add("PullRequestStatus", (Object)this.pullRequestStatusAsString()).add("AuthorArn", (Object)this.authorArn()).add("PullRequestTargets", this.hasPullRequestTargets() ? this.pullRequestTargets() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).add("RevisionId", (Object)this.revisionId()).add("ApprovalRules", this.hasApprovalRules() ? this.approvalRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastActivityDate": {
                return Optional.ofNullable(clazz.cast(this.lastActivityDate()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "pullRequestStatus": {
                return Optional.ofNullable(clazz.cast(this.pullRequestStatusAsString()));
            }
            case "authorArn": {
                return Optional.ofNullable(clazz.cast(this.authorArn()));
            }
            case "pullRequestTargets": {
                return Optional.ofNullable(clazz.cast(this.pullRequestTargets()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "approvalRules": {
                return Optional.ofNullable(clazz.cast(this.approvalRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PullRequest, T> g) {
        return obj -> g.apply((PullRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pullRequestId;
        private String title;
        private String description;
        private Instant lastActivityDate;
        private Instant creationDate;
        private String pullRequestStatus;
        private String authorArn;
        private List<PullRequestTarget> pullRequestTargets = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private String revisionId;
        private List<ApprovalRule> approvalRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequest model) {
            this.pullRequestId(model.pullRequestId);
            this.title(model.title);
            this.description(model.description);
            this.lastActivityDate(model.lastActivityDate);
            this.creationDate(model.creationDate);
            this.pullRequestStatus(model.pullRequestStatus);
            this.authorArn(model.authorArn);
            this.pullRequestTargets(model.pullRequestTargets);
            this.clientRequestToken(model.clientRequestToken);
            this.revisionId(model.revisionId);
            this.approvalRules(model.approvalRules);
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastActivityDate() {
            return this.lastActivityDate;
        }

        public final void setLastActivityDate(Instant lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
        }

        @Override
        public final Builder lastActivityDate(Instant lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getPullRequestStatus() {
            return this.pullRequestStatus;
        }

        public final void setPullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
        }

        @Override
        public final Builder pullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
            return this;
        }

        @Override
        public final Builder pullRequestStatus(PullRequestStatusEnum pullRequestStatus) {
            this.pullRequestStatus(pullRequestStatus == null ? null : pullRequestStatus.toString());
            return this;
        }

        public final String getAuthorArn() {
            return this.authorArn;
        }

        public final void setAuthorArn(String authorArn) {
            this.authorArn = authorArn;
        }

        @Override
        public final Builder authorArn(String authorArn) {
            this.authorArn = authorArn;
            return this;
        }

        public final List<PullRequestTarget.Builder> getPullRequestTargets() {
            List<PullRequestTarget.Builder> result = PullRequestTargetListCopier.copyToBuilder(this.pullRequestTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPullRequestTargets(Collection<PullRequestTarget.BuilderImpl> pullRequestTargets) {
            this.pullRequestTargets = PullRequestTargetListCopier.copyFromBuilder(pullRequestTargets);
        }

        @Override
        public final Builder pullRequestTargets(Collection<PullRequestTarget> pullRequestTargets) {
            this.pullRequestTargets = PullRequestTargetListCopier.copy(pullRequestTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pullRequestTargets(PullRequestTarget ... pullRequestTargets) {
            this.pullRequestTargets(Arrays.asList(pullRequestTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pullRequestTargets(Consumer<PullRequestTarget.Builder> ... pullRequestTargets) {
            this.pullRequestTargets(Stream.of(pullRequestTargets).map(c -> (PullRequestTarget)((PullRequestTarget.Builder)PullRequestTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final List<ApprovalRule.Builder> getApprovalRules() {
            List<ApprovalRule.Builder> result = ApprovalRulesListCopier.copyToBuilder(this.approvalRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApprovalRules(Collection<ApprovalRule.BuilderImpl> approvalRules) {
            this.approvalRules = ApprovalRulesListCopier.copyFromBuilder(approvalRules);
        }

        @Override
        public final Builder approvalRules(Collection<ApprovalRule> approvalRules) {
            this.approvalRules = ApprovalRulesListCopier.copy(approvalRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalRules(ApprovalRule ... approvalRules) {
            this.approvalRules(Arrays.asList(approvalRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalRules(Consumer<ApprovalRule.Builder> ... approvalRules) {
            this.approvalRules(Stream.of(approvalRules).map(c -> (ApprovalRule)((ApprovalRule.Builder)ApprovalRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PullRequest build() {
            return new PullRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PullRequest> {
        public Builder pullRequestId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder lastActivityDate(Instant var1);

        public Builder creationDate(Instant var1);

        public Builder pullRequestStatus(String var1);

        public Builder pullRequestStatus(PullRequestStatusEnum var1);

        public Builder authorArn(String var1);

        public Builder pullRequestTargets(Collection<PullRequestTarget> var1);

        public Builder pullRequestTargets(PullRequestTarget ... var1);

        public Builder pullRequestTargets(Consumer<PullRequestTarget.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder revisionId(String var1);

        public Builder approvalRules(Collection<ApprovalRule> var1);

        public Builder approvalRules(ApprovalRule ... var1);

        public Builder approvalRules(Consumer<ApprovalRule.Builder> ... var1);
    }
}

