/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.codeconnections.model.AccessDeniedException;
import software.amazon.awssdk.services.codeconnections.model.CodeConnectionsException;
import software.amazon.awssdk.services.codeconnections.model.ConcurrentModificationException;
import software.amazon.awssdk.services.codeconnections.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.codeconnections.model.ConflictException;
import software.amazon.awssdk.services.codeconnections.model.CreateConnectionRequest;
import software.amazon.awssdk.services.codeconnections.model.CreateConnectionResponse;
import software.amazon.awssdk.services.codeconnections.model.CreateHostRequest;
import software.amazon.awssdk.services.codeconnections.model.CreateHostResponse;
import software.amazon.awssdk.services.codeconnections.model.CreateRepositoryLinkRequest;
import software.amazon.awssdk.services.codeconnections.model.CreateRepositoryLinkResponse;
import software.amazon.awssdk.services.codeconnections.model.CreateSyncConfigurationRequest;
import software.amazon.awssdk.services.codeconnections.model.CreateSyncConfigurationResponse;
import software.amazon.awssdk.services.codeconnections.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.codeconnections.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.codeconnections.model.DeleteHostRequest;
import software.amazon.awssdk.services.codeconnections.model.DeleteHostResponse;
import software.amazon.awssdk.services.codeconnections.model.DeleteRepositoryLinkRequest;
import software.amazon.awssdk.services.codeconnections.model.DeleteRepositoryLinkResponse;
import software.amazon.awssdk.services.codeconnections.model.DeleteSyncConfigurationRequest;
import software.amazon.awssdk.services.codeconnections.model.DeleteSyncConfigurationResponse;
import software.amazon.awssdk.services.codeconnections.model.GetConnectionRequest;
import software.amazon.awssdk.services.codeconnections.model.GetConnectionResponse;
import software.amazon.awssdk.services.codeconnections.model.GetHostRequest;
import software.amazon.awssdk.services.codeconnections.model.GetHostResponse;
import software.amazon.awssdk.services.codeconnections.model.GetRepositoryLinkRequest;
import software.amazon.awssdk.services.codeconnections.model.GetRepositoryLinkResponse;
import software.amazon.awssdk.services.codeconnections.model.GetRepositorySyncStatusRequest;
import software.amazon.awssdk.services.codeconnections.model.GetRepositorySyncStatusResponse;
import software.amazon.awssdk.services.codeconnections.model.GetResourceSyncStatusRequest;
import software.amazon.awssdk.services.codeconnections.model.GetResourceSyncStatusResponse;
import software.amazon.awssdk.services.codeconnections.model.GetSyncBlockerSummaryRequest;
import software.amazon.awssdk.services.codeconnections.model.GetSyncBlockerSummaryResponse;
import software.amazon.awssdk.services.codeconnections.model.GetSyncConfigurationRequest;
import software.amazon.awssdk.services.codeconnections.model.GetSyncConfigurationResponse;
import software.amazon.awssdk.services.codeconnections.model.InternalServerException;
import software.amazon.awssdk.services.codeconnections.model.InvalidInputException;
import software.amazon.awssdk.services.codeconnections.model.LimitExceededException;
import software.amazon.awssdk.services.codeconnections.model.ListConnectionsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListConnectionsResponse;
import software.amazon.awssdk.services.codeconnections.model.ListHostsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListHostsResponse;
import software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksRequest;
import software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksResponse;
import software.amazon.awssdk.services.codeconnections.model.ListRepositorySyncDefinitionsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListRepositorySyncDefinitionsResponse;
import software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsRequest;
import software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsResponse;
import software.amazon.awssdk.services.codeconnections.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codeconnections.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codeconnections.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.codeconnections.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codeconnections.model.ResourceUnavailableException;
import software.amazon.awssdk.services.codeconnections.model.RetryLatestCommitFailedException;
import software.amazon.awssdk.services.codeconnections.model.SyncBlockerDoesNotExistException;
import software.amazon.awssdk.services.codeconnections.model.SyncConfigurationStillExistsException;
import software.amazon.awssdk.services.codeconnections.model.TagResourceRequest;
import software.amazon.awssdk.services.codeconnections.model.TagResourceResponse;
import software.amazon.awssdk.services.codeconnections.model.ThrottlingException;
import software.amazon.awssdk.services.codeconnections.model.UnsupportedProviderTypeException;
import software.amazon.awssdk.services.codeconnections.model.UntagResourceRequest;
import software.amazon.awssdk.services.codeconnections.model.UntagResourceResponse;
import software.amazon.awssdk.services.codeconnections.model.UpdateHostRequest;
import software.amazon.awssdk.services.codeconnections.model.UpdateHostResponse;
import software.amazon.awssdk.services.codeconnections.model.UpdateOutOfSyncException;
import software.amazon.awssdk.services.codeconnections.model.UpdateRepositoryLinkRequest;
import software.amazon.awssdk.services.codeconnections.model.UpdateRepositoryLinkResponse;
import software.amazon.awssdk.services.codeconnections.model.UpdateSyncBlockerRequest;
import software.amazon.awssdk.services.codeconnections.model.UpdateSyncBlockerResponse;
import software.amazon.awssdk.services.codeconnections.model.UpdateSyncConfigurationRequest;
import software.amazon.awssdk.services.codeconnections.model.UpdateSyncConfigurationResponse;
import software.amazon.awssdk.services.codeconnections.paginators.ListConnectionsIterable;
import software.amazon.awssdk.services.codeconnections.paginators.ListHostsIterable;
import software.amazon.awssdk.services.codeconnections.paginators.ListRepositoryLinksIterable;
import software.amazon.awssdk.services.codeconnections.paginators.ListSyncConfigurationsIterable;

/**
 * Service client for accessing AWS CodeConnections. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS CodeConnections</fullname>
 * <p>
 * This Amazon Web Services CodeConnections API Reference provides descriptions and usage examples of the operations and
 * data types for the Amazon Web Services CodeConnections API. You can use the connections API to work with connections
 * and installations.
 * </p>
 * <p>
 * <i>Connections</i> are configurations that you use to connect Amazon Web Services resources to external code
 * repositories. Each connection is a resource that can be given to services such as CodePipeline to connect to a
 * third-party repository such as Bitbucket. For example, you can add the connection in CodePipeline so that it triggers
 * your pipeline when a code change is made to your third-party code repository. Each connection is named and associated
 * with a unique ARN that is used to reference the connection.
 * </p>
 * <p>
 * When you create a connection, the console initiates a third-party connection handshake. <i>Installations</i> are the
 * apps that are used to conduct this handshake. For example, the installation for the Bitbucket provider type is the
 * Bitbucket app. When you create a connection, you can choose an existing installation or create one.
 * </p>
 * <p>
 * When you want to create a connection to an installed provider type such as GitHub Enterprise Server, you create a
 * <i>host</i> for your connections.
 * </p>
 * <p>
 * You can work with connections by calling:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateConnection</a>, which creates a uniquely named connection that can be referenced by services such as
 * CodePipeline.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteConnection</a>, which deletes the specified connection.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetConnection</a>, which returns information about the connection, including the connection status.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListConnections</a>, which lists the connections associated with your account.
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can work with hosts by calling:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateHost</a>, which creates a host that represents the infrastructure where your provider is installed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteHost</a>, which deletes the specified host.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetHost</a>, which returns information about the host, including the setup status.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListHosts</a>, which lists the hosts associated with your account.
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can work with tags in Amazon Web Services CodeConnections by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>ListTagsForResource</a>, which gets information about Amazon Web Services tags for a specified Amazon Resource
 * Name (ARN) in Amazon Web Services CodeConnections.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>TagResource</a>, which adds or updates tags for a resource in Amazon Web Services CodeConnections.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UntagResource</a>, which removes tags for a resource in Amazon Web Services CodeConnections.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For information about how to use Amazon Web Services CodeConnections, see the <a
 * href="https://docs.aws.amazon.com/dtconsole/latest/userguide/welcome-connections.html">Developer Tools User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CodeConnectionsClient extends AwsClient {
    String SERVICE_NAME = "codeconnections";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "codeconnections";

    /**
     * <p>
     * Creates a connection that can then be given to other Amazon Web Services services like CodePipeline so that it
     * can access third-party code repositories. The connection is in pending status until the third-party connection
     * handshake is completed from the console.
     * </p>
     *
     * @param createConnectionRequest
     * @return Result of the CreateConnection operation returned by the service.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ResourceUnavailableException
     *         Resource not found. Verify the ARN for the host resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectionResponse createConnection(CreateConnectionRequest createConnectionRequest)
            throws LimitExceededException, ResourceNotFoundException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connection that can then be given to other Amazon Web Services services like CodePipeline so that it
     * can access third-party code repositories. The connection is in pending status until the third-party connection
     * handshake is completed from the console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectionRequest#builder()}
     * </p>
     *
     * @param createConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.CreateConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateConnection operation returned by the service.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ResourceUnavailableException
     *         Resource not found. Verify the ARN for the host resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectionResponse createConnection(Consumer<CreateConnectionRequest.Builder> createConnectionRequest)
            throws LimitExceededException, ResourceNotFoundException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return createConnection(CreateConnectionRequest.builder().applyMutation(createConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used
     * when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You
     * create one host for all connections to that provider.
     * </p>
     * <note>
     * <p>
     * A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE`
     * by setting up the host in the console.
     * </p>
     * </note>
     *
     * @param createHostRequest
     * @return Result of the CreateHost operation returned by the service.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.CreateHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/CreateHost" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateHostResponse createHost(CreateHostRequest createHostRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used
     * when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You
     * create one host for all connections to that provider.
     * </p>
     * <note>
     * <p>
     * A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE`
     * by setting up the host in the console.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHostRequest.Builder} avoiding the need to
     * create one manually via {@link CreateHostRequest#builder()}
     * </p>
     *
     * @param createHostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.CreateHostRequest.Builder} to create a
     *        request.
     * @return Result of the CreateHost operation returned by the service.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.CreateHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/CreateHost" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateHostResponse createHost(Consumer<CreateHostRequest.Builder> createHostRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, CodeConnectionsException {
        return createHost(CreateHostRequest.builder().applyMutation(createHostRequest).build());
    }

    /**
     * <p>
     * Creates a link to a specified external Git repository. A repository link allows Git sync to monitor and sync
     * changes to files in a specified Git repository.
     * </p>
     *
     * @param createRepositoryLinkRequest
     * @return Result of the CreateRepositoryLink operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws ResourceAlreadyExistsException
     *         Unable to create resource. Resource already exists.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.CreateRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/CreateRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRepositoryLinkResponse createRepositoryLink(CreateRepositoryLinkRequest createRepositoryLinkRequest)
            throws AccessDeniedException, ConcurrentModificationException, InternalServerException, InvalidInputException,
            LimitExceededException, ResourceAlreadyExistsException, ThrottlingException, AwsServiceException, SdkClientException,
            CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a link to a specified external Git repository. A repository link allows Git sync to monitor and sync
     * changes to files in a specified Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRepositoryLinkRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRepositoryLinkRequest#builder()}
     * </p>
     *
     * @param createRepositoryLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.CreateRepositoryLinkRequest.Builder} to
     *        create a request.
     * @return Result of the CreateRepositoryLink operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws ResourceAlreadyExistsException
     *         Unable to create resource. Resource already exists.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.CreateRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/CreateRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRepositoryLinkResponse createRepositoryLink(
            Consumer<CreateRepositoryLinkRequest.Builder> createRepositoryLinkRequest) throws AccessDeniedException,
            ConcurrentModificationException, InternalServerException, InvalidInputException, LimitExceededException,
            ResourceAlreadyExistsException, ThrottlingException, AwsServiceException, SdkClientException,
            CodeConnectionsException {
        return createRepositoryLink(CreateRepositoryLinkRequest.builder().applyMutation(createRepositoryLinkRequest).build());
    }

    /**
     * <p>
     * Creates a sync configuration which allows Amazon Web Services to sync content from a Git repository to update a
     * specified Amazon Web Services resource. Parameters for the sync configuration are determined by the sync type.
     * </p>
     *
     * @param createSyncConfigurationRequest
     * @return Result of the CreateSyncConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws ResourceAlreadyExistsException
     *         Unable to create resource. Resource already exists.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.CreateSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/CreateSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSyncConfigurationResponse createSyncConfiguration(CreateSyncConfigurationRequest createSyncConfigurationRequest)
            throws AccessDeniedException, ConcurrentModificationException, InternalServerException, InvalidInputException,
            LimitExceededException, ResourceAlreadyExistsException, ThrottlingException, AwsServiceException, SdkClientException,
            CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a sync configuration which allows Amazon Web Services to sync content from a Git repository to update a
     * specified Amazon Web Services resource. Parameters for the sync configuration are determined by the sync type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSyncConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSyncConfigurationRequest#builder()}
     * </p>
     *
     * @param createSyncConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.CreateSyncConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSyncConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws ResourceAlreadyExistsException
     *         Unable to create resource. Resource already exists.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.CreateSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/CreateSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSyncConfigurationResponse createSyncConfiguration(
            Consumer<CreateSyncConfigurationRequest.Builder> createSyncConfigurationRequest) throws AccessDeniedException,
            ConcurrentModificationException, InternalServerException, InvalidInputException, LimitExceededException,
            ResourceAlreadyExistsException, ThrottlingException, AwsServiceException, SdkClientException,
            CodeConnectionsException {
        return createSyncConfiguration(CreateSyncConfigurationRequest.builder().applyMutation(createSyncConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * The connection to be deleted.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The connection to be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.DeleteConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.
     * </p>
     * <note>
     * <p>
     * A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.
     * </p>
     * </note>
     *
     * @param deleteHostRequest
     * @return Result of the DeleteHost operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ResourceUnavailableException
     *         Resource not found. Verify the ARN for the host resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.DeleteHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/DeleteHost" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteHostResponse deleteHost(DeleteHostRequest deleteHostRequest) throws ResourceNotFoundException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.
     * </p>
     * <note>
     * <p>
     * A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHostRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteHostRequest#builder()}
     * </p>
     *
     * @param deleteHostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.DeleteHostRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteHost operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ResourceUnavailableException
     *         Resource not found. Verify the ARN for the host resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.DeleteHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/DeleteHost" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteHostResponse deleteHost(Consumer<DeleteHostRequest.Builder> deleteHostRequest)
            throws ResourceNotFoundException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            CodeConnectionsException {
        return deleteHost(DeleteHostRequest.builder().applyMutation(deleteHostRequest).build());
    }

    /**
     * <p>
     * Deletes the association between your connection and a specified external Git repository.
     * </p>
     *
     * @param deleteRepositoryLinkRequest
     * @return Result of the DeleteRepositoryLink operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws SyncConfigurationStillExistsException
     *         Unable to continue. The sync blocker still exists.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UnsupportedProviderTypeException
     *         The specified provider type is not supported for connections.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.DeleteRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/DeleteRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRepositoryLinkResponse deleteRepositoryLink(DeleteRepositoryLinkRequest deleteRepositoryLinkRequest)
            throws AccessDeniedException, ConcurrentModificationException, InternalServerException, InvalidInputException,
            SyncConfigurationStillExistsException, ResourceNotFoundException, ThrottlingException,
            UnsupportedProviderTypeException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association between your connection and a specified external Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryLinkRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRepositoryLinkRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.DeleteRepositoryLinkRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteRepositoryLink operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws SyncConfigurationStillExistsException
     *         Unable to continue. The sync blocker still exists.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UnsupportedProviderTypeException
     *         The specified provider type is not supported for connections.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.DeleteRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/DeleteRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRepositoryLinkResponse deleteRepositoryLink(
            Consumer<DeleteRepositoryLinkRequest.Builder> deleteRepositoryLinkRequest) throws AccessDeniedException,
            ConcurrentModificationException, InternalServerException, InvalidInputException,
            SyncConfigurationStillExistsException, ResourceNotFoundException, ThrottlingException,
            UnsupportedProviderTypeException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return deleteRepositoryLink(DeleteRepositoryLinkRequest.builder().applyMutation(deleteRepositoryLinkRequest).build());
    }

    /**
     * <p>
     * Deletes the sync configuration for a specified repository and connection.
     * </p>
     *
     * @param deleteSyncConfigurationRequest
     * @return Result of the DeleteSyncConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.DeleteSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/DeleteSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSyncConfigurationResponse deleteSyncConfiguration(DeleteSyncConfigurationRequest deleteSyncConfigurationRequest)
            throws AccessDeniedException, ConcurrentModificationException, InternalServerException, InvalidInputException,
            LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the sync configuration for a specified repository and connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSyncConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSyncConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSyncConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.DeleteSyncConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteSyncConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.DeleteSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/DeleteSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSyncConfigurationResponse deleteSyncConfiguration(
            Consumer<DeleteSyncConfigurationRequest.Builder> deleteSyncConfigurationRequest) throws AccessDeniedException,
            ConcurrentModificationException, InternalServerException, InvalidInputException, LimitExceededException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return deleteSyncConfiguration(DeleteSyncConfigurationRequest.builder().applyMutation(deleteSyncConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Returns the connection ARN and details such as status, owner, and provider type.
     * </p>
     *
     * @param getConnectionRequest
     * @return Result of the GetConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ResourceUnavailableException
     *         Resource not found. Verify the ARN for the host resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectionResponse getConnection(GetConnectionRequest getConnectionRequest) throws ResourceNotFoundException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the connection ARN and details such as status, owner, and provider type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionRequest#builder()}
     * </p>
     *
     * @param getConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.GetConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the GetConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ResourceUnavailableException
     *         Resource not found. Verify the ARN for the host resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectionResponse getConnection(Consumer<GetConnectionRequest.Builder> getConnectionRequest)
            throws ResourceNotFoundException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            CodeConnectionsException {
        return getConnection(GetConnectionRequest.builder().applyMutation(getConnectionRequest).build());
    }

    /**
     * <p>
     * Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC
     * configuration.
     * </p>
     *
     * @param getHostRequest
     * @return Result of the GetHost operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ResourceUnavailableException
     *         Resource not found. Verify the ARN for the host resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetHost" target="_top">AWS API
     *      Documentation</a>
     */
    default GetHostResponse getHost(GetHostRequest getHostRequest) throws ResourceNotFoundException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC
     * configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHostRequest.Builder} avoiding the need to create
     * one manually via {@link GetHostRequest#builder()}
     * </p>
     *
     * @param getHostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.GetHostRequest.Builder} to create a request.
     * @return Result of the GetHost operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ResourceUnavailableException
     *         Resource not found. Verify the ARN for the host resource and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetHost" target="_top">AWS API
     *      Documentation</a>
     */
    default GetHostResponse getHost(Consumer<GetHostRequest.Builder> getHostRequest) throws ResourceNotFoundException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return getHost(GetHostRequest.builder().applyMutation(getHostRequest).build());
    }

    /**
     * <p>
     * Returns details about a repository link. A repository link allows Git sync to monitor and sync changes from files
     * in a specified Git repository.
     * </p>
     *
     * @param getRepositoryLinkRequest
     * @return Result of the GetRepositoryLink operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRepositoryLinkResponse getRepositoryLink(GetRepositoryLinkRequest getRepositoryLinkRequest)
            throws AccessDeniedException, ConcurrentModificationException, InternalServerException, InvalidInputException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a repository link. A repository link allows Git sync to monitor and sync changes from files
     * in a specified Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryLinkRequest.Builder} avoiding the need
     * to create one manually via {@link GetRepositoryLinkRequest#builder()}
     * </p>
     *
     * @param getRepositoryLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.GetRepositoryLinkRequest.Builder} to create a
     *        request.
     * @return Result of the GetRepositoryLink operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRepositoryLinkResponse getRepositoryLink(Consumer<GetRepositoryLinkRequest.Builder> getRepositoryLinkRequest)
            throws AccessDeniedException, ConcurrentModificationException, InternalServerException, InvalidInputException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return getRepositoryLink(GetRepositoryLinkRequest.builder().applyMutation(getRepositoryLinkRequest).build());
    }

    /**
     * <p>
     * Returns details about the sync status for a repository. A repository sync uses Git sync to push and pull changes
     * from your remote repository.
     * </p>
     *
     * @param getRepositorySyncStatusRequest
     * @return Result of the GetRepositorySyncStatus operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetRepositorySyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetRepositorySyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRepositorySyncStatusResponse getRepositorySyncStatus(GetRepositorySyncStatusRequest getRepositorySyncStatusRequest)
            throws AccessDeniedException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the sync status for a repository. A repository sync uses Git sync to push and pull changes
     * from your remote repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositorySyncStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetRepositorySyncStatusRequest#builder()}
     * </p>
     *
     * @param getRepositorySyncStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.GetRepositorySyncStatusRequest.Builder} to
     *        create a request.
     * @return Result of the GetRepositorySyncStatus operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetRepositorySyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetRepositorySyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRepositorySyncStatusResponse getRepositorySyncStatus(
            Consumer<GetRepositorySyncStatusRequest.Builder> getRepositorySyncStatusRequest) throws AccessDeniedException,
            InternalServerException, InvalidInputException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return getRepositorySyncStatus(GetRepositorySyncStatusRequest.builder().applyMutation(getRepositorySyncStatusRequest)
                .build());
    }

    /**
     * <p>
     * Returns the status of the sync with the Git repository for a specific Amazon Web Services resource.
     * </p>
     *
     * @param getResourceSyncStatusRequest
     * @return Result of the GetResourceSyncStatus operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetResourceSyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetResourceSyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceSyncStatusResponse getResourceSyncStatus(GetResourceSyncStatusRequest getResourceSyncStatusRequest)
            throws AccessDeniedException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of the sync with the Git repository for a specific Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceSyncStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceSyncStatusRequest#builder()}
     * </p>
     *
     * @param getResourceSyncStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.GetResourceSyncStatusRequest.Builder} to
     *        create a request.
     * @return Result of the GetResourceSyncStatus operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetResourceSyncStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetResourceSyncStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceSyncStatusResponse getResourceSyncStatus(
            Consumer<GetResourceSyncStatusRequest.Builder> getResourceSyncStatusRequest) throws AccessDeniedException,
            InternalServerException, InvalidInputException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return getResourceSyncStatus(GetResourceSyncStatusRequest.builder().applyMutation(getResourceSyncStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of the most recent sync blockers.
     * </p>
     *
     * @param getSyncBlockerSummaryRequest
     * @return Result of the GetSyncBlockerSummary operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetSyncBlockerSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetSyncBlockerSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSyncBlockerSummaryResponse getSyncBlockerSummary(GetSyncBlockerSummaryRequest getSyncBlockerSummaryRequest)
            throws AccessDeniedException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the most recent sync blockers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSyncBlockerSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetSyncBlockerSummaryRequest#builder()}
     * </p>
     *
     * @param getSyncBlockerSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.GetSyncBlockerSummaryRequest.Builder} to
     *        create a request.
     * @return Result of the GetSyncBlockerSummary operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetSyncBlockerSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetSyncBlockerSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSyncBlockerSummaryResponse getSyncBlockerSummary(
            Consumer<GetSyncBlockerSummaryRequest.Builder> getSyncBlockerSummaryRequest) throws AccessDeniedException,
            InternalServerException, InvalidInputException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return getSyncBlockerSummary(GetSyncBlockerSummaryRequest.builder().applyMutation(getSyncBlockerSummaryRequest).build());
    }

    /**
     * <p>
     * Returns details about a sync configuration, including the sync type and resource name. A sync configuration
     * allows the configuration to sync (push and pull) changes from the remote repository for a specified branch in a
     * Git repository.
     * </p>
     *
     * @param getSyncConfigurationRequest
     * @return Result of the GetSyncConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSyncConfigurationResponse getSyncConfiguration(GetSyncConfigurationRequest getSyncConfigurationRequest)
            throws AccessDeniedException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a sync configuration, including the sync type and resource name. A sync configuration
     * allows the configuration to sync (push and pull) changes from the remote repository for a specified branch in a
     * Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSyncConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetSyncConfigurationRequest#builder()}
     * </p>
     *
     * @param getSyncConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.GetSyncConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetSyncConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.GetSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/GetSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSyncConfigurationResponse getSyncConfiguration(
            Consumer<GetSyncConfigurationRequest.Builder> getSyncConfigurationRequest) throws AccessDeniedException,
            InternalServerException, InvalidInputException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return getSyncConfiguration(GetSyncConfigurationRequest.builder().applyMutation(getSyncConfigurationRequest).build());
    }

    /**
     * <p>
     * Lists the connections associated with your account.
     * </p>
     *
     * @param listConnectionsRequest
     * @return Result of the ListConnections operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectionsResponse listConnections(ListConnectionsRequest listConnectionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the connections associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectionsRequest#builder()}
     * </p>
     *
     * @param listConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.ListConnectionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListConnections operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectionsResponse listConnections(Consumer<ListConnectionsRequest.Builder> listConnectionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return listConnections(ListConnectionsRequest.builder().applyMutation(listConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnections(software.amazon.awssdk.services.codeconnections.model.ListConnectionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListConnectionsIterable responses = client.listConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeconnections.paginators.ListConnectionsIterable responses = client
     *             .listConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.codeconnections.model.ListConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListConnectionsIterable responses = client.listConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnections(software.amazon.awssdk.services.codeconnections.model.ListConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectionsIterable listConnectionsPaginator(ListConnectionsRequest listConnectionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return new ListConnectionsIterable(this, listConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnections(software.amazon.awssdk.services.codeconnections.model.ListConnectionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListConnectionsIterable responses = client.listConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeconnections.paginators.ListConnectionsIterable responses = client
     *             .listConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.codeconnections.model.ListConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListConnectionsIterable responses = client.listConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnections(software.amazon.awssdk.services.codeconnections.model.ListConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConnectionsRequest#builder()}
     * </p>
     *
     * @param listConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.ListConnectionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectionsIterable listConnectionsPaginator(Consumer<ListConnectionsRequest.Builder> listConnectionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return listConnectionsPaginator(ListConnectionsRequest.builder().applyMutation(listConnectionsRequest).build());
    }

    /**
     * <p>
     * Lists the hosts associated with your account.
     * </p>
     *
     * @param listHostsRequest
     * @return Result of the ListHosts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListHosts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHostsResponse listHosts(ListHostsRequest listHostsRequest) throws AwsServiceException, SdkClientException,
            CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the hosts associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHostsRequest#builder()}
     * </p>
     *
     * @param listHostsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.ListHostsRequest.Builder} to create a
     *        request.
     * @return Result of the ListHosts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListHosts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHostsResponse listHosts(Consumer<ListHostsRequest.Builder> listHostsRequest) throws AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return listHosts(ListHostsRequest.builder().applyMutation(listHostsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listHosts(software.amazon.awssdk.services.codeconnections.model.ListHostsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListHostsIterable responses = client.listHostsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeconnections.paginators.ListHostsIterable responses = client.listHostsPaginator(request);
     *     for (software.amazon.awssdk.services.codeconnections.model.ListHostsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListHostsIterable responses = client.listHostsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHosts(software.amazon.awssdk.services.codeconnections.model.ListHostsRequest)} operation.</b>
     * </p>
     *
     * @param listHostsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListHosts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHostsIterable listHostsPaginator(ListHostsRequest listHostsRequest) throws AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return new ListHostsIterable(this, listHostsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listHosts(software.amazon.awssdk.services.codeconnections.model.ListHostsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListHostsIterable responses = client.listHostsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeconnections.paginators.ListHostsIterable responses = client.listHostsPaginator(request);
     *     for (software.amazon.awssdk.services.codeconnections.model.ListHostsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListHostsIterable responses = client.listHostsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHosts(software.amazon.awssdk.services.codeconnections.model.ListHostsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHostsRequest#builder()}
     * </p>
     *
     * @param listHostsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.ListHostsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListHosts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHostsIterable listHostsPaginator(Consumer<ListHostsRequest.Builder> listHostsRequest) throws AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return listHostsPaginator(ListHostsRequest.builder().applyMutation(listHostsRequest).build());
    }

    /**
     * <p>
     * Lists the repository links created for connections in your account.
     * </p>
     *
     * @param listRepositoryLinksRequest
     * @return Result of the ListRepositoryLinks operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListRepositoryLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListRepositoryLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositoryLinksResponse listRepositoryLinks(ListRepositoryLinksRequest listRepositoryLinksRequest)
            throws AccessDeniedException, ConcurrentModificationException, InternalServerException, InvalidInputException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the repository links created for connections in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoryLinksRequest.Builder} avoiding the
     * need to create one manually via {@link ListRepositoryLinksRequest#builder()}
     * </p>
     *
     * @param listRepositoryLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksRequest.Builder} to create
     *        a request.
     * @return Result of the ListRepositoryLinks operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListRepositoryLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListRepositoryLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositoryLinksResponse listRepositoryLinks(
            Consumer<ListRepositoryLinksRequest.Builder> listRepositoryLinksRequest) throws AccessDeniedException,
            ConcurrentModificationException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return listRepositoryLinks(ListRepositoryLinksRequest.builder().applyMutation(listRepositoryLinksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRepositoryLinks(software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListRepositoryLinksIterable responses = client.listRepositoryLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeconnections.paginators.ListRepositoryLinksIterable responses = client
     *             .listRepositoryLinksPaginator(request);
     *     for (software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListRepositoryLinksIterable responses = client.listRepositoryLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositoryLinks(software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRepositoryLinksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListRepositoryLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListRepositoryLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositoryLinksIterable listRepositoryLinksPaginator(ListRepositoryLinksRequest listRepositoryLinksRequest)
            throws AccessDeniedException, ConcurrentModificationException, InternalServerException, InvalidInputException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return new ListRepositoryLinksIterable(this, listRepositoryLinksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRepositoryLinks(software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListRepositoryLinksIterable responses = client.listRepositoryLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeconnections.paginators.ListRepositoryLinksIterable responses = client
     *             .listRepositoryLinksPaginator(request);
     *     for (software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListRepositoryLinksIterable responses = client.listRepositoryLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositoryLinks(software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoryLinksRequest.Builder} avoiding the
     * need to create one manually via {@link ListRepositoryLinksRequest#builder()}
     * </p>
     *
     * @param listRepositoryLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListRepositoryLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListRepositoryLinks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositoryLinksIterable listRepositoryLinksPaginator(
            Consumer<ListRepositoryLinksRequest.Builder> listRepositoryLinksRequest) throws AccessDeniedException,
            ConcurrentModificationException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return listRepositoryLinksPaginator(ListRepositoryLinksRequest.builder().applyMutation(listRepositoryLinksRequest)
                .build());
    }

    /**
     * <p>
     * Lists the repository sync definitions for repository links in your account.
     * </p>
     *
     * @param listRepositorySyncDefinitionsRequest
     * @return Result of the ListRepositorySyncDefinitions operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListRepositorySyncDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListRepositorySyncDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositorySyncDefinitionsResponse listRepositorySyncDefinitions(
            ListRepositorySyncDefinitionsRequest listRepositorySyncDefinitionsRequest) throws AccessDeniedException,
            InternalServerException, InvalidInputException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the repository sync definitions for repository links in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositorySyncDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRepositorySyncDefinitionsRequest#builder()}
     * </p>
     *
     * @param listRepositorySyncDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.ListRepositorySyncDefinitionsRequest.Builder}
     *        to create a request.
     * @return Result of the ListRepositorySyncDefinitions operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListRepositorySyncDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListRepositorySyncDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositorySyncDefinitionsResponse listRepositorySyncDefinitions(
            Consumer<ListRepositorySyncDefinitionsRequest.Builder> listRepositorySyncDefinitionsRequest)
            throws AccessDeniedException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return listRepositorySyncDefinitions(ListRepositorySyncDefinitionsRequest.builder()
                .applyMutation(listRepositorySyncDefinitionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of sync configurations for a specified repository.
     * </p>
     *
     * @param listSyncConfigurationsRequest
     * @return Result of the ListSyncConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListSyncConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListSyncConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncConfigurationsResponse listSyncConfigurations(ListSyncConfigurationsRequest listSyncConfigurationsRequest)
            throws AccessDeniedException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of sync configurations for a specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSyncConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSyncConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListSyncConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListSyncConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListSyncConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncConfigurationsResponse listSyncConfigurations(
            Consumer<ListSyncConfigurationsRequest.Builder> listSyncConfigurationsRequest) throws AccessDeniedException,
            InternalServerException, InvalidInputException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return listSyncConfigurations(ListSyncConfigurationsRequest.builder().applyMutation(listSyncConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSyncConfigurations(software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListSyncConfigurationsIterable responses = client.listSyncConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeconnections.paginators.ListSyncConfigurationsIterable responses = client
     *             .listSyncConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListSyncConfigurationsIterable responses = client.listSyncConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncConfigurations(software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSyncConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListSyncConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListSyncConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncConfigurationsIterable listSyncConfigurationsPaginator(
            ListSyncConfigurationsRequest listSyncConfigurationsRequest) throws AccessDeniedException, InternalServerException,
            InvalidInputException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            CodeConnectionsException {
        return new ListSyncConfigurationsIterable(this, listSyncConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSyncConfigurations(software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListSyncConfigurationsIterable responses = client.listSyncConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeconnections.paginators.ListSyncConfigurationsIterable responses = client
     *             .listSyncConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeconnections.paginators.ListSyncConfigurationsIterable responses = client.listSyncConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSyncConfigurations(software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSyncConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSyncConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSyncConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.ListSyncConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListSyncConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListSyncConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSyncConfigurationsIterable listSyncConfigurationsPaginator(
            Consumer<ListSyncConfigurationsRequest.Builder> listSyncConfigurationsRequest) throws AccessDeniedException,
            InternalServerException, InvalidInputException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return listSyncConfigurationsPaginator(ListSyncConfigurationsRequest.builder()
                .applyMutation(listSyncConfigurationsRequest).build());
    }

    /**
     * <p>
     * Gets the set of key-value pairs (metadata) that are used to manage the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the set of key-value pairs (metadata) that are used to manage the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeConnectionsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws LimitExceededException
     *         Exceeded the maximum limit for connections.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            CodeConnectionsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a specified host with the provided configurations.
     * </p>
     *
     * @param updateHostRequest
     * @return Result of the UpdateHost operation returned by the service.
     * @throws ConflictException
     *         Two conflicting operations have been made on the same resource.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ResourceUnavailableException
     *         Resource not found. Verify the ARN for the host resource and try again.
     * @throws UnsupportedOperationException
     *         The operation is not supported. Check the connection status and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.UpdateHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/UpdateHost" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateHostResponse updateHost(UpdateHostRequest updateHostRequest) throws ConflictException,
            ResourceNotFoundException, ResourceUnavailableException,
            software.amazon.awssdk.services.codeconnections.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specified host with the provided configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHostRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateHostRequest#builder()}
     * </p>
     *
     * @param updateHostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.UpdateHostRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateHost operation returned by the service.
     * @throws ConflictException
     *         Two conflicting operations have been made on the same resource.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ResourceUnavailableException
     *         Resource not found. Verify the ARN for the host resource and try again.
     * @throws UnsupportedOperationException
     *         The operation is not supported. Check the connection status and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.UpdateHost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/UpdateHost" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateHostResponse updateHost(Consumer<UpdateHostRequest.Builder> updateHostRequest) throws ConflictException,
            ResourceNotFoundException, ResourceUnavailableException,
            software.amazon.awssdk.services.codeconnections.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return updateHost(UpdateHostRequest.builder().applyMutation(updateHostRequest).build());
    }

    /**
     * <p>
     * Updates the association between your connection and a specified external Git repository. A repository link allows
     * Git sync to monitor and sync changes to files in a specified Git repository.
     * </p>
     *
     * @param updateRepositoryLinkRequest
     * @return Result of the UpdateRepositoryLink operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConditionalCheckFailedException
     *         The conditional check failed. Try again later.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UpdateOutOfSyncException
     *         The update is out of sync. Try syncing again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.UpdateRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/UpdateRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRepositoryLinkResponse updateRepositoryLink(UpdateRepositoryLinkRequest updateRepositoryLinkRequest)
            throws AccessDeniedException, ConditionalCheckFailedException, InternalServerException, InvalidInputException,
            ResourceNotFoundException, ThrottlingException, UpdateOutOfSyncException, AwsServiceException, SdkClientException,
            CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the association between your connection and a specified external Git repository. A repository link allows
     * Git sync to monitor and sync changes to files in a specified Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRepositoryLinkRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRepositoryLinkRequest#builder()}
     * </p>
     *
     * @param updateRepositoryLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.UpdateRepositoryLinkRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateRepositoryLink operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConditionalCheckFailedException
     *         The conditional check failed. Try again later.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UpdateOutOfSyncException
     *         The update is out of sync. Try syncing again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.UpdateRepositoryLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/UpdateRepositoryLink"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRepositoryLinkResponse updateRepositoryLink(
            Consumer<UpdateRepositoryLinkRequest.Builder> updateRepositoryLinkRequest) throws AccessDeniedException,
            ConditionalCheckFailedException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            ThrottlingException, UpdateOutOfSyncException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return updateRepositoryLink(UpdateRepositoryLinkRequest.builder().applyMutation(updateRepositoryLinkRequest).build());
    }

    /**
     * <p>
     * Allows you to update the status of a sync blocker, resolving the blocker and allowing syncing to continue.
     * </p>
     *
     * @param updateSyncBlockerRequest
     * @return Result of the UpdateSyncBlocker operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws RetryLatestCommitFailedException
     *         Retrying the latest commit failed. Try again later.
     * @throws SyncBlockerDoesNotExistException
     *         Unable to continue. The sync blocker does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.UpdateSyncBlocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/UpdateSyncBlocker"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSyncBlockerResponse updateSyncBlocker(UpdateSyncBlockerRequest updateSyncBlockerRequest)
            throws AccessDeniedException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            RetryLatestCommitFailedException, SyncBlockerDoesNotExistException, ThrottlingException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to update the status of a sync blocker, resolving the blocker and allowing syncing to continue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSyncBlockerRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSyncBlockerRequest#builder()}
     * </p>
     *
     * @param updateSyncBlockerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.UpdateSyncBlockerRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSyncBlocker operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws RetryLatestCommitFailedException
     *         Retrying the latest commit failed. Try again later.
     * @throws SyncBlockerDoesNotExistException
     *         Unable to continue. The sync blocker does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.UpdateSyncBlocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/UpdateSyncBlocker"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSyncBlockerResponse updateSyncBlocker(Consumer<UpdateSyncBlockerRequest.Builder> updateSyncBlockerRequest)
            throws AccessDeniedException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            RetryLatestCommitFailedException, SyncBlockerDoesNotExistException, ThrottlingException, AwsServiceException,
            SdkClientException, CodeConnectionsException {
        return updateSyncBlocker(UpdateSyncBlockerRequest.builder().applyMutation(updateSyncBlockerRequest).build());
    }

    /**
     * <p>
     * Updates the sync configuration for your connection and a specified external Git repository.
     * </p>
     *
     * @param updateSyncConfigurationRequest
     * @return Result of the UpdateSyncConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UpdateOutOfSyncException
     *         The update is out of sync. Try syncing again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.UpdateSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/UpdateSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSyncConfigurationResponse updateSyncConfiguration(UpdateSyncConfigurationRequest updateSyncConfigurationRequest)
            throws AccessDeniedException, ConcurrentModificationException, InternalServerException, InvalidInputException,
            ResourceNotFoundException, ThrottlingException, UpdateOutOfSyncException, AwsServiceException, SdkClientException,
            CodeConnectionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the sync configuration for your connection and a specified external Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSyncConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSyncConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSyncConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codeconnections.model.UpdateSyncConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateSyncConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modification to an application. For example, two individuals
     *         attempting to edit the same application at the same time.
     * @throws InternalServerException
     *         Received an internal server exception. Try again later.
     * @throws InvalidInputException
     *         The input is not valid. Verify that the action is typed correctly.
     * @throws ResourceNotFoundException
     *         Resource not found. Verify the connection resource ARN and try again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UpdateOutOfSyncException
     *         The update is out of sync. Try syncing again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeConnectionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeConnectionsClient.UpdateSyncConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/UpdateSyncConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSyncConfigurationResponse updateSyncConfiguration(
            Consumer<UpdateSyncConfigurationRequest.Builder> updateSyncConfigurationRequest) throws AccessDeniedException,
            ConcurrentModificationException, InternalServerException, InvalidInputException, ResourceNotFoundException,
            ThrottlingException, UpdateOutOfSyncException, AwsServiceException, SdkClientException, CodeConnectionsException {
        return updateSyncConfiguration(UpdateSyncConfigurationRequest.builder().applyMutation(updateSyncConfigurationRequest)
                .build());
    }

    /**
     * Create a {@link CodeConnectionsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodeConnectionsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeConnectionsClient}.
     */
    static CodeConnectionsClientBuilder builder() {
        return new DefaultCodeConnectionsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CodeConnectionsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
