/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSyncConfigurationsRequest extends CodeConnectionsRequest implements
        ToCopyableBuilder<ListSyncConfigurationsRequest.Builder, ListSyncConfigurationsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListSyncConfigurationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSyncConfigurationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REPOSITORY_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryLinkId").getter(getter(ListSyncConfigurationsRequest::repositoryLinkId))
            .setter(setter(Builder::repositoryLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkId").build()).build();

    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncType").getter(getter(ListSyncConfigurationsRequest::syncTypeAsString))
            .setter(setter(Builder::syncType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, REPOSITORY_LINK_ID_FIELD, SYNC_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String repositoryLinkId;

    private final String syncType;

    private ListSyncConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.repositoryLinkId = builder.repositoryLinkId;
        this.syncType = builder.syncType;
    }

    /**
     * <p>
     * A non-zero, non-negative integer used to limit the number of returned results.
     * </p>
     * 
     * @return A non-zero, non-negative integer used to limit the number of returned results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An enumeration token that allows the operation to batch the results of the operation.
     * </p>
     * 
     * @return An enumeration token that allows the operation to batch the results of the operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the repository link for the requested list of sync configurations.
     * </p>
     * 
     * @return The ID of the repository link for the requested list of sync configurations.
     */
    public final String repositoryLinkId() {
        return repositoryLinkId;
    }

    /**
     * <p>
     * The sync type for the requested list of sync configurations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The sync type for the requested list of sync configurations.
     * @see SyncConfigurationType
     */
    public final SyncConfigurationType syncType() {
        return SyncConfigurationType.fromValue(syncType);
    }

    /**
     * <p>
     * The sync type for the requested list of sync configurations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The sync type for the requested list of sync configurations.
     * @see SyncConfigurationType
     */
    public final String syncTypeAsString() {
        return syncType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(syncTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSyncConfigurationsRequest)) {
            return false;
        }
        ListSyncConfigurationsRequest other = (ListSyncConfigurationsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(repositoryLinkId(), other.repositoryLinkId())
                && Objects.equals(syncTypeAsString(), other.syncTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSyncConfigurationsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("RepositoryLinkId", repositoryLinkId()).add("SyncType", syncTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RepositoryLinkId":
            return Optional.ofNullable(clazz.cast(repositoryLinkId()));
        case "SyncType":
            return Optional.ofNullable(clazz.cast(syncTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RepositoryLinkId", REPOSITORY_LINK_ID_FIELD);
        map.put("SyncType", SYNC_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSyncConfigurationsRequest, T> g) {
        return obj -> g.apply((ListSyncConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeConnectionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSyncConfigurationsRequest> {
        /**
         * <p>
         * A non-zero, non-negative integer used to limit the number of returned results.
         * </p>
         * 
         * @param maxResults
         *        A non-zero, non-negative integer used to limit the number of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An enumeration token that allows the operation to batch the results of the operation.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that allows the operation to batch the results of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the repository link for the requested list of sync configurations.
         * </p>
         * 
         * @param repositoryLinkId
         *        The ID of the repository link for the requested list of sync configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryLinkId(String repositoryLinkId);

        /**
         * <p>
         * The sync type for the requested list of sync configurations.
         * </p>
         * 
         * @param syncType
         *        The sync type for the requested list of sync configurations.
         * @see SyncConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncConfigurationType
         */
        Builder syncType(String syncType);

        /**
         * <p>
         * The sync type for the requested list of sync configurations.
         * </p>
         * 
         * @param syncType
         *        The sync type for the requested list of sync configurations.
         * @see SyncConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncConfigurationType
         */
        Builder syncType(SyncConfigurationType syncType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeConnectionsRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String repositoryLinkId;

        private String syncType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSyncConfigurationsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            repositoryLinkId(model.repositoryLinkId);
            syncType(model.syncType);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRepositoryLinkId() {
            return repositoryLinkId;
        }

        public final void setRepositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
        }

        @Override
        public final Builder repositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        public final String getSyncType() {
            return syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        @Override
        public final Builder syncType(SyncConfigurationType syncType) {
            this.syncType(syncType == null ? null : syncType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSyncConfigurationsRequest build() {
            return new ListSyncConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
