/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRepositoryLinkRequest extends CodeConnectionsRequest implements
        ToCopyableBuilder<UpdateRepositoryLinkRequest.Builder, UpdateRepositoryLinkRequest> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(UpdateRepositoryLinkRequest::connectionArn))
            .setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(UpdateRepositoryLinkRequest::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<String> REPOSITORY_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryLinkId").getter(getter(UpdateRepositoryLinkRequest::repositoryLinkId))
            .setter(setter(Builder::repositoryLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD,
            ENCRYPTION_KEY_ARN_FIELD, REPOSITORY_LINK_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectionArn;

    private final String encryptionKeyArn;

    private final String repositoryLinkId;

    private UpdateRepositoryLinkRequest(BuilderImpl builder) {
        super(builder);
        this.connectionArn = builder.connectionArn;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.repositoryLinkId = builder.repositoryLinkId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connection for the repository link to be updated. The updated connection
     * ARN must have the same providerType (such as GitHub) as the original connection ARN for the repo link.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connection for the repository link to be updated. The updated
     *         connection ARN must have the same providerType (such as GitHub) as the original connection ARN for the
     *         repo link.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the encryption key for the repository link to be updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the encryption key for the repository link to be updated.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The ID of the repository link to be updated.
     * </p>
     * 
     * @return The ID of the repository link to be updated.
     */
    public final String repositoryLinkId() {
        return repositoryLinkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryLinkId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRepositoryLinkRequest)) {
            return false;
        }
        UpdateRepositoryLinkRequest other = (UpdateRepositoryLinkRequest) obj;
        return Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(repositoryLinkId(), other.repositoryLinkId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRepositoryLinkRequest").add("ConnectionArn", connectionArn())
                .add("EncryptionKeyArn", encryptionKeyArn()).add("RepositoryLinkId", repositoryLinkId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "RepositoryLinkId":
            return Optional.ofNullable(clazz.cast(repositoryLinkId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionArn", CONNECTION_ARN_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("RepositoryLinkId", REPOSITORY_LINK_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRepositoryLinkRequest, T> g) {
        return obj -> g.apply((UpdateRepositoryLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeConnectionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRepositoryLinkRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connection for the repository link to be updated. The updated
         * connection ARN must have the same providerType (such as GitHub) as the original connection ARN for the repo
         * link.
         * </p>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) of the connection for the repository link to be updated. The updated
         *        connection ARN must have the same providerType (such as GitHub) as the original connection ARN for the
         *        repo link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the encryption key for the repository link to be updated.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The Amazon Resource Name (ARN) of the encryption key for the repository link to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The ID of the repository link to be updated.
         * </p>
         * 
         * @param repositoryLinkId
         *        The ID of the repository link to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryLinkId(String repositoryLinkId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeConnectionsRequest.BuilderImpl implements Builder {
        private String connectionArn;

        private String encryptionKeyArn;

        private String repositoryLinkId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRepositoryLinkRequest model) {
            super(model);
            connectionArn(model.connectionArn);
            encryptionKeyArn(model.encryptionKeyArn);
            repositoryLinkId(model.repositoryLinkId);
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getRepositoryLinkId() {
            return repositoryLinkId;
        }

        public final void setRepositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
        }

        @Override
        public final Builder repositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRepositoryLinkRequest build() {
            return new UpdateRepositoryLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
