/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommitDiffSourceCodeType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommitDiffSourceCodeType> {
    private static final SdkField<String> SOURCE_COMMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCommit").getter(CommitDiffSourceCodeType.getter(CommitDiffSourceCodeType::sourceCommit)).setter(CommitDiffSourceCodeType.setter(Builder::sourceCommit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCommit").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCommit").getter(CommitDiffSourceCodeType.getter(CommitDiffSourceCodeType::destinationCommit)).setter(CommitDiffSourceCodeType.setter(Builder::destinationCommit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCommit").build()}).build();
    private static final SdkField<String> MERGE_BASE_COMMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MergeBaseCommit").getter(CommitDiffSourceCodeType.getter(CommitDiffSourceCodeType::mergeBaseCommit)).setter(CommitDiffSourceCodeType.setter(Builder::mergeBaseCommit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeBaseCommit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_COMMIT_FIELD, DESTINATION_COMMIT_FIELD, MERGE_BASE_COMMIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceCommit;
    private final String destinationCommit;
    private final String mergeBaseCommit;

    private CommitDiffSourceCodeType(BuilderImpl builder) {
        this.sourceCommit = builder.sourceCommit;
        this.destinationCommit = builder.destinationCommit;
        this.mergeBaseCommit = builder.mergeBaseCommit;
    }

    public final String sourceCommit() {
        return this.sourceCommit;
    }

    public final String destinationCommit() {
        return this.destinationCommit;
    }

    public final String mergeBaseCommit() {
        return this.mergeBaseCommit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommit());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommit());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeBaseCommit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitDiffSourceCodeType)) {
            return false;
        }
        CommitDiffSourceCodeType other = (CommitDiffSourceCodeType)obj;
        return Objects.equals(this.sourceCommit(), other.sourceCommit()) && Objects.equals(this.destinationCommit(), other.destinationCommit()) && Objects.equals(this.mergeBaseCommit(), other.mergeBaseCommit());
    }

    public final String toString() {
        return ToString.builder((String)"CommitDiffSourceCodeType").add("SourceCommit", (Object)this.sourceCommit()).add("DestinationCommit", (Object)this.destinationCommit()).add("MergeBaseCommit", (Object)this.mergeBaseCommit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceCommit": {
                return Optional.ofNullable(clazz.cast(this.sourceCommit()));
            }
            case "DestinationCommit": {
                return Optional.ofNullable(clazz.cast(this.destinationCommit()));
            }
            case "MergeBaseCommit": {
                return Optional.ofNullable(clazz.cast(this.mergeBaseCommit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommitDiffSourceCodeType, T> g) {
        return obj -> g.apply((CommitDiffSourceCodeType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceCommit;
        private String destinationCommit;
        private String mergeBaseCommit;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitDiffSourceCodeType model) {
            this.sourceCommit(model.sourceCommit);
            this.destinationCommit(model.destinationCommit);
            this.mergeBaseCommit(model.mergeBaseCommit);
        }

        public final String getSourceCommit() {
            return this.sourceCommit;
        }

        public final void setSourceCommit(String sourceCommit) {
            this.sourceCommit = sourceCommit;
        }

        @Override
        public final Builder sourceCommit(String sourceCommit) {
            this.sourceCommit = sourceCommit;
            return this;
        }

        public final String getDestinationCommit() {
            return this.destinationCommit;
        }

        public final void setDestinationCommit(String destinationCommit) {
            this.destinationCommit = destinationCommit;
        }

        @Override
        public final Builder destinationCommit(String destinationCommit) {
            this.destinationCommit = destinationCommit;
            return this;
        }

        public final String getMergeBaseCommit() {
            return this.mergeBaseCommit;
        }

        public final void setMergeBaseCommit(String mergeBaseCommit) {
            this.mergeBaseCommit = mergeBaseCommit;
        }

        @Override
        public final Builder mergeBaseCommit(String mergeBaseCommit) {
            this.mergeBaseCommit = mergeBaseCommit;
            return this;
        }

        public CommitDiffSourceCodeType build() {
            return new CommitDiffSourceCodeType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommitDiffSourceCodeType> {
        public Builder sourceCommit(String var1);

        public Builder destinationCommit(String var1);

        public Builder mergeBaseCommit(String var1);
    }
}

