/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.Reaction;
import software.amazon.awssdk.services.codegurureviewer.model.ReactionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationFeedback
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationFeedback> {
    private static final SdkField<String> CODE_REVIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeReviewArn").getter(RecommendationFeedback.getter(RecommendationFeedback::codeReviewArn)).setter(RecommendationFeedback.setter(Builder::codeReviewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeReviewArn").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(RecommendationFeedback.getter(RecommendationFeedback::recommendationId)).setter(RecommendationFeedback.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<List<String>> REACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Reactions").getter(RecommendationFeedback.getter(RecommendationFeedback::reactionsAsStrings)).setter(RecommendationFeedback.setter(Builder::reactionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reactions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(RecommendationFeedback.getter(RecommendationFeedback::userId)).setter(RecommendationFeedback.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimeStamp").getter(RecommendationFeedback.getter(RecommendationFeedback::createdTimeStamp)).setter(RecommendationFeedback.setter(Builder::createdTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimeStamp").getter(RecommendationFeedback.getter(RecommendationFeedback::lastUpdatedTimeStamp)).setter(RecommendationFeedback.setter(Builder::lastUpdatedTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimeStamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REVIEW_ARN_FIELD, RECOMMENDATION_ID_FIELD, REACTIONS_FIELD, USER_ID_FIELD, CREATED_TIME_STAMP_FIELD, LAST_UPDATED_TIME_STAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String codeReviewArn;
    private final String recommendationId;
    private final List<String> reactions;
    private final String userId;
    private final Instant createdTimeStamp;
    private final Instant lastUpdatedTimeStamp;

    private RecommendationFeedback(BuilderImpl builder) {
        this.codeReviewArn = builder.codeReviewArn;
        this.recommendationId = builder.recommendationId;
        this.reactions = builder.reactions;
        this.userId = builder.userId;
        this.createdTimeStamp = builder.createdTimeStamp;
        this.lastUpdatedTimeStamp = builder.lastUpdatedTimeStamp;
    }

    public final String codeReviewArn() {
        return this.codeReviewArn;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final List<Reaction> reactions() {
        return ReactionsCopier.copyStringToEnum(this.reactions);
    }

    public final boolean hasReactions() {
        return this.reactions != null && !(this.reactions instanceof SdkAutoConstructList);
    }

    public final List<String> reactionsAsStrings() {
        return this.reactions;
    }

    public final String userId() {
        return this.userId;
    }

    public final Instant createdTimeStamp() {
        return this.createdTimeStamp;
    }

    public final Instant lastUpdatedTimeStamp() {
        return this.lastUpdatedTimeStamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeReviewArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReactions() ? this.reactionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimeStamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationFeedback)) {
            return false;
        }
        RecommendationFeedback other = (RecommendationFeedback)obj;
        return Objects.equals(this.codeReviewArn(), other.codeReviewArn()) && Objects.equals(this.recommendationId(), other.recommendationId()) && this.hasReactions() == other.hasReactions() && Objects.equals(this.reactionsAsStrings(), other.reactionsAsStrings()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.createdTimeStamp(), other.createdTimeStamp()) && Objects.equals(this.lastUpdatedTimeStamp(), other.lastUpdatedTimeStamp());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationFeedback").add("CodeReviewArn", (Object)this.codeReviewArn()).add("RecommendationId", (Object)this.recommendationId()).add("Reactions", this.hasReactions() ? this.reactionsAsStrings() : null).add("UserId", (Object)this.userId()).add("CreatedTimeStamp", (Object)this.createdTimeStamp()).add("LastUpdatedTimeStamp", (Object)this.lastUpdatedTimeStamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeReviewArn": {
                return Optional.ofNullable(clazz.cast(this.codeReviewArn()));
            }
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "Reactions": {
                return Optional.ofNullable(clazz.cast(this.reactionsAsStrings()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "CreatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimeStamp()));
            }
            case "LastUpdatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimeStamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationFeedback, T> g) {
        return obj -> g.apply((RecommendationFeedback)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String codeReviewArn;
        private String recommendationId;
        private List<String> reactions = DefaultSdkAutoConstructList.getInstance();
        private String userId;
        private Instant createdTimeStamp;
        private Instant lastUpdatedTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationFeedback model) {
            this.codeReviewArn(model.codeReviewArn);
            this.recommendationId(model.recommendationId);
            this.reactionsWithStrings(model.reactions);
            this.userId(model.userId);
            this.createdTimeStamp(model.createdTimeStamp);
            this.lastUpdatedTimeStamp(model.lastUpdatedTimeStamp);
        }

        public final String getCodeReviewArn() {
            return this.codeReviewArn;
        }

        public final void setCodeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
        }

        @Override
        public final Builder codeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final Collection<String> getReactions() {
            if (this.reactions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reactions;
        }

        public final void setReactions(Collection<String> reactions) {
            this.reactions = ReactionsCopier.copy(reactions);
        }

        @Override
        public final Builder reactionsWithStrings(Collection<String> reactions) {
            this.reactions = ReactionsCopier.copy(reactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactionsWithStrings(String ... reactions) {
            this.reactionsWithStrings(Arrays.asList(reactions));
            return this;
        }

        @Override
        public final Builder reactions(Collection<Reaction> reactions) {
            this.reactions = ReactionsCopier.copyEnumToString(reactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactions(Reaction ... reactions) {
            this.reactions(Arrays.asList(reactions));
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Instant getCreatedTimeStamp() {
            return this.createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final Instant getLastUpdatedTimeStamp() {
            return this.lastUpdatedTimeStamp;
        }

        public final void setLastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
        }

        @Override
        public final Builder lastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
            return this;
        }

        public RecommendationFeedback build() {
            return new RecommendationFeedback(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationFeedback> {
        public Builder codeReviewArn(String var1);

        public Builder recommendationId(String var1);

        public Builder reactionsWithStrings(Collection<String> var1);

        public Builder reactionsWithStrings(String ... var1);

        public Builder reactions(Collection<Reaction> var1);

        public Builder reactions(Reaction ... var1);

        public Builder userId(String var1);

        public Builder createdTimeStamp(Instant var1);

        public Builder lastUpdatedTimeStamp(Instant var1);
    }
}

