/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codegurusecurity.model.CodeGuruSecurityResponse;
import software.amazon.awssdk.services.codegurusecurity.model.RequestHeaderMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUploadUrlResponse
extends CodeGuruSecurityResponse
implements ToCopyableBuilder<Builder, CreateUploadUrlResponse> {
    private static final SdkField<String> CODE_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeArtifactId").getter(CreateUploadUrlResponse.getter(CreateUploadUrlResponse::codeArtifactId)).setter(CreateUploadUrlResponse.setter(Builder::codeArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeArtifactId").build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestHeaders").getter(CreateUploadUrlResponse.getter(CreateUploadUrlResponse::requestHeaders)).setter(CreateUploadUrlResponse.setter(Builder::requestHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestHeaders").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> S3_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Url").getter(CreateUploadUrlResponse.getter(CreateUploadUrlResponse::s3Url)).setter(CreateUploadUrlResponse.setter(Builder::s3Url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_ARTIFACT_ID_FIELD, REQUEST_HEADERS_FIELD, S3_URL_FIELD));
    private final String codeArtifactId;
    private final Map<String, String> requestHeaders;
    private final String s3Url;

    private CreateUploadUrlResponse(BuilderImpl builder) {
        super(builder);
        this.codeArtifactId = builder.codeArtifactId;
        this.requestHeaders = builder.requestHeaders;
        this.s3Url = builder.s3Url;
    }

    public final String codeArtifactId() {
        return this.codeArtifactId;
    }

    public final boolean hasRequestHeaders() {
        return this.requestHeaders != null && !(this.requestHeaders instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestHeaders() {
        return this.requestHeaders;
    }

    public final String s3Url() {
        return this.s3Url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestHeaders() ? this.requestHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUploadUrlResponse)) {
            return false;
        }
        CreateUploadUrlResponse other = (CreateUploadUrlResponse)((Object)obj);
        return Objects.equals(this.codeArtifactId(), other.codeArtifactId()) && this.hasRequestHeaders() == other.hasRequestHeaders() && Objects.equals(this.requestHeaders(), other.requestHeaders()) && Objects.equals(this.s3Url(), other.s3Url());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUploadUrlResponse").add("CodeArtifactId", (Object)this.codeArtifactId()).add("RequestHeaders", (Object)(this.requestHeaders() == null ? null : "*** Sensitive Data Redacted ***")).add("S3Url", (Object)(this.s3Url() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeArtifactId": {
                return Optional.ofNullable(clazz.cast(this.codeArtifactId()));
            }
            case "requestHeaders": {
                return Optional.ofNullable(clazz.cast(this.requestHeaders()));
            }
            case "s3Url": {
                return Optional.ofNullable(clazz.cast(this.s3Url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUploadUrlResponse, T> g) {
        return obj -> g.apply((CreateUploadUrlResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruSecurityResponse.BuilderImpl
    implements Builder {
        private String codeArtifactId;
        private Map<String, String> requestHeaders = DefaultSdkAutoConstructMap.getInstance();
        private String s3Url;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUploadUrlResponse model) {
            super(model);
            this.codeArtifactId(model.codeArtifactId);
            this.requestHeaders(model.requestHeaders);
            this.s3Url(model.s3Url);
        }

        public final String getCodeArtifactId() {
            return this.codeArtifactId;
        }

        public final void setCodeArtifactId(String codeArtifactId) {
            this.codeArtifactId = codeArtifactId;
        }

        @Override
        public final Builder codeArtifactId(String codeArtifactId) {
            this.codeArtifactId = codeArtifactId;
            return this;
        }

        public final Map<String, String> getRequestHeaders() {
            if (this.requestHeaders instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestHeaders;
        }

        public final void setRequestHeaders(Map<String, String> requestHeaders) {
            this.requestHeaders = RequestHeaderMapCopier.copy(requestHeaders);
        }

        @Override
        public final Builder requestHeaders(Map<String, String> requestHeaders) {
            this.requestHeaders = RequestHeaderMapCopier.copy(requestHeaders);
            return this;
        }

        public final String getS3Url() {
            return this.s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        @Override
        public CreateUploadUrlResponse build() {
            return new CreateUploadUrlResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruSecurityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUploadUrlResponse> {
        public Builder codeArtifactId(String var1);

        public Builder requestHeaders(Map<String, String> var1);

        public Builder s3Url(String var1);
    }
}

