/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurusecurity.model.AnalysisType;
import software.amazon.awssdk.services.codegurusecurity.model.CodeGuruSecurityResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ScanState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetScanResponse
extends CodeGuruSecurityResponse
implements ToCopyableBuilder<Builder, GetScanResponse> {
    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisType").getter(GetScanResponse.getter(GetScanResponse::analysisTypeAsString)).setter(GetScanResponse.setter(Builder::analysisType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetScanResponse.getter(GetScanResponse::createdAt)).setter(GetScanResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(GetScanResponse.getter(GetScanResponse::errorMessage)).setter(GetScanResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<Long> NUMBER_OF_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfRevisions").getter(GetScanResponse.getter(GetScanResponse::numberOfRevisions)).setter(GetScanResponse.setter(Builder::numberOfRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRevisions").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runId").getter(GetScanResponse.getter(GetScanResponse::runId)).setter(GetScanResponse.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()}).build();
    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanName").getter(GetScanResponse.getter(GetScanResponse::scanName)).setter(GetScanResponse.setter(Builder::scanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()}).build();
    private static final SdkField<String> SCAN_NAME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanNameArn").getter(GetScanResponse.getter(GetScanResponse::scanNameArn)).setter(GetScanResponse.setter(Builder::scanNameArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanNameArn").build()}).build();
    private static final SdkField<String> SCAN_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanState").getter(GetScanResponse.getter(GetScanResponse::scanStateAsString)).setter(GetScanResponse.setter(Builder::scanState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanState").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetScanResponse.getter(GetScanResponse::updatedAt)).setter(GetScanResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_TYPE_FIELD, CREATED_AT_FIELD, ERROR_MESSAGE_FIELD, NUMBER_OF_REVISIONS_FIELD, RUN_ID_FIELD, SCAN_NAME_FIELD, SCAN_NAME_ARN_FIELD, SCAN_STATE_FIELD, UPDATED_AT_FIELD));
    private final String analysisType;
    private final Instant createdAt;
    private final String errorMessage;
    private final Long numberOfRevisions;
    private final String runId;
    private final String scanName;
    private final String scanNameArn;
    private final String scanState;
    private final Instant updatedAt;

    private GetScanResponse(BuilderImpl builder) {
        super(builder);
        this.analysisType = builder.analysisType;
        this.createdAt = builder.createdAt;
        this.errorMessage = builder.errorMessage;
        this.numberOfRevisions = builder.numberOfRevisions;
        this.runId = builder.runId;
        this.scanName = builder.scanName;
        this.scanNameArn = builder.scanNameArn;
        this.scanState = builder.scanState;
        this.updatedAt = builder.updatedAt;
    }

    public final AnalysisType analysisType() {
        return AnalysisType.fromValue(this.analysisType);
    }

    public final String analysisTypeAsString() {
        return this.analysisType;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Long numberOfRevisions() {
        return this.numberOfRevisions;
    }

    public final String runId() {
        return this.runId;
    }

    public final String scanName() {
        return this.scanName;
    }

    public final String scanNameArn() {
        return this.scanNameArn;
    }

    public final ScanState scanState() {
        return ScanState.fromValue(this.scanState);
    }

    public final String scanStateAsString() {
        return this.scanState;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRevisions());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScanResponse)) {
            return false;
        }
        GetScanResponse other = (GetScanResponse)((Object)obj);
        return Objects.equals(this.analysisTypeAsString(), other.analysisTypeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.numberOfRevisions(), other.numberOfRevisions()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.scanName(), other.scanName()) && Objects.equals(this.scanNameArn(), other.scanNameArn()) && Objects.equals(this.scanStateAsString(), other.scanStateAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetScanResponse").add("AnalysisType", (Object)this.analysisTypeAsString()).add("CreatedAt", (Object)this.createdAt()).add("ErrorMessage", (Object)this.errorMessage()).add("NumberOfRevisions", (Object)this.numberOfRevisions()).add("RunId", (Object)this.runId()).add("ScanName", (Object)this.scanName()).add("ScanNameArn", (Object)this.scanNameArn()).add("ScanState", (Object)this.scanStateAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analysisType": {
                return Optional.ofNullable(clazz.cast(this.analysisTypeAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "numberOfRevisions": {
                return Optional.ofNullable(clazz.cast(this.numberOfRevisions()));
            }
            case "runId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "scanName": {
                return Optional.ofNullable(clazz.cast(this.scanName()));
            }
            case "scanNameArn": {
                return Optional.ofNullable(clazz.cast(this.scanNameArn()));
            }
            case "scanState": {
                return Optional.ofNullable(clazz.cast(this.scanStateAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetScanResponse, T> g) {
        return obj -> g.apply((GetScanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruSecurityResponse.BuilderImpl
    implements Builder {
        private String analysisType;
        private Instant createdAt;
        private String errorMessage;
        private Long numberOfRevisions;
        private String runId;
        private String scanName;
        private String scanNameArn;
        private String scanState;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScanResponse model) {
            super(model);
            this.analysisType(model.analysisType);
            this.createdAt(model.createdAt);
            this.errorMessage(model.errorMessage);
            this.numberOfRevisions(model.numberOfRevisions);
            this.runId(model.runId);
            this.scanName(model.scanName);
            this.scanNameArn(model.scanNameArn);
            this.scanState(model.scanState);
            this.updatedAt(model.updatedAt);
        }

        public final String getAnalysisType() {
            return this.analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(AnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Long getNumberOfRevisions() {
            return this.numberOfRevisions;
        }

        public final void setNumberOfRevisions(Long numberOfRevisions) {
            this.numberOfRevisions = numberOfRevisions;
        }

        @Override
        public final Builder numberOfRevisions(Long numberOfRevisions) {
            this.numberOfRevisions = numberOfRevisions;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getScanName() {
            return this.scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final String getScanNameArn() {
            return this.scanNameArn;
        }

        public final void setScanNameArn(String scanNameArn) {
            this.scanNameArn = scanNameArn;
        }

        @Override
        public final Builder scanNameArn(String scanNameArn) {
            this.scanNameArn = scanNameArn;
            return this;
        }

        public final String getScanState() {
            return this.scanState;
        }

        public final void setScanState(String scanState) {
            this.scanState = scanState;
        }

        @Override
        public final Builder scanState(String scanState) {
            this.scanState = scanState;
            return this;
        }

        @Override
        public final Builder scanState(ScanState scanState) {
            this.scanState(scanState == null ? null : scanState.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetScanResponse build() {
            return new GetScanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruSecurityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetScanResponse> {
        public Builder analysisType(String var1);

        public Builder analysisType(AnalysisType var1);

        public Builder createdAt(Instant var1);

        public Builder errorMessage(String var1);

        public Builder numberOfRevisions(Long var1);

        public Builder runId(String var1);

        public Builder scanName(String var1);

        public Builder scanNameArn(String var1);

        public Builder scanState(String var1);

        public Builder scanState(ScanState var1);

        public Builder updatedAt(Instant var1);
    }
}

