/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric;
import software.amazon.awssdk.services.codegurusecurity.model.CodeGuruSecurityResponse;
import software.amazon.awssdk.services.codegurusecurity.model.FindingsMetricListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFindingsMetricsResponse
extends CodeGuruSecurityResponse
implements ToCopyableBuilder<Builder, ListFindingsMetricsResponse> {
    private static final SdkField<List<AccountFindingsMetric>> FINDINGS_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingsMetrics").getter(ListFindingsMetricsResponse.getter(ListFindingsMetricsResponse::findingsMetrics)).setter(ListFindingsMetricsResponse.setter(Builder::findingsMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingsMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountFindingsMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFindingsMetricsResponse.getter(ListFindingsMetricsResponse::nextToken)).setter(ListFindingsMetricsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_METRICS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFindingsMetricsResponse.memberNameToFieldInitializer();
    private final List<AccountFindingsMetric> findingsMetrics;
    private final String nextToken;

    private ListFindingsMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.findingsMetrics = builder.findingsMetrics;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFindingsMetrics() {
        return this.findingsMetrics != null && !(this.findingsMetrics instanceof SdkAutoConstructList);
    }

    public final List<AccountFindingsMetric> findingsMetrics() {
        return this.findingsMetrics;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingsMetrics() ? this.findingsMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsMetricsResponse)) {
            return false;
        }
        ListFindingsMetricsResponse other = (ListFindingsMetricsResponse)((Object)obj);
        return this.hasFindingsMetrics() == other.hasFindingsMetrics() && Objects.equals(this.findingsMetrics(), other.findingsMetrics()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFindingsMetricsResponse").add("FindingsMetrics", this.hasFindingsMetrics() ? this.findingsMetrics() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingsMetrics": {
                return Optional.ofNullable(clazz.cast(this.findingsMetrics()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("findingsMetrics", FINDINGS_METRICS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsMetricsResponse, T> g) {
        return obj -> g.apply((ListFindingsMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruSecurityResponse.BuilderImpl
    implements Builder {
        private List<AccountFindingsMetric> findingsMetrics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsMetricsResponse model) {
            super(model);
            this.findingsMetrics(model.findingsMetrics);
            this.nextToken(model.nextToken);
        }

        public final List<AccountFindingsMetric.Builder> getFindingsMetrics() {
            List<AccountFindingsMetric.Builder> result = FindingsMetricListCopier.copyToBuilder(this.findingsMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingsMetrics(Collection<AccountFindingsMetric.BuilderImpl> findingsMetrics) {
            this.findingsMetrics = FindingsMetricListCopier.copyFromBuilder(findingsMetrics);
        }

        @Override
        public final Builder findingsMetrics(Collection<AccountFindingsMetric> findingsMetrics) {
            this.findingsMetrics = FindingsMetricListCopier.copy(findingsMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsMetrics(AccountFindingsMetric ... findingsMetrics) {
            this.findingsMetrics(Arrays.asList(findingsMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsMetrics(Consumer<AccountFindingsMetric.Builder> ... findingsMetrics) {
            this.findingsMetrics(Stream.of(findingsMetrics).map(c -> (AccountFindingsMetric)((AccountFindingsMetric.Builder)AccountFindingsMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFindingsMetricsResponse build() {
            return new ListFindingsMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeGuruSecurityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFindingsMetricsResponse> {
        public Builder findingsMetrics(Collection<AccountFindingsMetric> var1);

        public Builder findingsMetrics(AccountFindingsMetric ... var1);

        public Builder findingsMetrics(Consumer<AccountFindingsMetric.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

