/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerAsyncClient;
import software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse;

public class GetEnrollmentStatusesForOrganizationPublisher
implements SdkPublisher<GetEnrollmentStatusesForOrganizationResponse> {
    private final ComputeOptimizerAsyncClient client;
    private final GetEnrollmentStatusesForOrganizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetEnrollmentStatusesForOrganizationPublisher(ComputeOptimizerAsyncClient client, GetEnrollmentStatusesForOrganizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetEnrollmentStatusesForOrganizationPublisher(ComputeOptimizerAsyncClient client, GetEnrollmentStatusesForOrganizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetEnrollmentStatusesForOrganizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetEnrollmentStatusesForOrganizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountEnrollmentStatus> accountEnrollmentStatuses() {
        Function<GetEnrollmentStatusesForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountEnrollmentStatuses() != null) {
                return response.accountEnrollmentStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetEnrollmentStatusesForOrganizationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetEnrollmentStatusesForOrganizationResponseFetcher
    implements AsyncPageFetcher<GetEnrollmentStatusesForOrganizationResponse> {
        private GetEnrollmentStatusesForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(GetEnrollmentStatusesForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetEnrollmentStatusesForOrganizationResponse> nextPage(GetEnrollmentStatusesForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return GetEnrollmentStatusesForOrganizationPublisher.this.client.getEnrollmentStatusesForOrganization(GetEnrollmentStatusesForOrganizationPublisher.this.firstRequest);
            }
            return GetEnrollmentStatusesForOrganizationPublisher.this.client.getEnrollmentStatusesForOrganization((GetEnrollmentStatusesForOrganizationRequest)((Object)GetEnrollmentStatusesForOrganizationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

