/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportableLicenseField {
    ACCOUNT_ID("AccountId"),
    RESOURCE_ARN("ResourceArn"),
    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),
    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),
    FINDING("Finding"),
    FINDING_REASON_CODES("FindingReasonCodes"),
    CURRENT_LICENSE_CONFIGURATION_NUMBER_OF_CORES("CurrentLicenseConfigurationNumberOfCores"),
    CURRENT_LICENSE_CONFIGURATION_INSTANCE_TYPE("CurrentLicenseConfigurationInstanceType"),
    CURRENT_LICENSE_CONFIGURATION_OPERATING_SYSTEM("CurrentLicenseConfigurationOperatingSystem"),
    CURRENT_LICENSE_CONFIGURATION_LICENSE_NAME("CurrentLicenseConfigurationLicenseName"),
    CURRENT_LICENSE_CONFIGURATION_LICENSE_EDITION("CurrentLicenseConfigurationLicenseEdition"),
    CURRENT_LICENSE_CONFIGURATION_LICENSE_MODEL("CurrentLicenseConfigurationLicenseModel"),
    CURRENT_LICENSE_CONFIGURATION_LICENSE_VERSION("CurrentLicenseConfigurationLicenseVersion"),
    CURRENT_LICENSE_CONFIGURATION_METRICS_SOURCE("CurrentLicenseConfigurationMetricsSource"),
    RECOMMENDATION_OPTIONS_OPERATING_SYSTEM("RecommendationOptionsOperatingSystem"),
    RECOMMENDATION_OPTIONS_LICENSE_EDITION("RecommendationOptionsLicenseEdition"),
    RECOMMENDATION_OPTIONS_LICENSE_MODEL("RecommendationOptionsLicenseModel"),
    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("RecommendationOptionsSavingsOpportunityPercentage"),
    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("RecommendationOptionsEstimatedMonthlySavingsCurrency"),
    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("RecommendationOptionsEstimatedMonthlySavingsValue"),
    TAGS("Tags"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableLicenseField> VALUE_MAP;
    private final String value;

    private ExportableLicenseField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportableLicenseField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportableLicenseField> knownValues() {
        EnumSet<ExportableLicenseField> knownValues = EnumSet.allOf(ExportableLicenseField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportableLicenseField.class, ExportableLicenseField::toString);
    }
}

