/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecommendationPreferenceName {
    ENHANCED_INFRASTRUCTURE_METRICS("EnhancedInfrastructureMetrics"),
    INFERRED_WORKLOAD_TYPES("InferredWorkloadTypes"),
    EXTERNAL_METRICS_PREFERENCE("ExternalMetricsPreference"),
    LOOK_BACK_PERIOD_PREFERENCE("LookBackPeriodPreference"),
    PREFERRED_RESOURCES("PreferredResources"),
    UTILIZATION_PREFERENCES("UtilizationPreferences"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecommendationPreferenceName> VALUE_MAP;
    private final String value;

    private RecommendationPreferenceName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommendationPreferenceName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommendationPreferenceName> knownValues() {
        EnumSet<RecommendationPreferenceName> knownValues = EnumSet.allOf(RecommendationPreferenceName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecommendationPreferenceName.class, RecommendationPreferenceName::toString);
    }
}

