/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEnrollmentStatusResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetEnrollmentStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetEnrollmentStatusResponse.getter(GetEnrollmentStatusResponse::statusAsString)).setter(GetEnrollmentStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetEnrollmentStatusResponse.getter(GetEnrollmentStatusResponse::statusReason)).setter(GetEnrollmentStatusResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Boolean> MEMBER_ACCOUNTS_ENROLLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("memberAccountsEnrolled").getter(GetEnrollmentStatusResponse.getter(GetEnrollmentStatusResponse::memberAccountsEnrolled)).setter(GetEnrollmentStatusResponse.setter(Builder::memberAccountsEnrolled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountsEnrolled").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTimestamp").getter(GetEnrollmentStatusResponse.getter(GetEnrollmentStatusResponse::lastUpdatedTimestamp)).setter(GetEnrollmentStatusResponse.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimestamp").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_MEMBER_ACCOUNTS_OPTED_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfMemberAccountsOptedIn").getter(GetEnrollmentStatusResponse.getter(GetEnrollmentStatusResponse::numberOfMemberAccountsOptedIn)).setter(GetEnrollmentStatusResponse.setter(Builder::numberOfMemberAccountsOptedIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfMemberAccountsOptedIn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STATUS_REASON_FIELD, MEMBER_ACCOUNTS_ENROLLED_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, NUMBER_OF_MEMBER_ACCOUNTS_OPTED_IN_FIELD));
    private final String status;
    private final String statusReason;
    private final Boolean memberAccountsEnrolled;
    private final Instant lastUpdatedTimestamp;
    private final Integer numberOfMemberAccountsOptedIn;

    private GetEnrollmentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.memberAccountsEnrolled = builder.memberAccountsEnrolled;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.numberOfMemberAccountsOptedIn = builder.numberOfMemberAccountsOptedIn;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Boolean memberAccountsEnrolled() {
        return this.memberAccountsEnrolled;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final Integer numberOfMemberAccountsOptedIn() {
        return this.numberOfMemberAccountsOptedIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountsEnrolled());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfMemberAccountsOptedIn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnrollmentStatusResponse)) {
            return false;
        }
        GetEnrollmentStatusResponse other = (GetEnrollmentStatusResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.memberAccountsEnrolled(), other.memberAccountsEnrolled()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.numberOfMemberAccountsOptedIn(), other.numberOfMemberAccountsOptedIn());
    }

    public final String toString() {
        return ToString.builder((String)"GetEnrollmentStatusResponse").add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("MemberAccountsEnrolled", (Object)this.memberAccountsEnrolled()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("NumberOfMemberAccountsOptedIn", (Object)this.numberOfMemberAccountsOptedIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "memberAccountsEnrolled": {
                return Optional.ofNullable(clazz.cast(this.memberAccountsEnrolled()));
            }
            case "lastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "numberOfMemberAccountsOptedIn": {
                return Optional.ofNullable(clazz.cast(this.numberOfMemberAccountsOptedIn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnrollmentStatusResponse, T> g) {
        return obj -> g.apply((GetEnrollmentStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private String status;
        private String statusReason;
        private Boolean memberAccountsEnrolled;
        private Instant lastUpdatedTimestamp;
        private Integer numberOfMemberAccountsOptedIn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnrollmentStatusResponse model) {
            super(model);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.memberAccountsEnrolled(model.memberAccountsEnrolled);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.numberOfMemberAccountsOptedIn(model.numberOfMemberAccountsOptedIn);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Boolean getMemberAccountsEnrolled() {
            return this.memberAccountsEnrolled;
        }

        public final void setMemberAccountsEnrolled(Boolean memberAccountsEnrolled) {
            this.memberAccountsEnrolled = memberAccountsEnrolled;
        }

        @Override
        public final Builder memberAccountsEnrolled(Boolean memberAccountsEnrolled) {
            this.memberAccountsEnrolled = memberAccountsEnrolled;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final Integer getNumberOfMemberAccountsOptedIn() {
            return this.numberOfMemberAccountsOptedIn;
        }

        public final void setNumberOfMemberAccountsOptedIn(Integer numberOfMemberAccountsOptedIn) {
            this.numberOfMemberAccountsOptedIn = numberOfMemberAccountsOptedIn;
        }

        @Override
        public final Builder numberOfMemberAccountsOptedIn(Integer numberOfMemberAccountsOptedIn) {
            this.numberOfMemberAccountsOptedIn = numberOfMemberAccountsOptedIn;
            return this;
        }

        @Override
        public GetEnrollmentStatusResponse build() {
            return new GetEnrollmentStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEnrollmentStatusResponse> {
        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder statusReason(String var1);

        public Builder memberAccountsEnrolled(Boolean var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder numberOfMemberAccountsOptedIn(Integer var1);
    }
}

