/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ECSServiceProjectedUtilizationMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ECSServiceProjectedUtilizationMetric> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ECSServiceProjectedUtilizationMetric.getter(ECSServiceProjectedUtilizationMetric::nameAsString)).setter(ECSServiceProjectedUtilizationMetric.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statistic").getter(ECSServiceProjectedUtilizationMetric.getter(ECSServiceProjectedUtilizationMetric::statisticAsString)).setter(ECSServiceProjectedUtilizationMetric.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistic").build()}).build();
    private static final SdkField<Double> LOWER_BOUND_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("lowerBoundValue").getter(ECSServiceProjectedUtilizationMetric.getter(ECSServiceProjectedUtilizationMetric::lowerBoundValue)).setter(ECSServiceProjectedUtilizationMetric.setter(Builder::lowerBoundValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lowerBoundValue").build()}).build();
    private static final SdkField<Double> UPPER_BOUND_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("upperBoundValue").getter(ECSServiceProjectedUtilizationMetric.getter(ECSServiceProjectedUtilizationMetric::upperBoundValue)).setter(ECSServiceProjectedUtilizationMetric.setter(Builder::upperBoundValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upperBoundValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATISTIC_FIELD, LOWER_BOUND_VALUE_FIELD, UPPER_BOUND_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("statistic", STATISTIC_FIELD);
            this.put("lowerBoundValue", LOWER_BOUND_VALUE_FIELD);
            this.put("upperBoundValue", UPPER_BOUND_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String statistic;
    private final Double lowerBoundValue;
    private final Double upperBoundValue;

    private ECSServiceProjectedUtilizationMetric(BuilderImpl builder) {
        this.name = builder.name;
        this.statistic = builder.statistic;
        this.lowerBoundValue = builder.lowerBoundValue;
        this.upperBoundValue = builder.upperBoundValue;
    }

    public final ECSServiceMetricName name() {
        return ECSServiceMetricName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final ECSServiceMetricStatistic statistic() {
        return ECSServiceMetricStatistic.fromValue(this.statistic);
    }

    public final String statisticAsString() {
        return this.statistic;
    }

    public final Double lowerBoundValue() {
        return this.lowerBoundValue;
    }

    public final Double upperBoundValue() {
        return this.upperBoundValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lowerBoundValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.upperBoundValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSServiceProjectedUtilizationMetric)) {
            return false;
        }
        ECSServiceProjectedUtilizationMetric other = (ECSServiceProjectedUtilizationMetric)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.lowerBoundValue(), other.lowerBoundValue()) && Objects.equals(this.upperBoundValue(), other.upperBoundValue());
    }

    public final String toString() {
        return ToString.builder((String)"ECSServiceProjectedUtilizationMetric").add("Name", (Object)this.nameAsString()).add("Statistic", (Object)this.statisticAsString()).add("LowerBoundValue", (Object)this.lowerBoundValue()).add("UpperBoundValue", (Object)this.upperBoundValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "lowerBoundValue": {
                return Optional.ofNullable(clazz.cast(this.lowerBoundValue()));
            }
            case "upperBoundValue": {
                return Optional.ofNullable(clazz.cast(this.upperBoundValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ECSServiceProjectedUtilizationMetric, T> g) {
        return obj -> g.apply((ECSServiceProjectedUtilizationMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String statistic;
        private Double lowerBoundValue;
        private Double upperBoundValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ECSServiceProjectedUtilizationMetric model) {
            this.name(model.name);
            this.statistic(model.statistic);
            this.lowerBoundValue(model.lowerBoundValue);
            this.upperBoundValue(model.upperBoundValue);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ECSServiceMetricName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(ECSServiceMetricStatistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Double getLowerBoundValue() {
            return this.lowerBoundValue;
        }

        public final void setLowerBoundValue(Double lowerBoundValue) {
            this.lowerBoundValue = lowerBoundValue;
        }

        @Override
        public final Builder lowerBoundValue(Double lowerBoundValue) {
            this.lowerBoundValue = lowerBoundValue;
            return this;
        }

        public final Double getUpperBoundValue() {
            return this.upperBoundValue;
        }

        public final void setUpperBoundValue(Double upperBoundValue) {
            this.upperBoundValue = upperBoundValue;
        }

        @Override
        public final Builder upperBoundValue(Double upperBoundValue) {
            this.upperBoundValue = upperBoundValue;
            return this;
        }

        public ECSServiceProjectedUtilizationMetric build() {
            return new ECSServiceProjectedUtilizationMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ECSServiceProjectedUtilizationMetric> {
        public Builder name(String var1);

        public Builder name(ECSServiceMetricName var1);

        public Builder statistic(String var1);

        public Builder statistic(ECSServiceMetricStatistic var1);

        public Builder lowerBoundValue(Double var1);

        public Builder upperBoundValue(Double var1);
    }
}

