/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendation;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationError;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAutoScalingGroupRecommendationsResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetAutoScalingGroupRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetAutoScalingGroupRecommendationsResponse.getter(GetAutoScalingGroupRecommendationsResponse::nextToken)).setter(GetAutoScalingGroupRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<AutoScalingGroupRecommendation>> AUTO_SCALING_GROUP_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoScalingGroupRecommendations").getter(GetAutoScalingGroupRecommendationsResponse.getter(GetAutoScalingGroupRecommendationsResponse::autoScalingGroupRecommendations)).setter(GetAutoScalingGroupRecommendationsResponse.setter(Builder::autoScalingGroupRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoScalingGroupRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GetRecommendationError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(GetAutoScalingGroupRecommendationsResponse.getter(GetAutoScalingGroupRecommendationsResponse::errors)).setter(GetAutoScalingGroupRecommendationsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetRecommendationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, AUTO_SCALING_GROUP_RECOMMENDATIONS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAutoScalingGroupRecommendationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<AutoScalingGroupRecommendation> autoScalingGroupRecommendations;
    private final List<GetRecommendationError> errors;

    private GetAutoScalingGroupRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.autoScalingGroupRecommendations = builder.autoScalingGroupRecommendations;
        this.errors = builder.errors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAutoScalingGroupRecommendations() {
        return this.autoScalingGroupRecommendations != null && !(this.autoScalingGroupRecommendations instanceof SdkAutoConstructList);
    }

    public final List<AutoScalingGroupRecommendation> autoScalingGroupRecommendations() {
        return this.autoScalingGroupRecommendations;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<GetRecommendationError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingGroupRecommendations() ? this.autoScalingGroupRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoScalingGroupRecommendationsResponse)) {
            return false;
        }
        GetAutoScalingGroupRecommendationsResponse other = (GetAutoScalingGroupRecommendationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAutoScalingGroupRecommendations() == other.hasAutoScalingGroupRecommendations() && Objects.equals(this.autoScalingGroupRecommendations(), other.autoScalingGroupRecommendations()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"GetAutoScalingGroupRecommendationsResponse").add("NextToken", (Object)this.nextToken()).add("AutoScalingGroupRecommendations", this.hasAutoScalingGroupRecommendations() ? this.autoScalingGroupRecommendations() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "autoScalingGroupRecommendations": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupRecommendations()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("autoScalingGroupRecommendations", AUTO_SCALING_GROUP_RECOMMENDATIONS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAutoScalingGroupRecommendationsResponse, T> g) {
        return obj -> g.apply((GetAutoScalingGroupRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AutoScalingGroupRecommendation> autoScalingGroupRecommendations = DefaultSdkAutoConstructList.getInstance();
        private List<GetRecommendationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutoScalingGroupRecommendationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.autoScalingGroupRecommendations(model.autoScalingGroupRecommendations);
            this.errors(model.errors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AutoScalingGroupRecommendation.Builder> getAutoScalingGroupRecommendations() {
            List<AutoScalingGroupRecommendation.Builder> result = AutoScalingGroupRecommendationsCopier.copyToBuilder(this.autoScalingGroupRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoScalingGroupRecommendations(Collection<AutoScalingGroupRecommendation.BuilderImpl> autoScalingGroupRecommendations) {
            this.autoScalingGroupRecommendations = AutoScalingGroupRecommendationsCopier.copyFromBuilder(autoScalingGroupRecommendations);
        }

        @Override
        public final Builder autoScalingGroupRecommendations(Collection<AutoScalingGroupRecommendation> autoScalingGroupRecommendations) {
            this.autoScalingGroupRecommendations = AutoScalingGroupRecommendationsCopier.copy(autoScalingGroupRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupRecommendations(AutoScalingGroupRecommendation ... autoScalingGroupRecommendations) {
            this.autoScalingGroupRecommendations(Arrays.asList(autoScalingGroupRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupRecommendations(Consumer<AutoScalingGroupRecommendation.Builder> ... autoScalingGroupRecommendations) {
            this.autoScalingGroupRecommendations(Stream.of(autoScalingGroupRecommendations).map(c -> (AutoScalingGroupRecommendation)((AutoScalingGroupRecommendation.Builder)AutoScalingGroupRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GetRecommendationError.Builder> getErrors() {
            List<GetRecommendationError.Builder> result = GetRecommendationErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<GetRecommendationError.BuilderImpl> errors) {
            this.errors = GetRecommendationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<GetRecommendationError> errors) {
            this.errors = GetRecommendationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(GetRecommendationError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<GetRecommendationError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (GetRecommendationError)((GetRecommendationError.Builder)GetRecommendationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetAutoScalingGroupRecommendationsResponse build() {
            return new GetAutoScalingGroupRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAutoScalingGroupRecommendationsResponse> {
        public Builder nextToken(String var1);

        public Builder autoScalingGroupRecommendations(Collection<AutoScalingGroupRecommendation> var1);

        public Builder autoScalingGroupRecommendations(AutoScalingGroupRecommendation ... var1);

        public Builder autoScalingGroupRecommendations(Consumer<AutoScalingGroupRecommendation.Builder> ... var1);

        public Builder errors(Collection<GetRecommendationError> var1);

        public Builder errors(GetRecommendationError ... var1);

        public Builder errors(Consumer<GetRecommendationError.Builder> ... var1);
    }
}

