/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseConfiguration;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCode;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseFindingReasonCodesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationOption;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationOptionsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.Tag;
import software.amazon.awssdk.services.computeoptimizer.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseRecommendation> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(LicenseRecommendation.getter(LicenseRecommendation::resourceArn)).setter(LicenseRecommendation.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(LicenseRecommendation.getter(LicenseRecommendation::accountId)).setter(LicenseRecommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<LicenseConfiguration> CURRENT_LICENSE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentLicenseConfiguration").getter(LicenseRecommendation.getter(LicenseRecommendation::currentLicenseConfiguration)).setter(LicenseRecommendation.setter(Builder::currentLicenseConfiguration)).constructor(LicenseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentLicenseConfiguration").build()}).build();
    private static final SdkField<Double> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("lookbackPeriodInDays").getter(LicenseRecommendation.getter(LicenseRecommendation::lookbackPeriodInDays)).setter(LicenseRecommendation.setter(Builder::lookbackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookbackPeriodInDays").build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRefreshTimestamp").getter(LicenseRecommendation.getter(LicenseRecommendation::lastRefreshTimestamp)).setter(LicenseRecommendation.setter(Builder::lastRefreshTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build()}).build();
    private static final SdkField<String> FINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("finding").getter(LicenseRecommendation.getter(LicenseRecommendation::findingAsString)).setter(LicenseRecommendation.setter(Builder::finding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()}).build();
    private static final SdkField<List<String>> FINDING_REASON_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingReasonCodes").getter(LicenseRecommendation.getter(LicenseRecommendation::findingReasonCodesAsStrings)).setter(LicenseRecommendation.setter(Builder::findingReasonCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingReasonCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LicenseRecommendationOption>> LICENSE_RECOMMENDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("licenseRecommendationOptions").getter(LicenseRecommendation.getter(LicenseRecommendation::licenseRecommendationOptions)).setter(LicenseRecommendation.setter(Builder::licenseRecommendationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseRecommendationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseRecommendationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(LicenseRecommendation.getter(LicenseRecommendation::tags)).setter(LicenseRecommendation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, ACCOUNT_ID_FIELD, CURRENT_LICENSE_CONFIGURATION_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD, LAST_REFRESH_TIMESTAMP_FIELD, FINDING_FIELD, FINDING_REASON_CODES_FIELD, LICENSE_RECOMMENDATION_OPTIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LicenseRecommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String accountId;
    private final LicenseConfiguration currentLicenseConfiguration;
    private final Double lookbackPeriodInDays;
    private final Instant lastRefreshTimestamp;
    private final String finding;
    private final List<String> findingReasonCodes;
    private final List<LicenseRecommendationOption> licenseRecommendationOptions;
    private final List<Tag> tags;

    private LicenseRecommendation(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.accountId = builder.accountId;
        this.currentLicenseConfiguration = builder.currentLicenseConfiguration;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
        this.finding = builder.finding;
        this.findingReasonCodes = builder.findingReasonCodes;
        this.licenseRecommendationOptions = builder.licenseRecommendationOptions;
        this.tags = builder.tags;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final LicenseConfiguration currentLicenseConfiguration() {
        return this.currentLicenseConfiguration;
    }

    public final Double lookbackPeriodInDays() {
        return this.lookbackPeriodInDays;
    }

    public final Instant lastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public final LicenseFinding finding() {
        return LicenseFinding.fromValue(this.finding);
    }

    public final String findingAsString() {
        return this.finding;
    }

    public final List<LicenseFindingReasonCode> findingReasonCodes() {
        return LicenseFindingReasonCodesCopier.copyStringToEnum(this.findingReasonCodes);
    }

    public final boolean hasFindingReasonCodes() {
        return this.findingReasonCodes != null && !(this.findingReasonCodes instanceof SdkAutoConstructList);
    }

    public final List<String> findingReasonCodesAsStrings() {
        return this.findingReasonCodes;
    }

    public final boolean hasLicenseRecommendationOptions() {
        return this.licenseRecommendationOptions != null && !(this.licenseRecommendationOptions instanceof SdkAutoConstructList);
    }

    public final List<LicenseRecommendationOption> licenseRecommendationOptions() {
        return this.licenseRecommendationOptions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentLicenseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingReasonCodes() ? this.findingReasonCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseRecommendationOptions() ? this.licenseRecommendationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseRecommendation)) {
            return false;
        }
        LicenseRecommendation other = (LicenseRecommendation)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.currentLicenseConfiguration(), other.currentLicenseConfiguration()) && Objects.equals(this.lookbackPeriodInDays(), other.lookbackPeriodInDays()) && Objects.equals(this.lastRefreshTimestamp(), other.lastRefreshTimestamp()) && Objects.equals(this.findingAsString(), other.findingAsString()) && this.hasFindingReasonCodes() == other.hasFindingReasonCodes() && Objects.equals(this.findingReasonCodesAsStrings(), other.findingReasonCodesAsStrings()) && this.hasLicenseRecommendationOptions() == other.hasLicenseRecommendationOptions() && Objects.equals(this.licenseRecommendationOptions(), other.licenseRecommendationOptions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseRecommendation").add("ResourceArn", (Object)this.resourceArn()).add("AccountId", (Object)this.accountId()).add("CurrentLicenseConfiguration", (Object)this.currentLicenseConfiguration()).add("LookbackPeriodInDays", (Object)this.lookbackPeriodInDays()).add("LastRefreshTimestamp", (Object)this.lastRefreshTimestamp()).add("Finding", (Object)this.findingAsString()).add("FindingReasonCodes", this.hasFindingReasonCodes() ? this.findingReasonCodesAsStrings() : null).add("LicenseRecommendationOptions", this.hasLicenseRecommendationOptions() ? this.licenseRecommendationOptions() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "currentLicenseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.currentLicenseConfiguration()));
            }
            case "lookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInDays()));
            }
            case "lastRefreshTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTimestamp()));
            }
            case "finding": {
                return Optional.ofNullable(clazz.cast(this.findingAsString()));
            }
            case "findingReasonCodes": {
                return Optional.ofNullable(clazz.cast(this.findingReasonCodesAsStrings()));
            }
            case "licenseRecommendationOptions": {
                return Optional.ofNullable(clazz.cast(this.licenseRecommendationOptions()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("currentLicenseConfiguration", CURRENT_LICENSE_CONFIGURATION_FIELD);
        map.put("lookbackPeriodInDays", LOOKBACK_PERIOD_IN_DAYS_FIELD);
        map.put("lastRefreshTimestamp", LAST_REFRESH_TIMESTAMP_FIELD);
        map.put("finding", FINDING_FIELD);
        map.put("findingReasonCodes", FINDING_REASON_CODES_FIELD);
        map.put("licenseRecommendationOptions", LICENSE_RECOMMENDATION_OPTIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseRecommendation, T> g) {
        return obj -> g.apply((LicenseRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String accountId;
        private LicenseConfiguration currentLicenseConfiguration;
        private Double lookbackPeriodInDays;
        private Instant lastRefreshTimestamp;
        private String finding;
        private List<String> findingReasonCodes = DefaultSdkAutoConstructList.getInstance();
        private List<LicenseRecommendationOption> licenseRecommendationOptions = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseRecommendation model) {
            this.resourceArn(model.resourceArn);
            this.accountId(model.accountId);
            this.currentLicenseConfiguration(model.currentLicenseConfiguration);
            this.lookbackPeriodInDays(model.lookbackPeriodInDays);
            this.lastRefreshTimestamp(model.lastRefreshTimestamp);
            this.finding(model.finding);
            this.findingReasonCodesWithStrings(model.findingReasonCodes);
            this.licenseRecommendationOptions(model.licenseRecommendationOptions);
            this.tags(model.tags);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final LicenseConfiguration.Builder getCurrentLicenseConfiguration() {
            return this.currentLicenseConfiguration != null ? this.currentLicenseConfiguration.toBuilder() : null;
        }

        public final void setCurrentLicenseConfiguration(LicenseConfiguration.BuilderImpl currentLicenseConfiguration) {
            this.currentLicenseConfiguration = currentLicenseConfiguration != null ? currentLicenseConfiguration.build() : null;
        }

        @Override
        public final Builder currentLicenseConfiguration(LicenseConfiguration currentLicenseConfiguration) {
            this.currentLicenseConfiguration = currentLicenseConfiguration;
            return this;
        }

        public final Double getLookbackPeriodInDays() {
            return this.lookbackPeriodInDays;
        }

        public final void setLookbackPeriodInDays(Double lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(Double lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        public final Instant getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final String getFinding() {
            return this.finding;
        }

        public final void setFinding(String finding) {
            this.finding = finding;
        }

        @Override
        public final Builder finding(String finding) {
            this.finding = finding;
            return this;
        }

        @Override
        public final Builder finding(LicenseFinding finding) {
            this.finding(finding == null ? null : finding.toString());
            return this;
        }

        public final Collection<String> getFindingReasonCodes() {
            if (this.findingReasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findingReasonCodes;
        }

        public final void setFindingReasonCodes(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = LicenseFindingReasonCodesCopier.copy(findingReasonCodes);
        }

        @Override
        public final Builder findingReasonCodesWithStrings(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = LicenseFindingReasonCodesCopier.copy(findingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingReasonCodesWithStrings(String ... findingReasonCodes) {
            this.findingReasonCodesWithStrings(Arrays.asList(findingReasonCodes));
            return this;
        }

        @Override
        public final Builder findingReasonCodes(Collection<LicenseFindingReasonCode> findingReasonCodes) {
            this.findingReasonCodes = LicenseFindingReasonCodesCopier.copyEnumToString(findingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingReasonCodes(LicenseFindingReasonCode ... findingReasonCodes) {
            this.findingReasonCodes(Arrays.asList(findingReasonCodes));
            return this;
        }

        public final List<LicenseRecommendationOption.Builder> getLicenseRecommendationOptions() {
            List<LicenseRecommendationOption.Builder> result = LicenseRecommendationOptionsCopier.copyToBuilder(this.licenseRecommendationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseRecommendationOptions(Collection<LicenseRecommendationOption.BuilderImpl> licenseRecommendationOptions) {
            this.licenseRecommendationOptions = LicenseRecommendationOptionsCopier.copyFromBuilder(licenseRecommendationOptions);
        }

        @Override
        public final Builder licenseRecommendationOptions(Collection<LicenseRecommendationOption> licenseRecommendationOptions) {
            this.licenseRecommendationOptions = LicenseRecommendationOptionsCopier.copy(licenseRecommendationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseRecommendationOptions(LicenseRecommendationOption ... licenseRecommendationOptions) {
            this.licenseRecommendationOptions(Arrays.asList(licenseRecommendationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseRecommendationOptions(Consumer<LicenseRecommendationOption.Builder> ... licenseRecommendationOptions) {
            this.licenseRecommendationOptions(Stream.of(licenseRecommendationOptions).map(c -> (LicenseRecommendationOption)((LicenseRecommendationOption.Builder)LicenseRecommendationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LicenseRecommendation build() {
            return new LicenseRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseRecommendation> {
        public Builder resourceArn(String var1);

        public Builder accountId(String var1);

        public Builder currentLicenseConfiguration(LicenseConfiguration var1);

        default public Builder currentLicenseConfiguration(Consumer<LicenseConfiguration.Builder> currentLicenseConfiguration) {
            return this.currentLicenseConfiguration((LicenseConfiguration)((LicenseConfiguration.Builder)LicenseConfiguration.builder().applyMutation(currentLicenseConfiguration)).build());
        }

        public Builder lookbackPeriodInDays(Double var1);

        public Builder lastRefreshTimestamp(Instant var1);

        public Builder finding(String var1);

        public Builder finding(LicenseFinding var1);

        public Builder findingReasonCodesWithStrings(Collection<String> var1);

        public Builder findingReasonCodesWithStrings(String ... var1);

        public Builder findingReasonCodes(Collection<LicenseFindingReasonCode> var1);

        public Builder findingReasonCodes(LicenseFindingReasonCode ... var1);

        public Builder licenseRecommendationOptions(Collection<LicenseRecommendationOption> var1);

        public Builder licenseRecommendationOptions(LicenseRecommendationOption ... var1);

        public Builder licenseRecommendationOptions(Consumer<LicenseRecommendationOption.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

