/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.MetricSourceProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricSource> {
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(MetricSource.getter(MetricSource::providerAsString)).setter(MetricSource.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final SdkField<String> PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerArn").getter(MetricSource.getter(MetricSource::providerArn)).setter(MetricSource.setter(Builder::providerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_FIELD, PROVIDER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String provider;
    private final String providerArn;

    private MetricSource(BuilderImpl builder) {
        this.provider = builder.provider;
        this.providerArn = builder.providerArn;
    }

    public final MetricSourceProvider provider() {
        return MetricSourceProvider.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    public final String providerArn() {
        return this.providerArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSource)) {
            return false;
        }
        MetricSource other = (MetricSource)obj;
        return Objects.equals(this.providerAsString(), other.providerAsString()) && Objects.equals(this.providerArn(), other.providerArn());
    }

    public final String toString() {
        return ToString.builder((String)"MetricSource").add("Provider", (Object)this.providerAsString()).add("ProviderArn", (Object)this.providerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
            case "providerArn": {
                return Optional.ofNullable(clazz.cast(this.providerArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("provider", PROVIDER_FIELD);
        map.put("providerArn", PROVIDER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricSource, T> g) {
        return obj -> g.apply((MetricSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String provider;
        private String providerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSource model) {
            this.provider(model.provider);
            this.providerArn(model.providerArn);
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(MetricSourceProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getProviderArn() {
            return this.providerArn;
        }

        public final void setProviderArn(String providerArn) {
            this.providerArn = providerArn;
        }

        @Override
        public final Builder providerArn(String providerArn) {
            this.providerArn = providerArn;
            return this;
        }

        public MetricSource build() {
            return new MetricSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricSource> {
        public Builder provider(String var1);

        public Builder provider(MetricSourceProvider var1);

        public Builder providerArn(String var1);
    }
}

