/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RDSInstanceFinding {
    OPTIMIZED("Optimized"),
    UNDERPROVISIONED("Underprovisioned"),
    OVERPROVISIONED("Overprovisioned"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RDSInstanceFinding> VALUE_MAP;
    private final String value;

    private RDSInstanceFinding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RDSInstanceFinding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RDSInstanceFinding> knownValues() {
        EnumSet<RDSInstanceFinding> knownValues = EnumSet.allOf(RDSInstanceFinding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RDSInstanceFinding.class, RDSInstanceFinding::toString);
    }
}

