/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRiskRatings;
import software.amazon.awssdk.services.computeoptimizer.model.IdleSummariesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.IdleSummary;
import software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadSaving;
import software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadSavingsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType;
import software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity;
import software.amazon.awssdk.services.computeoptimizer.model.SummariesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.Summary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationSummary> {
    private static final SdkField<List<Summary>> SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("summaries").getter(RecommendationSummary.getter(RecommendationSummary::summaries)).setter(RecommendationSummary.setter(Builder::summaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Summary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<IdleSummary>> IDLE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("idleSummaries").getter(RecommendationSummary.getter(RecommendationSummary::idleSummaries)).setter(RecommendationSummary.setter(Builder::idleSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDATION_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationResourceType").getter(RecommendationSummary.getter(RecommendationSummary::recommendationResourceTypeAsString)).setter(RecommendationSummary.setter(Builder::recommendationResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationResourceType").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(RecommendationSummary.getter(RecommendationSummary::accountId)).setter(RecommendationSummary.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunity").getter(RecommendationSummary.getter(RecommendationSummary::savingsOpportunity)).setter(RecommendationSummary.setter(Builder::savingsOpportunity)).constructor(SavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build()}).build();
    private static final SdkField<SavingsOpportunity> IDLE_SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("idleSavingsOpportunity").getter(RecommendationSummary.getter(RecommendationSummary::idleSavingsOpportunity)).setter(RecommendationSummary.setter(Builder::idleSavingsOpportunity)).constructor(SavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSavingsOpportunity").build()}).build();
    private static final SdkField<SavingsOpportunity> AGGREGATED_SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregatedSavingsOpportunity").getter(RecommendationSummary.getter(RecommendationSummary::aggregatedSavingsOpportunity)).setter(RecommendationSummary.setter(Builder::aggregatedSavingsOpportunity)).constructor(SavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedSavingsOpportunity").build()}).build();
    private static final SdkField<CurrentPerformanceRiskRatings> CURRENT_PERFORMANCE_RISK_RATINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentPerformanceRiskRatings").getter(RecommendationSummary.getter(RecommendationSummary::currentPerformanceRiskRatings)).setter(RecommendationSummary.setter(Builder::currentPerformanceRiskRatings)).constructor(CurrentPerformanceRiskRatings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPerformanceRiskRatings").build()}).build();
    private static final SdkField<List<InferredWorkloadSaving>> INFERRED_WORKLOAD_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inferredWorkloadSavings").getter(RecommendationSummary.getter(RecommendationSummary::inferredWorkloadSavings)).setter(RecommendationSummary.setter(Builder::inferredWorkloadSavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredWorkloadSavings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferredWorkloadSaving::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD, IDLE_SUMMARIES_FIELD, RECOMMENDATION_RESOURCE_TYPE_FIELD, ACCOUNT_ID_FIELD, SAVINGS_OPPORTUNITY_FIELD, IDLE_SAVINGS_OPPORTUNITY_FIELD, AGGREGATED_SAVINGS_OPPORTUNITY_FIELD, CURRENT_PERFORMANCE_RISK_RATINGS_FIELD, INFERRED_WORKLOAD_SAVINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecommendationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Summary> summaries;
    private final List<IdleSummary> idleSummaries;
    private final String recommendationResourceType;
    private final String accountId;
    private final SavingsOpportunity savingsOpportunity;
    private final SavingsOpportunity idleSavingsOpportunity;
    private final SavingsOpportunity aggregatedSavingsOpportunity;
    private final CurrentPerformanceRiskRatings currentPerformanceRiskRatings;
    private final List<InferredWorkloadSaving> inferredWorkloadSavings;

    private RecommendationSummary(BuilderImpl builder) {
        this.summaries = builder.summaries;
        this.idleSummaries = builder.idleSummaries;
        this.recommendationResourceType = builder.recommendationResourceType;
        this.accountId = builder.accountId;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.idleSavingsOpportunity = builder.idleSavingsOpportunity;
        this.aggregatedSavingsOpportunity = builder.aggregatedSavingsOpportunity;
        this.currentPerformanceRiskRatings = builder.currentPerformanceRiskRatings;
        this.inferredWorkloadSavings = builder.inferredWorkloadSavings;
    }

    public final boolean hasSummaries() {
        return this.summaries != null && !(this.summaries instanceof SdkAutoConstructList);
    }

    public final List<Summary> summaries() {
        return this.summaries;
    }

    public final boolean hasIdleSummaries() {
        return this.idleSummaries != null && !(this.idleSummaries instanceof SdkAutoConstructList);
    }

    public final List<IdleSummary> idleSummaries() {
        return this.idleSummaries;
    }

    public final RecommendationSourceType recommendationResourceType() {
        return RecommendationSourceType.fromValue(this.recommendationResourceType);
    }

    public final String recommendationResourceTypeAsString() {
        return this.recommendationResourceType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final SavingsOpportunity savingsOpportunity() {
        return this.savingsOpportunity;
    }

    public final SavingsOpportunity idleSavingsOpportunity() {
        return this.idleSavingsOpportunity;
    }

    public final SavingsOpportunity aggregatedSavingsOpportunity() {
        return this.aggregatedSavingsOpportunity;
    }

    public final CurrentPerformanceRiskRatings currentPerformanceRiskRatings() {
        return this.currentPerformanceRiskRatings;
    }

    public final boolean hasInferredWorkloadSavings() {
        return this.inferredWorkloadSavings != null && !(this.inferredWorkloadSavings instanceof SdkAutoConstructList);
    }

    public final List<InferredWorkloadSaving> inferredWorkloadSavings() {
        return this.inferredWorkloadSavings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaries() ? this.summaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdleSummaries() ? this.idleSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSavingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatedSavingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPerformanceRiskRatings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferredWorkloadSavings() ? this.inferredWorkloadSavings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary)obj;
        return this.hasSummaries() == other.hasSummaries() && Objects.equals(this.summaries(), other.summaries()) && this.hasIdleSummaries() == other.hasIdleSummaries() && Objects.equals(this.idleSummaries(), other.idleSummaries()) && Objects.equals(this.recommendationResourceTypeAsString(), other.recommendationResourceTypeAsString()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.savingsOpportunity(), other.savingsOpportunity()) && Objects.equals(this.idleSavingsOpportunity(), other.idleSavingsOpportunity()) && Objects.equals(this.aggregatedSavingsOpportunity(), other.aggregatedSavingsOpportunity()) && Objects.equals(this.currentPerformanceRiskRatings(), other.currentPerformanceRiskRatings()) && this.hasInferredWorkloadSavings() == other.hasInferredWorkloadSavings() && Objects.equals(this.inferredWorkloadSavings(), other.inferredWorkloadSavings());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationSummary").add("Summaries", this.hasSummaries() ? this.summaries() : null).add("IdleSummaries", this.hasIdleSummaries() ? this.idleSummaries() : null).add("RecommendationResourceType", (Object)this.recommendationResourceTypeAsString()).add("AccountId", (Object)this.accountId()).add("SavingsOpportunity", (Object)this.savingsOpportunity()).add("IdleSavingsOpportunity", (Object)this.idleSavingsOpportunity()).add("AggregatedSavingsOpportunity", (Object)this.aggregatedSavingsOpportunity()).add("CurrentPerformanceRiskRatings", (Object)this.currentPerformanceRiskRatings()).add("InferredWorkloadSavings", this.hasInferredWorkloadSavings() ? this.inferredWorkloadSavings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "summaries": {
                return Optional.ofNullable(clazz.cast(this.summaries()));
            }
            case "idleSummaries": {
                return Optional.ofNullable(clazz.cast(this.idleSummaries()));
            }
            case "recommendationResourceType": {
                return Optional.ofNullable(clazz.cast(this.recommendationResourceTypeAsString()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "savingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunity()));
            }
            case "idleSavingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.idleSavingsOpportunity()));
            }
            case "aggregatedSavingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.aggregatedSavingsOpportunity()));
            }
            case "currentPerformanceRiskRatings": {
                return Optional.ofNullable(clazz.cast(this.currentPerformanceRiskRatings()));
            }
            case "inferredWorkloadSavings": {
                return Optional.ofNullable(clazz.cast(this.inferredWorkloadSavings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("summaries", SUMMARIES_FIELD);
        map.put("idleSummaries", IDLE_SUMMARIES_FIELD);
        map.put("recommendationResourceType", RECOMMENDATION_RESOURCE_TYPE_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("savingsOpportunity", SAVINGS_OPPORTUNITY_FIELD);
        map.put("idleSavingsOpportunity", IDLE_SAVINGS_OPPORTUNITY_FIELD);
        map.put("aggregatedSavingsOpportunity", AGGREGATED_SAVINGS_OPPORTUNITY_FIELD);
        map.put("currentPerformanceRiskRatings", CURRENT_PERFORMANCE_RISK_RATINGS_FIELD);
        map.put("inferredWorkloadSavings", INFERRED_WORKLOAD_SAVINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSummary, T> g) {
        return obj -> g.apply((RecommendationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Summary> summaries = DefaultSdkAutoConstructList.getInstance();
        private List<IdleSummary> idleSummaries = DefaultSdkAutoConstructList.getInstance();
        private String recommendationResourceType;
        private String accountId;
        private SavingsOpportunity savingsOpportunity;
        private SavingsOpportunity idleSavingsOpportunity;
        private SavingsOpportunity aggregatedSavingsOpportunity;
        private CurrentPerformanceRiskRatings currentPerformanceRiskRatings;
        private List<InferredWorkloadSaving> inferredWorkloadSavings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSummary model) {
            this.summaries(model.summaries);
            this.idleSummaries(model.idleSummaries);
            this.recommendationResourceType(model.recommendationResourceType);
            this.accountId(model.accountId);
            this.savingsOpportunity(model.savingsOpportunity);
            this.idleSavingsOpportunity(model.idleSavingsOpportunity);
            this.aggregatedSavingsOpportunity(model.aggregatedSavingsOpportunity);
            this.currentPerformanceRiskRatings(model.currentPerformanceRiskRatings);
            this.inferredWorkloadSavings(model.inferredWorkloadSavings);
        }

        public final List<Summary.Builder> getSummaries() {
            List<Summary.Builder> result = SummariesCopier.copyToBuilder(this.summaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaries(Collection<Summary.BuilderImpl> summaries) {
            this.summaries = SummariesCopier.copyFromBuilder(summaries);
        }

        @Override
        public final Builder summaries(Collection<Summary> summaries) {
            this.summaries = SummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Summary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<Summary.Builder> ... summaries) {
            this.summaries(Stream.of(summaries).map(c -> (Summary)((Summary.Builder)Summary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IdleSummary.Builder> getIdleSummaries() {
            List<IdleSummary.Builder> result = IdleSummariesCopier.copyToBuilder(this.idleSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdleSummaries(Collection<IdleSummary.BuilderImpl> idleSummaries) {
            this.idleSummaries = IdleSummariesCopier.copyFromBuilder(idleSummaries);
        }

        @Override
        public final Builder idleSummaries(Collection<IdleSummary> idleSummaries) {
            this.idleSummaries = IdleSummariesCopier.copy(idleSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idleSummaries(IdleSummary ... idleSummaries) {
            this.idleSummaries(Arrays.asList(idleSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idleSummaries(Consumer<IdleSummary.Builder> ... idleSummaries) {
            this.idleSummaries(Stream.of(idleSummaries).map(c -> (IdleSummary)((IdleSummary.Builder)IdleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationResourceType() {
            return this.recommendationResourceType;
        }

        public final void setRecommendationResourceType(String recommendationResourceType) {
            this.recommendationResourceType = recommendationResourceType;
        }

        @Override
        public final Builder recommendationResourceType(String recommendationResourceType) {
            this.recommendationResourceType = recommendationResourceType;
            return this;
        }

        @Override
        public final Builder recommendationResourceType(RecommendationSourceType recommendationResourceType) {
            this.recommendationResourceType(recommendationResourceType == null ? null : recommendationResourceType.toString());
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return this.savingsOpportunity != null ? this.savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final SavingsOpportunity.Builder getIdleSavingsOpportunity() {
            return this.idleSavingsOpportunity != null ? this.idleSavingsOpportunity.toBuilder() : null;
        }

        public final void setIdleSavingsOpportunity(SavingsOpportunity.BuilderImpl idleSavingsOpportunity) {
            this.idleSavingsOpportunity = idleSavingsOpportunity != null ? idleSavingsOpportunity.build() : null;
        }

        @Override
        public final Builder idleSavingsOpportunity(SavingsOpportunity idleSavingsOpportunity) {
            this.idleSavingsOpportunity = idleSavingsOpportunity;
            return this;
        }

        public final SavingsOpportunity.Builder getAggregatedSavingsOpportunity() {
            return this.aggregatedSavingsOpportunity != null ? this.aggregatedSavingsOpportunity.toBuilder() : null;
        }

        public final void setAggregatedSavingsOpportunity(SavingsOpportunity.BuilderImpl aggregatedSavingsOpportunity) {
            this.aggregatedSavingsOpportunity = aggregatedSavingsOpportunity != null ? aggregatedSavingsOpportunity.build() : null;
        }

        @Override
        public final Builder aggregatedSavingsOpportunity(SavingsOpportunity aggregatedSavingsOpportunity) {
            this.aggregatedSavingsOpportunity = aggregatedSavingsOpportunity;
            return this;
        }

        public final CurrentPerformanceRiskRatings.Builder getCurrentPerformanceRiskRatings() {
            return this.currentPerformanceRiskRatings != null ? this.currentPerformanceRiskRatings.toBuilder() : null;
        }

        public final void setCurrentPerformanceRiskRatings(CurrentPerformanceRiskRatings.BuilderImpl currentPerformanceRiskRatings) {
            this.currentPerformanceRiskRatings = currentPerformanceRiskRatings != null ? currentPerformanceRiskRatings.build() : null;
        }

        @Override
        public final Builder currentPerformanceRiskRatings(CurrentPerformanceRiskRatings currentPerformanceRiskRatings) {
            this.currentPerformanceRiskRatings = currentPerformanceRiskRatings;
            return this;
        }

        public final List<InferredWorkloadSaving.Builder> getInferredWorkloadSavings() {
            List<InferredWorkloadSaving.Builder> result = InferredWorkloadSavingsCopier.copyToBuilder(this.inferredWorkloadSavings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferredWorkloadSavings(Collection<InferredWorkloadSaving.BuilderImpl> inferredWorkloadSavings) {
            this.inferredWorkloadSavings = InferredWorkloadSavingsCopier.copyFromBuilder(inferredWorkloadSavings);
        }

        @Override
        public final Builder inferredWorkloadSavings(Collection<InferredWorkloadSaving> inferredWorkloadSavings) {
            this.inferredWorkloadSavings = InferredWorkloadSavingsCopier.copy(inferredWorkloadSavings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferredWorkloadSavings(InferredWorkloadSaving ... inferredWorkloadSavings) {
            this.inferredWorkloadSavings(Arrays.asList(inferredWorkloadSavings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferredWorkloadSavings(Consumer<InferredWorkloadSaving.Builder> ... inferredWorkloadSavings) {
            this.inferredWorkloadSavings(Stream.of(inferredWorkloadSavings).map(c -> (InferredWorkloadSaving)((InferredWorkloadSaving.Builder)InferredWorkloadSaving.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RecommendationSummary build() {
            return new RecommendationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationSummary> {
        public Builder summaries(Collection<Summary> var1);

        public Builder summaries(Summary ... var1);

        public Builder summaries(Consumer<Summary.Builder> ... var1);

        public Builder idleSummaries(Collection<IdleSummary> var1);

        public Builder idleSummaries(IdleSummary ... var1);

        public Builder idleSummaries(Consumer<IdleSummary.Builder> ... var1);

        public Builder recommendationResourceType(String var1);

        public Builder recommendationResourceType(RecommendationSourceType var1);

        public Builder accountId(String var1);

        public Builder savingsOpportunity(SavingsOpportunity var1);

        default public Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return this.savingsOpportunity((SavingsOpportunity)((SavingsOpportunity.Builder)SavingsOpportunity.builder().applyMutation(savingsOpportunity)).build());
        }

        public Builder idleSavingsOpportunity(SavingsOpportunity var1);

        default public Builder idleSavingsOpportunity(Consumer<SavingsOpportunity.Builder> idleSavingsOpportunity) {
            return this.idleSavingsOpportunity((SavingsOpportunity)((SavingsOpportunity.Builder)SavingsOpportunity.builder().applyMutation(idleSavingsOpportunity)).build());
        }

        public Builder aggregatedSavingsOpportunity(SavingsOpportunity var1);

        default public Builder aggregatedSavingsOpportunity(Consumer<SavingsOpportunity.Builder> aggregatedSavingsOpportunity) {
            return this.aggregatedSavingsOpportunity((SavingsOpportunity)((SavingsOpportunity.Builder)SavingsOpportunity.builder().applyMutation(aggregatedSavingsOpportunity)).build());
        }

        public Builder currentPerformanceRiskRatings(CurrentPerformanceRiskRatings var1);

        default public Builder currentPerformanceRiskRatings(Consumer<CurrentPerformanceRiskRatings.Builder> currentPerformanceRiskRatings) {
            return this.currentPerformanceRiskRatings((CurrentPerformanceRiskRatings)((CurrentPerformanceRiskRatings.Builder)CurrentPerformanceRiskRatings.builder().applyMutation(currentPerformanceRiskRatings)).build());
        }

        public Builder inferredWorkloadSavings(Collection<InferredWorkloadSaving> var1);

        public Builder inferredWorkloadSavings(InferredWorkloadSaving ... var1);

        public Builder inferredWorkloadSavings(Consumer<InferredWorkloadSaving.Builder> ... var1);
    }
}

