/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScopeName {
    ORGANIZATION("Organization"),
    ACCOUNT_ID("AccountId"),
    RESOURCE_ARN("ResourceArn"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScopeName> VALUE_MAP;
    private final String value;

    private ScopeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScopeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScopeName> knownValues() {
        EnumSet<ScopeName> knownValues = EnumSet.allOf(ScopeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScopeName.class, ScopeName::toString);
    }
}

