/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters configuration recorders by recording scope.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationRecorderFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationRecorderFilter.Builder, ConfigurationRecorderFilter> {
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterName").getter(getter(ConfigurationRecorderFilter::filterNameAsString))
            .setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()).build();

    private static final SdkField<List<String>> FILTER_VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("filterValue")
            .getter(getter(ConfigurationRecorderFilter::filterValue))
            .setter(setter(Builder::filterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_NAME_FIELD,
            FILTER_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterName;

    private final List<String> filterValue;

    private ConfigurationRecorderFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.filterValue = builder.filterValue;
    }

    /**
     * <p>
     * The name of the type of filter. Currently, only <code>recordingScope</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterName} will
     * return {@link ConfigurationRecorderFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterNameAsString}.
     * </p>
     * 
     * @return The name of the type of filter. Currently, only <code>recordingScope</code> is supported.
     * @see ConfigurationRecorderFilterName
     */
    public final ConfigurationRecorderFilterName filterName() {
        return ConfigurationRecorderFilterName.fromValue(filterName);
    }

    /**
     * <p>
     * The name of the type of filter. Currently, only <code>recordingScope</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterName} will
     * return {@link ConfigurationRecorderFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterNameAsString}.
     * </p>
     * 
     * @return The name of the type of filter. Currently, only <code>recordingScope</code> is supported.
     * @see ConfigurationRecorderFilterName
     */
    public final String filterNameAsString() {
        return filterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterValue property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterValue() {
        return filterValue != null && !(filterValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value of the filter. For <code>recordingScope</code>, valid values include: <code>INTERNAL</code> and
     * <code>PAID</code>.
     * </p>
     * <p>
     * <code>INTERNAL</code> indicates that the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a>
     * in scope for the configuration recorder are recorded for free.
     * </p>
     * <p>
     * <code>PAID</code> indicates that the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a>
     * in scope for the configuration recorder impact the costs to your bill.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterValue} method.
     * </p>
     * 
     * @return The value of the filter. For <code>recordingScope</code>, valid values include: <code>INTERNAL</code> and
     *         <code>PAID</code>.</p>
     *         <p>
     *         <code>INTERNAL</code> indicates that the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
     *         >ConfigurationItems</a> in scope for the configuration recorder are recorded for free.
     *         </p>
     *         <p>
     *         <code>PAID</code> indicates that the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
     *         >ConfigurationItems</a> in scope for the configuration recorder impact the costs to your bill.
     */
    public final List<String> filterValue() {
        return filterValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterValue() ? filterValue() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderFilter)) {
            return false;
        }
        ConfigurationRecorderFilter other = (ConfigurationRecorderFilter) obj;
        return Objects.equals(filterNameAsString(), other.filterNameAsString()) && hasFilterValue() == other.hasFilterValue()
                && Objects.equals(filterValue(), other.filterValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationRecorderFilter").add("FilterName", filterNameAsString())
                .add("FilterValue", hasFilterValue() ? filterValue() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterName":
            return Optional.ofNullable(clazz.cast(filterNameAsString()));
        case "filterValue":
            return Optional.ofNullable(clazz.cast(filterValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filterName", FILTER_NAME_FIELD);
        map.put("filterValue", FILTER_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationRecorderFilter, T> g) {
        return obj -> g.apply((ConfigurationRecorderFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationRecorderFilter> {
        /**
         * <p>
         * The name of the type of filter. Currently, only <code>recordingScope</code> is supported.
         * </p>
         * 
         * @param filterName
         *        The name of the type of filter. Currently, only <code>recordingScope</code> is supported.
         * @see ConfigurationRecorderFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationRecorderFilterName
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * The name of the type of filter. Currently, only <code>recordingScope</code> is supported.
         * </p>
         * 
         * @param filterName
         *        The name of the type of filter. Currently, only <code>recordingScope</code> is supported.
         * @see ConfigurationRecorderFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationRecorderFilterName
         */
        Builder filterName(ConfigurationRecorderFilterName filterName);

        /**
         * <p>
         * The value of the filter. For <code>recordingScope</code>, valid values include: <code>INTERNAL</code> and
         * <code>PAID</code>.
         * </p>
         * <p>
         * <code>INTERNAL</code> indicates that the <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         * >ConfigurationItems</a> in scope for the configuration recorder are recorded for free.
         * </p>
         * <p>
         * <code>PAID</code> indicates that the <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         * >ConfigurationItems</a> in scope for the configuration recorder impact the costs to your bill.
         * </p>
         * 
         * @param filterValue
         *        The value of the filter. For <code>recordingScope</code>, valid values include: <code>INTERNAL</code>
         *        and <code>PAID</code>.</p>
         *        <p>
         *        <code>INTERNAL</code> indicates that the <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         *        >ConfigurationItems</a> in scope for the configuration recorder are recorded for free.
         *        </p>
         *        <p>
         *        <code>PAID</code> indicates that the <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         *        >ConfigurationItems</a> in scope for the configuration recorder impact the costs to your bill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValue(Collection<String> filterValue);

        /**
         * <p>
         * The value of the filter. For <code>recordingScope</code>, valid values include: <code>INTERNAL</code> and
         * <code>PAID</code>.
         * </p>
         * <p>
         * <code>INTERNAL</code> indicates that the <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         * >ConfigurationItems</a> in scope for the configuration recorder are recorded for free.
         * </p>
         * <p>
         * <code>PAID</code> indicates that the <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         * >ConfigurationItems</a> in scope for the configuration recorder impact the costs to your bill.
         * </p>
         * 
         * @param filterValue
         *        The value of the filter. For <code>recordingScope</code>, valid values include: <code>INTERNAL</code>
         *        and <code>PAID</code>.</p>
         *        <p>
         *        <code>INTERNAL</code> indicates that the <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         *        >ConfigurationItems</a> in scope for the configuration recorder are recorded for free.
         *        </p>
         *        <p>
         *        <code>PAID</code> indicates that the <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         *        >ConfigurationItems</a> in scope for the configuration recorder impact the costs to your bill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValue(String... filterValue);
    }

    static final class BuilderImpl implements Builder {
        private String filterName;

        private List<String> filterValue = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderFilter model) {
            filterName(model.filterName);
            filterValue(model.filterValue);
        }

        public final String getFilterName() {
            return filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        @Override
        public final Builder filterName(ConfigurationRecorderFilterName filterName) {
            this.filterName(filterName == null ? null : filterName.toString());
            return this;
        }

        public final Collection<String> getFilterValue() {
            if (filterValue instanceof SdkAutoConstructList) {
                return null;
            }
            return filterValue;
        }

        public final void setFilterValue(Collection<String> filterValue) {
            this.filterValue = ConfigurationRecorderFilterValuesCopier.copy(filterValue);
        }

        @Override
        public final Builder filterValue(Collection<String> filterValue) {
            this.filterValue = ConfigurationRecorderFilterValuesCopier.copy(filterValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterValue(String... filterValue) {
            filterValue(Arrays.asList(filterValue));
            return this;
        }

        @Override
        public ConfigurationRecorderFilter build() {
            return new ConfigurationRecorderFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
