/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A compliance score is the percentage of the number of compliant rule-resource combinations in a conformance pack
 * compared to the number of total possible rule-resource combinations in the conformance pack. This metric provides you
 * with a high-level view of the compliance state of your conformance packs. You can use it to identify, investigate,
 * and understand the level of compliance in your conformance packs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConformancePackComplianceScore implements SdkPojo, Serializable,
        ToCopyableBuilder<ConformancePackComplianceScore.Builder, ConformancePackComplianceScore> {
    private static final SdkField<String> SCORE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Score")
            .getter(getter(ConformancePackComplianceScore::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackName").getter(getter(ConformancePackComplianceScore::conformancePackName))
            .setter(setter(Builder::conformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(ConformancePackComplianceScore::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCORE_FIELD,
            CONFORMANCE_PACK_NAME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String score;

    private final String conformancePackName;

    private final Instant lastUpdatedTime;

    private ConformancePackComplianceScore(BuilderImpl builder) {
        this.score = builder.score;
        this.conformancePackName = builder.conformancePackName;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * Compliance score for the conformance pack. Conformance packs with no evaluation results will have a compliance
     * score of <code>INSUFFICIENT_DATA</code>.
     * </p>
     * 
     * @return Compliance score for the conformance pack. Conformance packs with no evaluation results will have a
     *         compliance score of <code>INSUFFICIENT_DATA</code>.
     */
    public final String score() {
        return score;
    }

    /**
     * <p>
     * The name of the conformance pack.
     * </p>
     * 
     * @return The name of the conformance pack.
     */
    public final String conformancePackName() {
        return conformancePackName;
    }

    /**
     * <p>
     * The time that the conformance pack compliance score was last updated.
     * </p>
     * 
     * @return The time that the conformance pack compliance score was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackComplianceScore)) {
            return false;
        }
        ConformancePackComplianceScore other = (ConformancePackComplianceScore) obj;
        return Objects.equals(score(), other.score()) && Objects.equals(conformancePackName(), other.conformancePackName())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConformancePackComplianceScore").add("Score", score())
                .add("ConformancePackName", conformancePackName()).add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "ConformancePackName":
            return Optional.ofNullable(clazz.cast(conformancePackName()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Score", SCORE_FIELD);
        map.put("ConformancePackName", CONFORMANCE_PACK_NAME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackComplianceScore, T> g) {
        return obj -> g.apply((ConformancePackComplianceScore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConformancePackComplianceScore> {
        /**
         * <p>
         * Compliance score for the conformance pack. Conformance packs with no evaluation results will have a
         * compliance score of <code>INSUFFICIENT_DATA</code>.
         * </p>
         * 
         * @param score
         *        Compliance score for the conformance pack. Conformance packs with no evaluation results will have a
         *        compliance score of <code>INSUFFICIENT_DATA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(String score);

        /**
         * <p>
         * The name of the conformance pack.
         * </p>
         * 
         * @param conformancePackName
         *        The name of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackName(String conformancePackName);

        /**
         * <p>
         * The time that the conformance pack compliance score was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time that the conformance pack compliance score was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String score;

        private String conformancePackName;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackComplianceScore model) {
            score(model.score);
            conformancePackName(model.conformancePackName);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getScore() {
            return score;
        }

        public final void setScore(String score) {
            this.score = score;
        }

        @Override
        public final Builder score(String score) {
            this.score = score;
            return this;
        }

        public final String getConformancePackName() {
            return conformancePackName;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public ConformancePackComplianceScore build() {
            return new ConformancePackComplianceScore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
