/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRetentionConfigurationRequest extends ConfigRequest implements
        ToCopyableBuilder<DeleteRetentionConfigurationRequest.Builder, DeleteRetentionConfigurationRequest> {
    private static final SdkField<String> RETENTION_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RetentionConfigurationName")
            .getter(getter(DeleteRetentionConfigurationRequest::retentionConfigurationName))
            .setter(setter(Builder::retentionConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionConfigurationName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RETENTION_CONFIGURATION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String retentionConfigurationName;

    private DeleteRetentionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.retentionConfigurationName = builder.retentionConfigurationName;
    }

    /**
     * <p>
     * The name of the retention configuration to delete.
     * </p>
     * 
     * @return The name of the retention configuration to delete.
     */
    public final String retentionConfigurationName() {
        return retentionConfigurationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(retentionConfigurationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRetentionConfigurationRequest)) {
            return false;
        }
        DeleteRetentionConfigurationRequest other = (DeleteRetentionConfigurationRequest) obj;
        return Objects.equals(retentionConfigurationName(), other.retentionConfigurationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRetentionConfigurationRequest")
                .add("RetentionConfigurationName", retentionConfigurationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionConfigurationName":
            return Optional.ofNullable(clazz.cast(retentionConfigurationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RetentionConfigurationName", RETENTION_CONFIGURATION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRetentionConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteRetentionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRetentionConfigurationRequest> {
        /**
         * <p>
         * The name of the retention configuration to delete.
         * </p>
         * 
         * @param retentionConfigurationName
         *        The name of the retention configuration to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionConfigurationName(String retentionConfigurationName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String retentionConfigurationName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRetentionConfigurationRequest model) {
            super(model);
            retentionConfigurationName(model.retentionConfigurationName);
        }

        public final String getRetentionConfigurationName() {
            return retentionConfigurationName;
        }

        public final void setRetentionConfigurationName(String retentionConfigurationName) {
            this.retentionConfigurationName = retentionConfigurationName;
        }

        @Override
        public final Builder retentionConfigurationName(String retentionConfigurationName) {
            this.retentionConfigurationName = retentionConfigurationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRetentionConfigurationRequest build() {
            return new DeleteRetentionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
