/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComplianceByResourceResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeComplianceByResourceResponse.Builder, DescribeComplianceByResourceResponse> {
    private static final SdkField<List<ComplianceByResource>> COMPLIANCE_BY_RESOURCES_FIELD = SdkField
            .<List<ComplianceByResource>> builder(MarshallingType.LIST)
            .memberName("ComplianceByResources")
            .getter(getter(DescribeComplianceByResourceResponse::complianceByResources))
            .setter(setter(Builder::complianceByResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceByResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComplianceByResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComplianceByResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeComplianceByResourceResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_BY_RESOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ComplianceByResource> complianceByResources;

    private final String nextToken;

    private DescribeComplianceByResourceResponse(BuilderImpl builder) {
        super(builder);
        this.complianceByResources = builder.complianceByResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComplianceByResources property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComplianceByResources() {
        return complianceByResources != null && !(complianceByResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resource complies with all of the Config rules that evaluate
     * it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComplianceByResources} method.
     * </p>
     * 
     * @return Indicates whether the specified Amazon Web Services resource complies with all of the Config rules that
     *         evaluate it.
     */
    public final List<ComplianceByResource> complianceByResources() {
        return complianceByResources;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasComplianceByResources() ? complianceByResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByResourceResponse)) {
            return false;
        }
        DescribeComplianceByResourceResponse other = (DescribeComplianceByResourceResponse) obj;
        return hasComplianceByResources() == other.hasComplianceByResources()
                && Objects.equals(complianceByResources(), other.complianceByResources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeComplianceByResourceResponse")
                .add("ComplianceByResources", hasComplianceByResources() ? complianceByResources() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceByResources":
            return Optional.ofNullable(clazz.cast(complianceByResources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComplianceByResources", COMPLIANCE_BY_RESOURCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComplianceByResourceResponse, T> g) {
        return obj -> g.apply((DescribeComplianceByResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComplianceByResourceResponse> {
        /**
         * <p>
         * Indicates whether the specified Amazon Web Services resource complies with all of the Config rules that
         * evaluate it.
         * </p>
         * 
         * @param complianceByResources
         *        Indicates whether the specified Amazon Web Services resource complies with all of the Config rules
         *        that evaluate it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceByResources(Collection<ComplianceByResource> complianceByResources);

        /**
         * <p>
         * Indicates whether the specified Amazon Web Services resource complies with all of the Config rules that
         * evaluate it.
         * </p>
         * 
         * @param complianceByResources
         *        Indicates whether the specified Amazon Web Services resource complies with all of the Config rules
         *        that evaluate it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceByResources(ComplianceByResource... complianceByResources);

        /**
         * <p>
         * Indicates whether the specified Amazon Web Services resource complies with all of the Config rules that
         * evaluate it.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.ComplianceByResource.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.config.model.ComplianceByResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.ComplianceByResource.Builder#build()} is called
         * immediately and its result is passed to {@link #complianceByResources(List<ComplianceByResource>)}.
         * 
         * @param complianceByResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.ComplianceByResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceByResources(java.util.Collection<ComplianceByResource>)
         */
        Builder complianceByResources(Consumer<ComplianceByResource.Builder>... complianceByResources);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ComplianceByResource> complianceByResources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByResourceResponse model) {
            super(model);
            complianceByResources(model.complianceByResources);
            nextToken(model.nextToken);
        }

        public final List<ComplianceByResource.Builder> getComplianceByResources() {
            List<ComplianceByResource.Builder> result = ComplianceByResourcesCopier.copyToBuilder(this.complianceByResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComplianceByResources(Collection<ComplianceByResource.BuilderImpl> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copyFromBuilder(complianceByResources);
        }

        @Override
        public final Builder complianceByResources(Collection<ComplianceByResource> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copy(complianceByResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByResources(ComplianceByResource... complianceByResources) {
            complianceByResources(Arrays.asList(complianceByResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByResources(Consumer<ComplianceByResource.Builder>... complianceByResources) {
            complianceByResources(Stream.of(complianceByResources)
                    .map(c -> ComplianceByResource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeComplianceByResourceResponse build() {
            return new DescribeComplianceByResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
