/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateResourceTypesResponse extends ConfigResponse implements
        ToCopyableBuilder<DisassociateResourceTypesResponse.Builder, DisassociateResourceTypesResponse> {
    private static final SdkField<ConfigurationRecorder> CONFIGURATION_RECORDER_FIELD = SdkField
            .<ConfigurationRecorder> builder(MarshallingType.SDK_POJO).memberName("ConfigurationRecorder")
            .getter(getter(DisassociateResourceTypesResponse::configurationRecorder))
            .setter(setter(Builder::configurationRecorder)).constructor(ConfigurationRecorder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRecorder").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_RECORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConfigurationRecorder configurationRecorder;

    private DisassociateResourceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.configurationRecorder = builder.configurationRecorder;
    }

    /**
     * Returns the value of the ConfigurationRecorder property for this object.
     * 
     * @return The value of the ConfigurationRecorder property for this object.
     */
    public final ConfigurationRecorder configurationRecorder() {
        return configurationRecorder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationRecorder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResourceTypesResponse)) {
            return false;
        }
        DisassociateResourceTypesResponse other = (DisassociateResourceTypesResponse) obj;
        return Objects.equals(configurationRecorder(), other.configurationRecorder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateResourceTypesResponse").add("ConfigurationRecorder", configurationRecorder())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorder":
            return Optional.ofNullable(clazz.cast(configurationRecorder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationRecorder", CONFIGURATION_RECORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResourceTypesResponse, T> g) {
        return obj -> g.apply((DisassociateResourceTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateResourceTypesResponse> {
        /**
         * Sets the value of the ConfigurationRecorder property for this object.
         *
         * @param configurationRecorder
         *        The new value for the ConfigurationRecorder property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorder(ConfigurationRecorder configurationRecorder);

        /**
         * Sets the value of the ConfigurationRecorder property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConfigurationRecorder.Builder} avoiding
         * the need to create one manually via {@link ConfigurationRecorder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationRecorder.Builder#build()} is called immediately and
         * its result is passed to {@link #configurationRecorder(ConfigurationRecorder)}.
         * 
         * @param configurationRecorder
         *        a consumer that will call methods on {@link ConfigurationRecorder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationRecorder(ConfigurationRecorder)
         */
        default Builder configurationRecorder(Consumer<ConfigurationRecorder.Builder> configurationRecorder) {
            return configurationRecorder(ConfigurationRecorder.builder().applyMutation(configurationRecorder).build());
        }
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private ConfigurationRecorder configurationRecorder;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResourceTypesResponse model) {
            super(model);
            configurationRecorder(model.configurationRecorder);
        }

        public final ConfigurationRecorder.Builder getConfigurationRecorder() {
            return configurationRecorder != null ? configurationRecorder.toBuilder() : null;
        }

        public final void setConfigurationRecorder(ConfigurationRecorder.BuilderImpl configurationRecorder) {
            this.configurationRecorder = configurationRecorder != null ? configurationRecorder.build() : null;
        }

        @Override
        public final Builder configurationRecorder(ConfigurationRecorder configurationRecorder) {
            this.configurationRecorder = configurationRecorder;
            return this;
        }

        @Override
        public DisassociateResourceTypesResponse build() {
            return new DisassociateResourceTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
