/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Uniquely identifies an evaluation result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationResultIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationResultIdentifier.Builder, EvaluationResultIdentifier> {
    private static final SdkField<EvaluationResultQualifier> EVALUATION_RESULT_QUALIFIER_FIELD = SdkField
            .<EvaluationResultQualifier> builder(MarshallingType.SDK_POJO).memberName("EvaluationResultQualifier")
            .getter(getter(EvaluationResultIdentifier::evaluationResultQualifier))
            .setter(setter(Builder::evaluationResultQualifier)).constructor(EvaluationResultQualifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResultQualifier").build())
            .build();

    private static final SdkField<Instant> ORDERING_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OrderingTimestamp").getter(getter(EvaluationResultIdentifier::orderingTimestamp))
            .setter(setter(Builder::orderingTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingTimestamp").build()).build();

    private static final SdkField<String> RESOURCE_EVALUATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceEvaluationId").getter(getter(EvaluationResultIdentifier::resourceEvaluationId))
            .setter(setter(Builder::resourceEvaluationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEvaluationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EVALUATION_RESULT_QUALIFIER_FIELD, ORDERING_TIMESTAMP_FIELD, RESOURCE_EVALUATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationResultQualifier evaluationResultQualifier;

    private final Instant orderingTimestamp;

    private final String resourceEvaluationId;

    private EvaluationResultIdentifier(BuilderImpl builder) {
        this.evaluationResultQualifier = builder.evaluationResultQualifier;
        this.orderingTimestamp = builder.orderingTimestamp;
        this.resourceEvaluationId = builder.resourceEvaluationId;
    }

    /**
     * <p>
     * Identifies an Config rule used to evaluate an Amazon Web Services resource, and provides the type and ID of the
     * evaluated resource.
     * </p>
     * 
     * @return Identifies an Config rule used to evaluate an Amazon Web Services resource, and provides the type and ID
     *         of the evaluated resource.
     */
    public final EvaluationResultQualifier evaluationResultQualifier() {
        return evaluationResultQualifier;
    }

    /**
     * <p>
     * The time of the event that triggered the evaluation of your Amazon Web Services resources. The time can indicate
     * when Config delivered a configuration item change notification, or it can indicate when Config delivered the
     * configuration snapshot, depending on which event triggered the evaluation.
     * </p>
     * 
     * @return The time of the event that triggered the evaluation of your Amazon Web Services resources. The time can
     *         indicate when Config delivered a configuration item change notification, or it can indicate when Config
     *         delivered the configuration snapshot, depending on which event triggered the evaluation.
     */
    public final Instant orderingTimestamp() {
        return orderingTimestamp;
    }

    /**
     * <p>
     * A Unique ID for an evaluation result.
     * </p>
     * 
     * @return A Unique ID for an evaluation result.
     */
    public final String resourceEvaluationId() {
        return resourceEvaluationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResultQualifier());
        hashCode = 31 * hashCode + Objects.hashCode(orderingTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(resourceEvaluationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResultIdentifier)) {
            return false;
        }
        EvaluationResultIdentifier other = (EvaluationResultIdentifier) obj;
        return Objects.equals(evaluationResultQualifier(), other.evaluationResultQualifier())
                && Objects.equals(orderingTimestamp(), other.orderingTimestamp())
                && Objects.equals(resourceEvaluationId(), other.resourceEvaluationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationResultIdentifier").add("EvaluationResultQualifier", evaluationResultQualifier())
                .add("OrderingTimestamp", orderingTimestamp()).add("ResourceEvaluationId", resourceEvaluationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationResultQualifier":
            return Optional.ofNullable(clazz.cast(evaluationResultQualifier()));
        case "OrderingTimestamp":
            return Optional.ofNullable(clazz.cast(orderingTimestamp()));
        case "ResourceEvaluationId":
            return Optional.ofNullable(clazz.cast(resourceEvaluationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EvaluationResultQualifier", EVALUATION_RESULT_QUALIFIER_FIELD);
        map.put("OrderingTimestamp", ORDERING_TIMESTAMP_FIELD);
        map.put("ResourceEvaluationId", RESOURCE_EVALUATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationResultIdentifier, T> g) {
        return obj -> g.apply((EvaluationResultIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationResultIdentifier> {
        /**
         * <p>
         * Identifies an Config rule used to evaluate an Amazon Web Services resource, and provides the type and ID of
         * the evaluated resource.
         * </p>
         * 
         * @param evaluationResultQualifier
         *        Identifies an Config rule used to evaluate an Amazon Web Services resource, and provides the type and
         *        ID of the evaluated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResultQualifier(EvaluationResultQualifier evaluationResultQualifier);

        /**
         * <p>
         * Identifies an Config rule used to evaluate an Amazon Web Services resource, and provides the type and ID of
         * the evaluated resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationResultQualifier.Builder}
         * avoiding the need to create one manually via {@link EvaluationResultQualifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationResultQualifier.Builder#build()} is called immediately
         * and its result is passed to {@link #evaluationResultQualifier(EvaluationResultQualifier)}.
         * 
         * @param evaluationResultQualifier
         *        a consumer that will call methods on {@link EvaluationResultQualifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationResultQualifier(EvaluationResultQualifier)
         */
        default Builder evaluationResultQualifier(Consumer<EvaluationResultQualifier.Builder> evaluationResultQualifier) {
            return evaluationResultQualifier(EvaluationResultQualifier.builder().applyMutation(evaluationResultQualifier).build());
        }

        /**
         * <p>
         * The time of the event that triggered the evaluation of your Amazon Web Services resources. The time can
         * indicate when Config delivered a configuration item change notification, or it can indicate when Config
         * delivered the configuration snapshot, depending on which event triggered the evaluation.
         * </p>
         * 
         * @param orderingTimestamp
         *        The time of the event that triggered the evaluation of your Amazon Web Services resources. The time
         *        can indicate when Config delivered a configuration item change notification, or it can indicate when
         *        Config delivered the configuration snapshot, depending on which event triggered the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingTimestamp(Instant orderingTimestamp);

        /**
         * <p>
         * A Unique ID for an evaluation result.
         * </p>
         * 
         * @param resourceEvaluationId
         *        A Unique ID for an evaluation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEvaluationId(String resourceEvaluationId);
    }

    static final class BuilderImpl implements Builder {
        private EvaluationResultQualifier evaluationResultQualifier;

        private Instant orderingTimestamp;

        private String resourceEvaluationId;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResultIdentifier model) {
            evaluationResultQualifier(model.evaluationResultQualifier);
            orderingTimestamp(model.orderingTimestamp);
            resourceEvaluationId(model.resourceEvaluationId);
        }

        public final EvaluationResultQualifier.Builder getEvaluationResultQualifier() {
            return evaluationResultQualifier != null ? evaluationResultQualifier.toBuilder() : null;
        }

        public final void setEvaluationResultQualifier(EvaluationResultQualifier.BuilderImpl evaluationResultQualifier) {
            this.evaluationResultQualifier = evaluationResultQualifier != null ? evaluationResultQualifier.build() : null;
        }

        @Override
        public final Builder evaluationResultQualifier(EvaluationResultQualifier evaluationResultQualifier) {
            this.evaluationResultQualifier = evaluationResultQualifier;
            return this;
        }

        public final Instant getOrderingTimestamp() {
            return orderingTimestamp;
        }

        public final void setOrderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
        }

        @Override
        public final Builder orderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
            return this;
        }

        public final String getResourceEvaluationId() {
            return resourceEvaluationId;
        }

        public final void setResourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
        }

        @Override
        public final Builder resourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
            return this;
        }

        @Override
        public EvaluationResultIdentifier build() {
            return new EvaluationResultIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
