/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The count of resources that are grouped by the group name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupedResourceCount implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupedResourceCount.Builder, GroupedResourceCount> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(GroupedResourceCount::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<Long> RESOURCE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ResourceCount").getter(getter(GroupedResourceCount::resourceCount))
            .setter(setter(Builder::resourceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            RESOURCE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final Long resourceCount;

    private GroupedResourceCount(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.resourceCount = builder.resourceCount;
    }

    /**
     * <p>
     * The name of the group that can be region, account ID, or resource type. For example, region1, region2 if the
     * region was chosen as <code>GroupByKey</code>.
     * </p>
     * 
     * @return The name of the group that can be region, account ID, or resource type. For example, region1, region2 if
     *         the region was chosen as <code>GroupByKey</code>.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The number of resources in the group.
     * </p>
     * 
     * @return The number of resources in the group.
     */
    public final Long resourceCount() {
        return resourceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupedResourceCount)) {
            return false;
        }
        GroupedResourceCount other = (GroupedResourceCount) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(resourceCount(), other.resourceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupedResourceCount").add("GroupName", groupName()).add("ResourceCount", resourceCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "ResourceCount":
            return Optional.ofNullable(clazz.cast(resourceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("ResourceCount", RESOURCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupedResourceCount, T> g) {
        return obj -> g.apply((GroupedResourceCount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupedResourceCount> {
        /**
         * <p>
         * The name of the group that can be region, account ID, or resource type. For example, region1, region2 if the
         * region was chosen as <code>GroupByKey</code>.
         * </p>
         * 
         * @param groupName
         *        The name of the group that can be region, account ID, or resource type. For example, region1, region2
         *        if the region was chosen as <code>GroupByKey</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The number of resources in the group.
         * </p>
         * 
         * @param resourceCount
         *        The number of resources in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCount(Long resourceCount);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private Long resourceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupedResourceCount model) {
            groupName(model.groupName);
            resourceCount(model.resourceCount);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final Long getResourceCount() {
            return resourceCount;
        }

        public final void setResourceCount(Long resourceCount) {
            this.resourceCount = resourceCount;
        }

        @Override
        public final Builder resourceCount(Long resourceCount) {
            this.resourceCount = resourceCount;
            return this;
        }

        @Override
        public GroupedResourceCount build() {
            return new GroupedResourceCount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
