/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the resource being evaluated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDetails implements SdkPojo, Serializable, ToCopyableBuilder<ResourceDetails.Builder, ResourceDetails> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ResourceDetails::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ResourceDetails::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceConfiguration").getter(getter(ResourceDetails::resourceConfiguration))
            .setter(setter(Builder::resourceConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfiguration").build())
            .build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_SCHEMA_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceConfigurationSchemaType")
            .getter(getter(ResourceDetails::resourceConfigurationSchemaTypeAsString))
            .setter(setter(Builder::resourceConfigurationSchemaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfigurationSchemaType")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_CONFIGURATION_FIELD, RESOURCE_CONFIGURATION_SCHEMA_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String resourceType;

    private final String resourceConfiguration;

    private final String resourceConfigurationSchemaType;

    private ResourceDetails(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceConfiguration = builder.resourceConfiguration;
        this.resourceConfigurationSchemaType = builder.resourceConfigurationSchemaType;
    }

    /**
     * <p>
     * A unique resource ID for an evaluation.
     * </p>
     * 
     * @return A unique resource ID for an evaluation.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of resource being evaluated.
     * </p>
     * 
     * @return The type of resource being evaluated.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The resource definition to be evaluated as per the resource configuration schema type.
     * </p>
     * 
     * @return The resource definition to be evaluated as per the resource configuration schema type.
     */
    public final String resourceConfiguration() {
        return resourceConfiguration;
    }

    /**
     * <p>
     * The schema type of the resource configuration.
     * </p>
     * <note>
     * <p>
     * You can find the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource type
     * schema</a>, or <code>CFN_RESOURCE_SCHEMA</code>, in "<i>Amazon Web Services public extensions</i>" within the
     * CloudFormation registry or with the following CLI commmand:
     * <code>aws cloudformation describe-type --type-name "AWS::S3::Bucket" --type RESOURCE</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-view">Managing
     * extensions through the CloudFormation registry</a> and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon
     * Web Services resource and property types reference</a> in the CloudFormation User Guide.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceConfigurationSchemaType} will return
     * {@link ResourceConfigurationSchemaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceConfigurationSchemaTypeAsString}.
     * </p>
     * 
     * @return The schema type of the resource configuration.</p> <note>
     *         <p>
     *         You can find the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource
     *         type schema</a>, or <code>CFN_RESOURCE_SCHEMA</code>, in "<i>Amazon Web Services public extensions</i>"
     *         within the CloudFormation registry or with the following CLI commmand:
     *         <code>aws cloudformation describe-type --type-name "AWS::S3::Bucket" --type RESOURCE</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-view"
     *         >Managing extensions through the CloudFormation registry</a> and <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >Amazon Web Services resource and property types reference</a> in the CloudFormation User Guide.
     *         </p>
     * @see ResourceConfigurationSchemaType
     */
    public final ResourceConfigurationSchemaType resourceConfigurationSchemaType() {
        return ResourceConfigurationSchemaType.fromValue(resourceConfigurationSchemaType);
    }

    /**
     * <p>
     * The schema type of the resource configuration.
     * </p>
     * <note>
     * <p>
     * You can find the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource type
     * schema</a>, or <code>CFN_RESOURCE_SCHEMA</code>, in "<i>Amazon Web Services public extensions</i>" within the
     * CloudFormation registry or with the following CLI commmand:
     * <code>aws cloudformation describe-type --type-name "AWS::S3::Bucket" --type RESOURCE</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-view">Managing
     * extensions through the CloudFormation registry</a> and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon
     * Web Services resource and property types reference</a> in the CloudFormation User Guide.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceConfigurationSchemaType} will return
     * {@link ResourceConfigurationSchemaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceConfigurationSchemaTypeAsString}.
     * </p>
     * 
     * @return The schema type of the resource configuration.</p> <note>
     *         <p>
     *         You can find the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource
     *         type schema</a>, or <code>CFN_RESOURCE_SCHEMA</code>, in "<i>Amazon Web Services public extensions</i>"
     *         within the CloudFormation registry or with the following CLI commmand:
     *         <code>aws cloudformation describe-type --type-name "AWS::S3::Bucket" --type RESOURCE</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-view"
     *         >Managing extensions through the CloudFormation registry</a> and <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >Amazon Web Services resource and property types reference</a> in the CloudFormation User Guide.
     *         </p>
     * @see ResourceConfigurationSchemaType
     */
    public final String resourceConfigurationSchemaTypeAsString() {
        return resourceConfigurationSchemaType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationSchemaTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(resourceConfiguration(), other.resourceConfiguration())
                && Objects.equals(resourceConfigurationSchemaTypeAsString(), other.resourceConfigurationSchemaTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceDetails").add("ResourceId", resourceId()).add("ResourceType", resourceType())
                .add("ResourceConfiguration", resourceConfiguration())
                .add("ResourceConfigurationSchemaType", resourceConfigurationSchemaTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceConfiguration":
            return Optional.ofNullable(clazz.cast(resourceConfiguration()));
        case "ResourceConfigurationSchemaType":
            return Optional.ofNullable(clazz.cast(resourceConfigurationSchemaTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceConfiguration", RESOURCE_CONFIGURATION_FIELD);
        map.put("ResourceConfigurationSchemaType", RESOURCE_CONFIGURATION_SCHEMA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDetails> {
        /**
         * <p>
         * A unique resource ID for an evaluation.
         * </p>
         * 
         * @param resourceId
         *        A unique resource ID for an evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of resource being evaluated.
         * </p>
         * 
         * @param resourceType
         *        The type of resource being evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource definition to be evaluated as per the resource configuration schema type.
         * </p>
         * 
         * @param resourceConfiguration
         *        The resource definition to be evaluated as per the resource configuration schema type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfiguration(String resourceConfiguration);

        /**
         * <p>
         * The schema type of the resource configuration.
         * </p>
         * <note>
         * <p>
         * You can find the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource
         * type schema</a>, or <code>CFN_RESOURCE_SCHEMA</code>, in "<i>Amazon Web Services public extensions</i>"
         * within the CloudFormation registry or with the following CLI commmand:
         * <code>aws cloudformation describe-type --type-name "AWS::S3::Bucket" --type RESOURCE</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-view">Managing
         * extensions through the CloudFormation registry</a> and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >Amazon Web Services resource and property types reference</a> in the CloudFormation User Guide.
         * </p>
         * </note>
         * 
         * @param resourceConfigurationSchemaType
         *        The schema type of the resource configuration.</p> <note>
         *        <p>
         *        You can find the <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html"
         *        >Resource type schema</a>, or <code>CFN_RESOURCE_SCHEMA</code>, in
         *        "<i>Amazon Web Services public extensions</i>" within the CloudFormation registry or with the
         *        following CLI commmand:
         *        <code>aws cloudformation describe-type --type-name "AWS::S3::Bucket" --type RESOURCE</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-view"
         *        >Managing extensions through the CloudFormation registry</a> and <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >Amazon Web Services resource and property types reference</a> in the CloudFormation User Guide.
         *        </p>
         * @see ResourceConfigurationSchemaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationSchemaType
         */
        Builder resourceConfigurationSchemaType(String resourceConfigurationSchemaType);

        /**
         * <p>
         * The schema type of the resource configuration.
         * </p>
         * <note>
         * <p>
         * You can find the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource
         * type schema</a>, or <code>CFN_RESOURCE_SCHEMA</code>, in "<i>Amazon Web Services public extensions</i>"
         * within the CloudFormation registry or with the following CLI commmand:
         * <code>aws cloudformation describe-type --type-name "AWS::S3::Bucket" --type RESOURCE</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-view">Managing
         * extensions through the CloudFormation registry</a> and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >Amazon Web Services resource and property types reference</a> in the CloudFormation User Guide.
         * </p>
         * </note>
         * 
         * @param resourceConfigurationSchemaType
         *        The schema type of the resource configuration.</p> <note>
         *        <p>
         *        You can find the <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html"
         *        >Resource type schema</a>, or <code>CFN_RESOURCE_SCHEMA</code>, in
         *        "<i>Amazon Web Services public extensions</i>" within the CloudFormation registry or with the
         *        following CLI commmand:
         *        <code>aws cloudformation describe-type --type-name "AWS::S3::Bucket" --type RESOURCE</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-view"
         *        >Managing extensions through the CloudFormation registry</a> and <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >Amazon Web Services resource and property types reference</a> in the CloudFormation User Guide.
         *        </p>
         * @see ResourceConfigurationSchemaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationSchemaType
         */
        Builder resourceConfigurationSchemaType(ResourceConfigurationSchemaType resourceConfigurationSchemaType);
    }

    static final class BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private String resourceConfiguration;

        private String resourceConfigurationSchemaType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            resourceConfiguration(model.resourceConfiguration);
            resourceConfigurationSchemaType(model.resourceConfigurationSchemaType);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceConfiguration() {
            return resourceConfiguration;
        }

        public final void setResourceConfiguration(String resourceConfiguration) {
            this.resourceConfiguration = resourceConfiguration;
        }

        @Override
        public final Builder resourceConfiguration(String resourceConfiguration) {
            this.resourceConfiguration = resourceConfiguration;
            return this;
        }

        public final String getResourceConfigurationSchemaType() {
            return resourceConfigurationSchemaType;
        }

        public final void setResourceConfigurationSchemaType(String resourceConfigurationSchemaType) {
            this.resourceConfigurationSchemaType = resourceConfigurationSchemaType;
        }

        @Override
        public final Builder resourceConfigurationSchemaType(String resourceConfigurationSchemaType) {
            this.resourceConfigurationSchemaType = resourceConfigurationSchemaType;
            return this;
        }

        @Override
        public final Builder resourceConfigurationSchemaType(ResourceConfigurationSchemaType resourceConfigurationSchemaType) {
            this.resourceConfigurationSchemaType(resourceConfigurationSchemaType == null ? null : resourceConfigurationSchemaType
                    .toString());
            return this;
        }

        @Override
        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
