/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns details of a specific query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StoredQueryMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<StoredQueryMetadata.Builder, StoredQueryMetadata> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(StoredQueryMetadata::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<String> QUERY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryArn").getter(getter(StoredQueryMetadata::queryArn)).setter(setter(Builder::queryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryArn").build()).build();

    private static final SdkField<String> QUERY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryName").getter(getter(StoredQueryMetadata::queryName)).setter(setter(Builder::queryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StoredQueryMetadata::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            QUERY_ARN_FIELD, QUERY_NAME_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queryId;

    private final String queryArn;

    private final String queryName;

    private final String description;

    private StoredQueryMetadata(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryArn = builder.queryArn;
        this.queryName = builder.queryName;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ID of the query.
     * </p>
     * 
     * @return The ID of the query.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the query. For example,
     * arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the query. For example,
     *         arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
     */
    public final String queryArn() {
        return queryArn;
    }

    /**
     * <p>
     * The name of the query.
     * </p>
     * 
     * @return The name of the query.
     */
    public final String queryName() {
        return queryName;
    }

    /**
     * <p>
     * A unique description for the query.
     * </p>
     * 
     * @return A unique description for the query.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(queryArn());
        hashCode = 31 * hashCode + Objects.hashCode(queryName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StoredQueryMetadata)) {
            return false;
        }
        StoredQueryMetadata other = (StoredQueryMetadata) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(queryArn(), other.queryArn())
                && Objects.equals(queryName(), other.queryName()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StoredQueryMetadata").add("QueryId", queryId()).add("QueryArn", queryArn())
                .add("QueryName", queryName()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "QueryArn":
            return Optional.ofNullable(clazz.cast(queryArn()));
        case "QueryName":
            return Optional.ofNullable(clazz.cast(queryName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("QueryArn", QUERY_ARN_FIELD);
        map.put("QueryName", QUERY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StoredQueryMetadata, T> g) {
        return obj -> g.apply((StoredQueryMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StoredQueryMetadata> {
        /**
         * <p>
         * The ID of the query.
         * </p>
         * 
         * @param queryId
         *        The ID of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the query. For example,
         * arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
         * </p>
         * 
         * @param queryArn
         *        Amazon Resource Name (ARN) of the query. For example,
         *        arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryArn(String queryArn);

        /**
         * <p>
         * The name of the query.
         * </p>
         * 
         * @param queryName
         *        The name of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryName(String queryName);

        /**
         * <p>
         * A unique description for the query.
         * </p>
         * 
         * @param description
         *        A unique description for the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String queryId;

        private String queryArn;

        private String queryName;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(StoredQueryMetadata model) {
            queryId(model.queryId);
            queryArn(model.queryArn);
            queryName(model.queryName);
            description(model.description);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryArn() {
            return queryArn;
        }

        public final void setQueryArn(String queryArn) {
            this.queryArn = queryArn;
        }

        @Override
        public final Builder queryArn(String queryArn) {
            this.queryArn = queryArn;
            return this;
        }

        public final String getQueryName() {
            return queryName;
        }

        public final void setQueryName(String queryName) {
            this.queryName = queryName;
        }

        @Override
        public final Builder queryName(String queryName) {
            this.queryName = queryName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public StoredQueryMetadata build() {
            return new StoredQueryMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
