/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The requested operation is not valid. You will see this exception if there are missing required fields or if the
 * input value fails the validation.
 * </p>
 * <p>
 * For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>, one
 * of the following errors:
 * </p>
 * <ul>
 * <li>
 * <p>
 * There are missing required fields.
 * </p>
 * </li>
 * <li>
 * <p>
 * The input value fails the validation.
 * </p>
 * </li>
 * <li>
 * <p>
 * You are trying to create more than 300 queries.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html">
 * DescribeConfigurationRecorders</a> and <a
 * href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
 * >DescribeConfigurationRecorderStatus</a>, one of the following errors:
 * </p>
 * <ul>
 * <li>
 * <p>
 * You have specified more than one configuration recorder.
 * </p>
 * </li>
 * <li>
 * <p>
 * You have provided a service principal for service-linked configuration recorder that is not valid.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
 * AssociateResourceTypes</a> and <a
 * href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
 * >DisassociateResourceTypes</a>, one of the following errors:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Your configuraiton recorder has a recording strategy that does not allow the association or disassociation of
 * resource types.
 * </p>
 * </li>
 * <li>
 * <p>
 * One or more of the specified resource types are already associated or disassociated with the configuration recorder.
 * </p>
 * </li>
 * <li>
 * <p>
 * For service-linked configuration recorders, the configuration recorder does not record one or more of the specified
 * resource types.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationException extends ConfigException implements
        ToCopyableBuilder<ValidationException.Builder, ValidationException> {
    private static final List<SdkField<?>> SDK_FIELDS = Collections.emptyList();

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private ValidationException(BuilderImpl builder) {
        super(builder);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        return Collections.emptyMap();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationException>, ConfigException.Builder {
        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends ConfigException.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
