/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactDataRequest;
import software.amazon.awssdk.services.connect.model.ContactDataRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, BatchPutContactRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(BatchPutContactRequest.getter(BatchPutContactRequest::clientToken)).setter(BatchPutContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(BatchPutContactRequest.getter(BatchPutContactRequest::instanceId)).setter(BatchPutContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<List<ContactDataRequest>> CONTACT_DATA_REQUEST_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactDataRequestList").getter(BatchPutContactRequest.getter(BatchPutContactRequest::contactDataRequestList)).setter(BatchPutContactRequest.setter(Builder::contactDataRequestList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactDataRequestList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactDataRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, INSTANCE_ID_FIELD, CONTACT_DATA_REQUEST_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("ContactDataRequestList", CONTACT_DATA_REQUEST_LIST_FIELD);
        }
    });
    private final String clientToken;
    private final String instanceId;
    private final List<ContactDataRequest> contactDataRequestList;

    private BatchPutContactRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceId = builder.instanceId;
        this.contactDataRequestList = builder.contactDataRequestList;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final boolean hasContactDataRequestList() {
        return this.contactDataRequestList != null && !(this.contactDataRequestList instanceof SdkAutoConstructList);
    }

    public final List<ContactDataRequest> contactDataRequestList() {
        return this.contactDataRequestList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactDataRequestList() ? this.contactDataRequestList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutContactRequest)) {
            return false;
        }
        BatchPutContactRequest other = (BatchPutContactRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.instanceId(), other.instanceId()) && this.hasContactDataRequestList() == other.hasContactDataRequestList() && Objects.equals(this.contactDataRequestList(), other.contactDataRequestList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutContactRequest").add("ClientToken", (Object)this.clientToken()).add("InstanceId", (Object)this.instanceId()).add("ContactDataRequestList", this.hasContactDataRequestList() ? this.contactDataRequestList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactDataRequestList": {
                return Optional.ofNullable(clazz.cast(this.contactDataRequestList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutContactRequest, T> g) {
        return obj -> g.apply((BatchPutContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String instanceId;
        private List<ContactDataRequest> contactDataRequestList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutContactRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.instanceId(model.instanceId);
            this.contactDataRequestList(model.contactDataRequestList);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final List<ContactDataRequest.Builder> getContactDataRequestList() {
            List<ContactDataRequest.Builder> result = ContactDataRequestListCopier.copyToBuilder(this.contactDataRequestList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContactDataRequestList(Collection<ContactDataRequest.BuilderImpl> contactDataRequestList) {
            this.contactDataRequestList = ContactDataRequestListCopier.copyFromBuilder(contactDataRequestList);
        }

        @Override
        public final Builder contactDataRequestList(Collection<ContactDataRequest> contactDataRequestList) {
            this.contactDataRequestList = ContactDataRequestListCopier.copy(contactDataRequestList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactDataRequestList(ContactDataRequest ... contactDataRequestList) {
            this.contactDataRequestList(Arrays.asList(contactDataRequestList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactDataRequestList(Consumer<ContactDataRequest.Builder> ... contactDataRequestList) {
            this.contactDataRequestList(Stream.of(contactDataRequestList).map(c -> (ContactDataRequest)((ContactDataRequest.Builder)ContactDataRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutContactRequest build() {
            return new BatchPutContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutContactRequest> {
        public Builder clientToken(String var1);

        public Builder instanceId(String var1);

        public Builder contactDataRequestList(Collection<ContactDataRequest> var1);

        public Builder contactDataRequestList(ContactDataRequest ... var1);

        public Builder contactDataRequestList(Consumer<ContactDataRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

