/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AttributeCondition;
import software.amazon.awssdk.services.connect.model.ExpressionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Expression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Expression> {
    private static final SdkField<AttributeCondition> ATTRIBUTE_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeCondition").getter(Expression.getter(Expression::attributeCondition)).setter(Expression.setter(Builder::attributeCondition)).constructor(AttributeCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeCondition").build()}).build();
    private static final SdkField<List<Expression>> AND_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AndExpression").getter(Expression.getter(Expression::andExpression)).setter(Expression.setter(Builder::andExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndExpression").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Expression>> OR_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrExpression").getter(Expression.getter(Expression::orExpression)).setter(Expression.setter(Builder::orExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrExpression").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_CONDITION_FIELD, AND_EXPRESSION_FIELD, OR_EXPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AttributeCondition", ATTRIBUTE_CONDITION_FIELD);
            this.put("AndExpression", AND_EXPRESSION_FIELD);
            this.put("OrExpression", OR_EXPRESSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AttributeCondition attributeCondition;
    private final List<Expression> andExpression;
    private final List<Expression> orExpression;

    private Expression(BuilderImpl builder) {
        this.attributeCondition = builder.attributeCondition;
        this.andExpression = builder.andExpression;
        this.orExpression = builder.orExpression;
    }

    public final AttributeCondition attributeCondition() {
        return this.attributeCondition;
    }

    public final boolean hasAndExpression() {
        return this.andExpression != null && !(this.andExpression instanceof SdkAutoConstructList);
    }

    public final List<Expression> andExpression() {
        return this.andExpression;
    }

    public final boolean hasOrExpression() {
        return this.orExpression != null && !(this.orExpression instanceof SdkAutoConstructList);
    }

    public final List<Expression> orExpression() {
        return this.orExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAndExpression() ? this.andExpression() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrExpression() ? this.orExpression() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)obj;
        return Objects.equals(this.attributeCondition(), other.attributeCondition()) && this.hasAndExpression() == other.hasAndExpression() && Objects.equals(this.andExpression(), other.andExpression()) && this.hasOrExpression() == other.hasOrExpression() && Objects.equals(this.orExpression(), other.orExpression());
    }

    public final String toString() {
        return ToString.builder((String)"Expression").add("AttributeCondition", (Object)this.attributeCondition()).add("AndExpression", this.hasAndExpression() ? this.andExpression() : null).add("OrExpression", this.hasOrExpression() ? this.orExpression() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeCondition": {
                return Optional.ofNullable(clazz.cast(this.attributeCondition()));
            }
            case "AndExpression": {
                return Optional.ofNullable(clazz.cast(this.andExpression()));
            }
            case "OrExpression": {
                return Optional.ofNullable(clazz.cast(this.orExpression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Expression, T> g) {
        return obj -> g.apply((Expression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AttributeCondition attributeCondition;
        private List<Expression> andExpression = DefaultSdkAutoConstructList.getInstance();
        private List<Expression> orExpression = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            this.attributeCondition(model.attributeCondition);
            this.andExpression(model.andExpression);
            this.orExpression(model.orExpression);
        }

        public final AttributeCondition.Builder getAttributeCondition() {
            return this.attributeCondition != null ? this.attributeCondition.toBuilder() : null;
        }

        public final void setAttributeCondition(AttributeCondition.BuilderImpl attributeCondition) {
            this.attributeCondition = attributeCondition != null ? attributeCondition.build() : null;
        }

        @Override
        public final Builder attributeCondition(AttributeCondition attributeCondition) {
            this.attributeCondition = attributeCondition;
            return this;
        }

        public final List<Builder> getAndExpression() {
            List<Builder> result = ExpressionsCopier.copyToBuilder(this.andExpression);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndExpression(Collection<BuilderImpl> andExpression) {
            this.andExpression = ExpressionsCopier.copyFromBuilder(andExpression);
        }

        @Override
        public final Builder andExpression(Collection<Expression> andExpression) {
            this.andExpression = ExpressionsCopier.copy(andExpression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andExpression(Expression ... andExpression) {
            this.andExpression(Arrays.asList(andExpression));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andExpression(Consumer<Builder> ... andExpression) {
            this.andExpression(Stream.of(andExpression).map(c -> (Expression)((Builder)Expression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getOrExpression() {
            List<Builder> result = ExpressionsCopier.copyToBuilder(this.orExpression);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrExpression(Collection<BuilderImpl> orExpression) {
            this.orExpression = ExpressionsCopier.copyFromBuilder(orExpression);
        }

        @Override
        public final Builder orExpression(Collection<Expression> orExpression) {
            this.orExpression = ExpressionsCopier.copy(orExpression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orExpression(Expression ... orExpression) {
            this.orExpression(Arrays.asList(orExpression));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orExpression(Consumer<Builder> ... orExpression) {
            this.orExpression(Stream.of(orExpression).map(c -> (Expression)((Builder)Expression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Expression build() {
            return new Expression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Expression> {
        public Builder attributeCondition(AttributeCondition var1);

        default public Builder attributeCondition(Consumer<AttributeCondition.Builder> attributeCondition) {
            return this.attributeCondition((AttributeCondition)((AttributeCondition.Builder)AttributeCondition.builder().applyMutation(attributeCondition)).build());
        }

        public Builder andExpression(Collection<Expression> var1);

        public Builder andExpression(Expression ... var1);

        public Builder andExpression(Consumer<Builder> ... var1);

        public Builder orExpression(Collection<Expression> var1);

        public Builder orExpression(Expression ... var1);

        public Builder orExpression(Consumer<Builder> ... var1);
    }
}

