/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AuthenticationProfileSummary;
import software.amazon.awssdk.services.connect.model.AuthenticationProfileSummaryListCopier;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuthenticationProfilesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListAuthenticationProfilesResponse> {
    private static final SdkField<List<AuthenticationProfileSummary>> AUTHENTICATION_PROFILE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthenticationProfileSummaryList").getter(ListAuthenticationProfilesResponse.getter(ListAuthenticationProfilesResponse::authenticationProfileSummaryList)).setter(ListAuthenticationProfilesResponse.setter(Builder::authenticationProfileSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationProfileSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthenticationProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAuthenticationProfilesResponse.getter(ListAuthenticationProfilesResponse::nextToken)).setter(ListAuthenticationProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_PROFILE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AuthenticationProfileSummaryList", AUTHENTICATION_PROFILE_SUMMARY_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AuthenticationProfileSummary> authenticationProfileSummaryList;
    private final String nextToken;

    private ListAuthenticationProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationProfileSummaryList = builder.authenticationProfileSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAuthenticationProfileSummaryList() {
        return this.authenticationProfileSummaryList != null && !(this.authenticationProfileSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AuthenticationProfileSummary> authenticationProfileSummaryList() {
        return this.authenticationProfileSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthenticationProfileSummaryList() ? this.authenticationProfileSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuthenticationProfilesResponse)) {
            return false;
        }
        ListAuthenticationProfilesResponse other = (ListAuthenticationProfilesResponse)((Object)obj);
        return this.hasAuthenticationProfileSummaryList() == other.hasAuthenticationProfileSummaryList() && Objects.equals(this.authenticationProfileSummaryList(), other.authenticationProfileSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAuthenticationProfilesResponse").add("AuthenticationProfileSummaryList", this.hasAuthenticationProfileSummaryList() ? this.authenticationProfileSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationProfileSummaryList": {
                return Optional.ofNullable(clazz.cast(this.authenticationProfileSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAuthenticationProfilesResponse, T> g) {
        return obj -> g.apply((ListAuthenticationProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<AuthenticationProfileSummary> authenticationProfileSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuthenticationProfilesResponse model) {
            super(model);
            this.authenticationProfileSummaryList(model.authenticationProfileSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<AuthenticationProfileSummary.Builder> getAuthenticationProfileSummaryList() {
            List<AuthenticationProfileSummary.Builder> result = AuthenticationProfileSummaryListCopier.copyToBuilder(this.authenticationProfileSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthenticationProfileSummaryList(Collection<AuthenticationProfileSummary.BuilderImpl> authenticationProfileSummaryList) {
            this.authenticationProfileSummaryList = AuthenticationProfileSummaryListCopier.copyFromBuilder(authenticationProfileSummaryList);
        }

        @Override
        public final Builder authenticationProfileSummaryList(Collection<AuthenticationProfileSummary> authenticationProfileSummaryList) {
            this.authenticationProfileSummaryList = AuthenticationProfileSummaryListCopier.copy(authenticationProfileSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProfileSummaryList(AuthenticationProfileSummary ... authenticationProfileSummaryList) {
            this.authenticationProfileSummaryList(Arrays.asList(authenticationProfileSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProfileSummaryList(Consumer<AuthenticationProfileSummary.Builder> ... authenticationProfileSummaryList) {
            this.authenticationProfileSummaryList(Stream.of(authenticationProfileSummaryList).map(c -> (AuthenticationProfileSummary)((AuthenticationProfileSummary.Builder)AuthenticationProfileSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAuthenticationProfilesResponse build() {
            return new ListAuthenticationProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAuthenticationProfilesResponse> {
        public Builder authenticationProfileSummaryList(Collection<AuthenticationProfileSummary> var1);

        public Builder authenticationProfileSummaryList(AuthenticationProfileSummary ... var1);

        public Builder authenticationProfileSummaryList(Consumer<AuthenticationProfileSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

