/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.QuickConnectSummary;
import software.amazon.awssdk.services.connect.model.QuickConnectSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueueQuickConnectsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListQueueQuickConnectsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListQueueQuickConnectsResponse.getter(ListQueueQuickConnectsResponse::nextToken)).setter(ListQueueQuickConnectsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<QuickConnectSummary>> QUICK_CONNECT_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QuickConnectSummaryList").getter(ListQueueQuickConnectsResponse.getter(ListQueueQuickConnectsResponse::quickConnectSummaryList)).setter(ListQueueQuickConnectsResponse.setter(Builder::quickConnectSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuickConnectSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ListQueueQuickConnectsResponse.getter(ListQueueQuickConnectsResponse::lastModifiedTime)).setter(ListQueueQuickConnectsResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(ListQueueQuickConnectsResponse.getter(ListQueueQuickConnectsResponse::lastModifiedRegion)).setter(ListQueueQuickConnectsResponse.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, QUICK_CONNECT_SUMMARY_LIST_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("QuickConnectSummaryList", QUICK_CONNECT_SUMMARY_LIST_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        }
    });
    private final String nextToken;
    private final List<QuickConnectSummary> quickConnectSummaryList;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private ListQueueQuickConnectsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.quickConnectSummaryList = builder.quickConnectSummaryList;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasQuickConnectSummaryList() {
        return this.quickConnectSummaryList != null && !(this.quickConnectSummaryList instanceof SdkAutoConstructList);
    }

    public final List<QuickConnectSummary> quickConnectSummaryList() {
        return this.quickConnectSummaryList;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuickConnectSummaryList() ? this.quickConnectSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueueQuickConnectsResponse)) {
            return false;
        }
        ListQueueQuickConnectsResponse other = (ListQueueQuickConnectsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasQuickConnectSummaryList() == other.hasQuickConnectSummaryList() && Objects.equals(this.quickConnectSummaryList(), other.quickConnectSummaryList()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"ListQueueQuickConnectsResponse").add("NextToken", (Object)this.nextToken()).add("QuickConnectSummaryList", this.hasQuickConnectSummaryList() ? this.quickConnectSummaryList() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "QuickConnectSummaryList": {
                return Optional.ofNullable(clazz.cast(this.quickConnectSummaryList()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListQueueQuickConnectsResponse, T> g) {
        return obj -> g.apply((ListQueueQuickConnectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<QuickConnectSummary> quickConnectSummaryList = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueueQuickConnectsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.quickConnectSummaryList(model.quickConnectSummaryList);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<QuickConnectSummary.Builder> getQuickConnectSummaryList() {
            List<QuickConnectSummary.Builder> result = QuickConnectSummaryListCopier.copyToBuilder(this.quickConnectSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuickConnectSummaryList(Collection<QuickConnectSummary.BuilderImpl> quickConnectSummaryList) {
            this.quickConnectSummaryList = QuickConnectSummaryListCopier.copyFromBuilder(quickConnectSummaryList);
        }

        @Override
        public final Builder quickConnectSummaryList(Collection<QuickConnectSummary> quickConnectSummaryList) {
            this.quickConnectSummaryList = QuickConnectSummaryListCopier.copy(quickConnectSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectSummaryList(QuickConnectSummary ... quickConnectSummaryList) {
            this.quickConnectSummaryList(Arrays.asList(quickConnectSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectSummaryList(Consumer<QuickConnectSummary.Builder> ... quickConnectSummaryList) {
            this.quickConnectSummaryList(Stream.of(quickConnectSummaryList).map(c -> (QuickConnectSummary)((QuickConnectSummary.Builder)QuickConnectSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public ListQueueQuickConnectsResponse build() {
            return new ListQueueQuickConnectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueueQuickConnectsResponse> {
        public Builder nextToken(String var1);

        public Builder quickConnectSummaryList(Collection<QuickConnectSummary> var1);

        public Builder quickConnectSummaryList(QuickConnectSummary ... var1);

        public Builder quickConnectSummaryList(Consumer<QuickConnectSummary.Builder> ... var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);
    }
}

