/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueueQuickConnectConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueueQuickConnectConfig> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueId").getter(QueueQuickConnectConfig.getter(QueueQuickConnectConfig::queueId)).setter(QueueQuickConnectConfig.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(QueueQuickConnectConfig.getter(QueueQuickConnectConfig::contactFlowId)).setter(QueueQuickConnectConfig.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD, CONTACT_FLOW_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("QueueId", QUEUE_ID_FIELD);
            this.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String queueId;
    private final String contactFlowId;

    private QueueQuickConnectConfig(BuilderImpl builder) {
        this.queueId = builder.queueId;
        this.contactFlowId = builder.contactFlowId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueQuickConnectConfig)) {
            return false;
        }
        QueueQuickConnectConfig other = (QueueQuickConnectConfig)obj;
        return Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.contactFlowId(), other.contactFlowId());
    }

    public final String toString() {
        return ToString.builder((String)"QueueQuickConnectConfig").add("QueueId", (Object)this.queueId()).add("ContactFlowId", (Object)this.contactFlowId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QueueQuickConnectConfig, T> g) {
        return obj -> g.apply((QueueQuickConnectConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queueId;
        private String contactFlowId;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueQuickConnectConfig model) {
            this.queueId(model.queueId);
            this.contactFlowId(model.contactFlowId);
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public QueueQuickConnectConfig build() {
            return new QueueQuickConnectConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueueQuickConnectConfig> {
        public Builder queueId(String var1);

        public Builder contactFlowId(String var1);
    }
}

